/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.Owned;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.entity.MagicImmune;
import com.minelittlepony.unicopia.entity.Trap;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.entity.player.LevitatedItemsInventory;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.util.VecHelper;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3324;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class LevitatingItemEntity
extends class_1297
implements Owned<class_1657>,
MagicImmune,
Trap {
    private static final class_2940<class_1799> STACK = class_2945.method_12791(LevitatingItemEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Integer> SLOT = class_2945.method_12791(LevitatingItemEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Optional<UUID>> OWNER_ID = class_2945.method_12791(LevitatingItemEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<class_2338>> MINING_POS = class_2945.method_12791(LevitatingItemEntity.class, (class_2941)class_2943.field_13315);
    private static final class_2940<class_2350> MINING_FACE = class_2945.method_12791(LevitatingItemEntity.class, (class_2941)class_2943.field_13321);
    private static final class_2940<Integer> HOLDING_POSITION = class_2945.method_12791(LevitatingItemEntity.class, (class_2941)class_2943.field_13327);
    private class_243 polarPositionOffset = class_243.field_1353;
    private class_243 manualPositionOffset = class_243.field_1353;
    @Nullable
    private class_2680 miningBlockState;
    @Nullable
    private class_2338 interactingPos;
    @Nullable
    private class_243 holdPosition;
    @Nullable
    private LevitatedItemsInventory.BlockBreakingRecord blockBreakingRecord;
    private class_243 lerpPos = class_243.field_1353;
    private int lerpTicks;
    private int swingTicks;
    @Nullable
    private class_1657 master;
    @Nullable
    private List<Action> validActions;

    LevitatingItemEntity(class_1299<? extends LevitatingItemEntity> type, class_1937 world) {
        super(type, world);
    }

    public LevitatingItemEntity(int slot, class_1657 player, class_1799 stack) {
        this(UEntities.LEVITATING_ITEM, player.method_37908());
        this.setMaster(player);
        this.setStack(stack);
        this.method_33574(player.method_19538());
        this.setPolarPositionOffset(new class_243(-0.5, 0.0, 1.5).method_1019(VecHelper.gaussian(this.method_37908().field_9229).method_1021(0.1)));
        this.setSlot(slot);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(STACK, (Object)class_1799.field_8037);
        builder.method_56912(OWNER_ID, Optional.empty());
        builder.method_56912(SLOT, (Object)0);
        builder.method_56912(MINING_POS, Optional.empty());
        builder.method_56912(MINING_FACE, (Object)class_2350.field_11036);
        builder.method_56912(HOLDING_POSITION, (Object)0);
    }

    public void setSlot(int slot) {
        this.field_6011.method_12778(SLOT, (Object)slot);
    }

    public int getSlot() {
        return (Integer)this.field_6011.method_12789(SLOT);
    }

    public void setPolarPositionOffset(class_243 newOffset) {
        this.polarPositionOffset = newOffset;
    }

    public void setManualPositionOffset(class_243 newOffset) {
        this.manualPositionOffset = newOffset;
    }

    public void setHoldingPosition(@Nullable class_243 pos) {
        this.holdPosition = pos;
        this.field_6011.method_12778(HOLDING_POSITION, (Object)(this.holdPosition == null ? 0 : 1));
    }

    public void setForcedHoldingPosition(boolean holding) {
        this.setHoldingPosition(holding ? this.method_19538() : null);
        this.field_6011.method_12778(HOLDING_POSITION, (Object)(holding ? 3 : 2));
    }

    public boolean isHoldingPosition() {
        return (Integer)this.field_6011.method_12789(HOLDING_POSITION) % 2 == 1;
    }

    public boolean canChangePositionHoldingFreely() {
        return (Integer)this.field_6011.method_12789(HOLDING_POSITION) > 1;
    }

    public class_243 getRelativePosition() {
        return this.polarPositionOffset;
    }

    public Optional<class_2338> getMiningPos() {
        return (Optional)this.field_6011.method_12789(MINING_POS);
    }

    public class_2350 getMiningFace() {
        return (class_2350)this.field_6011.method_12789(MINING_FACE);
    }

    public class_4048 method_18377(class_4050 pose) {
        class_4048 myDimensions = super.method_18377(pose);
        if (this.method_5782()) {
            class_4048 dimensions = ((class_1297)this.method_5685().getFirst()).method_18377(pose);
            return new class_4048(Math.max(dimensions.comp_2185() + 0.1f, myDimensions.comp_2185()), Math.max(dimensions.comp_2186() * 0.7f, myDimensions.comp_2186()), myDimensions.comp_2187(), myDimensions.comp_2188(), false);
        }
        return myDimensions;
    }

    public Action getDefaultAction() {
        return Action.GRAB;
    }

    public List<Action> getValidActions() {
        if (this.validActions == null) {
            this.validActions = List.copyOf((Collection)class_156.method_654(new ArrayList(), a -> this.recomputeValidActions(a::add)));
        }
        return this.validActions;
    }

    protected void recomputeValidActions(Consumer<Action> collector) {
        if (!this.method_5782()) {
            collector.accept(Action.GRAB);
        }
        collector.accept(Action.MOVE);
        collector.accept(Action.DROP);
        collector.accept(this.isHoldingPosition() ? Action.FOLLOW : Action.TETHER);
        if (this.getMiningPos().isPresent()) {
            collector.accept(Action.STOP);
        }
    }

    public void handleAction(Action action, class_1657 player, Optional<class_243> direction) {
        switch (action.ordinal()) {
            case 4: {
                if (!this.method_37908().field_9236) {
                    player.method_7270(this.getStack());
                }
                this.method_5650(class_1297.class_5529.field_26999);
                this.method_5783(class_3417.field_15197, 2.0f, 1.0f);
                break;
            }
            case 3: {
                this.method_5768();
                break;
            }
            case 5: {
                this.setHoldingPosition(null);
                break;
            }
            case 0: {
                if (!direction.isPresent()) break;
                class_243 movement = direction.get().method_1029().method_1021((double)0.1f);
                if (this.holdPosition != null) {
                    this.holdPosition = this.holdPosition.method_1019(movement);
                } else {
                    this.setManualPositionOffset(this.manualPositionOffset.method_1019(movement));
                }
                this.method_5784(class_1313.field_6308, movement);
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 7: {
                this.getMiningPos().ifPresent(this::stopMining);
                break;
            }
            case 6: {
                this.setHoldingPosition(this.method_19538());
                this.setForcedHoldingPosition(true);
            }
        }
    }

    public void setMaster(class_1657 player) {
        this.field_6011.method_12778(OWNER_ID, Optional.of(player.method_5667()));
        this.master = player;
    }

    @Override
    @Nullable
    public class_1657 getMaster() {
        Optional<UUID> masterId = this.getMasterId();
        if (masterId.isEmpty()) {
            this.master = null;
            return null;
        }
        if (this.master == null || this.master.method_5667() != masterId.get()) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 sw = (class_3218)class_19372;
                this.master = masterId.map(arg_0 -> ((class_3324)sw.method_8503().method_3760()).method_14602(arg_0)).orElse(null);
            } else {
                this.master = masterId.map(arg_0 -> ((class_1937)this.method_37908()).method_18470(arg_0)).orElse(null);
            }
        }
        return this.master;
    }

    @Override
    public Optional<UUID> getMasterId() {
        return (Optional)this.field_6011.method_12789(OWNER_ID);
    }

    public class_1799 getStack() {
        return (class_1799)this.field_6011.method_12789(STACK);
    }

    public void setStack(class_1799 stack) {
        this.field_6011.method_12778(STACK, (Object)stack);
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.lerpPos = new class_243(x, y, z);
        this.lerpTicks = 3;
        this.method_5710(yaw, pitch);
    }

    public double method_53830() {
        return this.lerpTicks > 0 ? this.lerpPos.field_1352 : this.method_23317();
    }

    public double method_53827() {
        return this.lerpTicks > 0 ? this.lerpPos.field_1351 : this.method_23318();
    }

    public double method_53828() {
        return this.lerpTicks > 0 ? this.lerpPos.field_1350 : this.method_23321();
    }

    public void swingAt(class_2338 pos) {
        this.swingTicks = 10;
        this.interactingPos = pos;
    }

    public double getAttackDamage(class_1657 player) {
        class_9285.class_9286 damageModifiersComponent = class_9285.method_57480();
        this.getStack().method_60617(class_9274.field_49217, (attribute, modifier) -> {
            if (attribute == class_5134.field_23721) {
                damageModifiersComponent.method_57487(attribute, modifier, class_9274.field_49217);
            }
        });
        class_9285 damageModifiers = damageModifiersComponent.method_57486();
        if (damageModifiers.comp_2393().isEmpty()) {
            return 0.0;
        }
        return damageModifiers.method_57481(player.method_45325(class_5134.field_23721), class_1304.field_6173);
    }

    public boolean startMining(class_1657 miner, LevitatedItemsInventory.BlockBreakingRecord blockBreakingRecord, class_2350 direction) {
        if (this.getMiningPos().isPresent()) {
            return false;
        }
        if (!this.getStack().method_7909().method_7885(blockBreakingRecord.state, this.method_37908(), blockBreakingRecord.pos, miner)) {
            return false;
        }
        if (!blockBreakingRecord.state.method_29291() || this.getStack().method_7951(blockBreakingRecord.state)) {
            this.stopMining(blockBreakingRecord.pos);
            this.field_6011.method_12778(MINING_POS, Optional.of(blockBreakingRecord.pos));
            this.field_6011.method_12778(MINING_FACE, (Object)direction);
            this.blockBreakingRecord = blockBreakingRecord;
            blockBreakingRecord.claimants.add(this);
            this.setHoldingPosition(this.method_19538());
            return true;
        }
        return false;
    }

    public void stopMining(class_2338 pos) {
        if (pos.equals(this.getMiningPos().orElse(null))) {
            this.field_6011.method_12778(MINING_POS, Optional.empty());
            this.miningBlockState = null;
            if (this.blockBreakingRecord != null) {
                this.blockBreakingRecord.claimants.remove(this);
            }
            this.blockBreakingRecord = null;
            this.setHoldingPosition(null);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 sw = (class_3218)class_19372;
                sw.method_8517(this.method_5628(), pos, -1);
            }
        }
    }

    public void method_5773() {
        class_3218 sw;
        class_1937 class_19372;
        @Nullable class_1657 master = this.getMaster();
        if (master == null) {
            this.method_5648(true);
            return;
        }
        this.method_5648(false);
        if (master.method_29504()) {
            this.method_5768();
        }
        this.method_18382();
        if (this.getStack().method_7960() && this.method_5685().isEmpty()) {
            this.method_31472();
        }
        if ((class_19372 = master.method_37908()) instanceof class_3218) {
            sw = (class_3218)class_19372;
            if (master.method_37908() != this.method_37908()) {
                class_243 newPos = master.method_19538().method_1019(this.polarPositionOffset);
                this.method_48105(sw, newPos.field_1352, newPos.field_1351, newPos.field_1350, class_2709.field_40710, 0.0f, 0.0f);
            }
        }
        super.method_5773();
        this.updatePosition(master);
        class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            sw = (class_3218)class_19372;
            if (this.getMiningPos().isPresent() && this.blockBreakingRecord != null) {
                this.tickMining(master, sw, this.blockBreakingRecord);
            }
        }
        if (this.method_37908().field_9236 && this.method_59922().method_43048(10) == 0) {
            ParticleUtils.spawnParticles(new MagicParticleEffect(-1), this, 1 + this.method_59922().method_43048(2));
        }
    }

    private void tickMining(class_1657 master, class_3218 sw, LevitatedItemsInventory.BlockBreakingRecord blockBreakingRecord) {
        class_2680 state = this.method_37908().method_8320(blockBreakingRecord.pos);
        this.method_5702(class_2183.class_2184.field_9851, blockBreakingRecord.pos.method_46558());
        if (state.method_26215() || !state.equals(blockBreakingRecord.state) || !master.method_36971((class_1937)sw, blockBreakingRecord.pos) || this.method_5707(blockBreakingRecord.pos.method_46558()) > 100.0) {
            this.stopMining(blockBreakingRecord.pos);
        } else {
            FakePlayer fakePlayer = FakePlayer.get((class_3218)sw, (GameProfile)new GameProfile((UUID)this.getMasterId().orElse(null), "[Levitated Item Entity " + this.method_5667().toString() + "]"));
            fakePlayer.method_6122(class_1268.field_5808, this.getStack());
            blockBreakingRecord.breakingProgress += state.method_26165((class_1657)fakePlayer, (class_1922)sw, blockBreakingRecord.pos);
            if (this.field_6012 % 4 == 0) {
                class_2498 group = state.method_26231();
                sw.method_8396(null, blockBreakingRecord.pos, state.method_26231().method_10596(), class_3419.field_15245, (group.method_10597() + 1.0f) / 8.0f, group.method_10599() / 2.0f);
            }
            if (blockBreakingRecord.breakingProgress >= 1.0f) {
                if (!fakePlayer.field_13974.method_14266(blockBreakingRecord.pos)) {
                    ((class_3222)master).field_13987.method_14364((class_2596)new class_2626(blockBreakingRecord.pos, sw.method_8320(blockBreakingRecord.pos)));
                }
                this.stopMining(blockBreakingRecord.pos);
            } else {
                int stage = (int)(blockBreakingRecord.breakingProgress * 10.0f);
                if (stage != blockBreakingRecord.breakingStage) {
                    blockBreakingRecord.breakingStage = stage;
                    sw.method_8517(this.method_5628(), blockBreakingRecord.pos, blockBreakingRecord.breakingStage);
                }
            }
        }
    }

    private void updatePosition(class_1657 master) {
        if (this.method_5787()) {
            boolean isBeingLookedAt;
            if (!master.method_21823() && this.holdPosition != null && this.blockBreakingRecord == null && this.method_5858((class_1297)master) < 4.0 && this.canChangePositionHoldingFreely()) {
                this.setHoldingPosition(null);
            }
            boolean bl = isBeingLookedAt = Pony.of(master).isLookingAt(this) || this.method_5794((class_1297)master);
            class_243 targetPosition = isBeingLookedAt ? this.method_19538().method_1031(0.0, (double)(class_3532.method_15374((float)((float)this.field_6012 / 15.0f)) * 0.02f), 0.0) : (this.holdPosition == null ? master.method_33571().method_1019(master.method_5631((float)this.polarPositionOffset.field_1352 * 57.295776f, master.method_43078() + (float)this.polarPositionOffset.field_1350 * 57.295776f)).method_1019(this.manualPositionOffset) : this.holdPosition).method_1031(0.0, (double)(class_3532.method_15374((float)((float)this.field_6012 / 15.0f)) * 0.2f + 0.2f), 0.0);
            class_2338 miningPos = this.getMiningPos().orElse(null);
            if (miningPos != null) {
                targetPosition = VecHelper.lerp(this.getSwingProgress(), targetPosition, miningPos.method_46558());
            }
            if (this.interactingPos != null) {
                targetPosition = VecHelper.lerp(this.getSwingProgress(), this.interactingPos.method_46558(), targetPosition);
                if (this.swingTicks <= -10) {
                    this.interactingPos = null;
                }
            }
            this.method_5784(class_1313.field_6308, targetPosition.method_1020(this.method_19538()).method_1021(0.3));
            this.lerpTicks = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.lerpTicks > 0) {
            this.method_52532(this.lerpTicks, this.lerpPos.field_1352, this.lerpPos.field_1351, this.lerpPos.field_1350, this.method_36454(), this.method_36455());
            --this.lerpTicks;
        }
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        if (!this.field_5960 && this.method_5782()) {
            class_238 box;
            class_1297 passenger = (class_1297)this.method_5685().get(0);
            class_243 adjustedMovement = class_1297.method_20736((class_1297)passenger, (class_243)movement, (class_238)(box = passenger.method_5829()), (class_1937)this.method_37908(), (List)this.method_37908().method_20743(passenger, box.method_18804(movement)));
            if (!adjustedMovement.equals((Object)movement)) {
                class_243 downMove = movement.method_1031(0.0, this.master.method_23318() - this.method_23318() - 1.0, 0.0);
                adjustedMovement = class_1297.method_20736((class_1297)passenger, (class_243)downMove, (class_238)box, (class_1937)this.method_37908(), (List)this.method_37908().method_20743(passenger, box.method_18804(downMove)));
            }
            movement = adjustedMovement;
        }
        super.method_5784(movementType, movement);
    }

    private float getSwingProgress() {
        if (this.getMiningPos().isPresent()) {
            return (float)this.field_6012 % 10.0f / 10.0f;
        }
        if (this.isSwinging()) {
            --this.swingTicks;
            return class_3532.method_15363((float)((float)Math.abs(this.swingTicks) / 10.0f), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public boolean isSwinging() {
        return this.swingTicks > -10;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        InteractionManager.getInstance().interactLevitatingItem(this, player);
        return class_1269.field_5811;
    }

    @Override
    public boolean attemptDismount(class_1297 passenger) {
        class_1282 class_12822;
        if (!(passenger instanceof class_1309)) {
            return true;
        }
        class_1309 living = (class_1309)passenger;
        Pony master = Pony.of(this.getMaster());
        if (master == null) {
            return true;
        }
        this.method_5783(USounds.ENTITY_PLAYER_KICK, 0.6f, (float)this.field_5974.method_43385(0.6, 0.3));
        this.method_37908().method_20290(3003, this.method_24515(), class_2248.method_9507((class_2680)class_2246.field_10030.method_9564()));
        this.method_32875((class_6880)class_5712.field_45148, passenger);
        class_1657 class_16572 = (class_1657)master.asEntity();
        if (passenger instanceof class_1657) {
            class_1657 player = (class_1657)passenger;
            class_12822 = this.method_48923().method_48802(player);
        } else {
            class_12822 = this.method_48923().method_48812(living);
        }
        class_16572.method_5643(class_12822, 0.5f);
        return master.subtractEnergyCost(10.0);
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (STACK.equals(data)) {
            this.getStack().method_27320((class_1297)this);
        }
        if (HOLDING_POSITION.equals(data) || MINING_POS.equals(data)) {
            this.validActions = null;
        }
        if (this.method_37908().field_9236 && (OWNER_ID.equals(data) || SLOT.equals(data))) {
            class_1657 master;
            if (this.master != null) {
                Pony.of(this.master).getLevitatingItems().onEntityDespawned(this);
            }
            if ((master = this.getMaster()) != null) {
                Pony.of(master).getLevitatingItems().onEntitySpawned(this);
            }
        }
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (reason == class_1297.class_5529.field_26998) {
            this.dropAsItemEntity();
        }
        super.method_5650(reason);
    }

    protected double method_7490() {
        return 0.0;
    }

    public void dropAsItemEntity() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            class_243 dropPos = this.method_19538();
            sw.method_8649((class_1297)new class_1542((class_1937)sw, dropPos.field_1352, dropPos.field_1351, dropPos.field_1350, this.getStack()));
        }
    }

    protected void method_5749(class_2487 nbt) {
        this.setStack(class_1799.method_57359((class_7225.class_7874)this.method_37908().method_30349(), (class_2487)nbt.method_10562("stack")));
        this.field_6011.method_12778(OWNER_ID, nbt.method_25928("owner") ? Optional.of(nbt.method_25926("owner")) : Optional.empty());
        class_2499 polarOffset = nbt.method_10554("polarPositionOffset", 6);
        class_2499 manualOffset = nbt.method_10554("manualPositionOffset", 6);
        this.setPolarPositionOffset(NbtSerialisable.readPositionVector(polarOffset));
        this.setManualPositionOffset(NbtSerialisable.readPositionVector(manualOffset));
        if (nbt.method_10573("holdPosition", 9)) {
            this.setHoldingPosition(NbtSerialisable.readPositionVector(nbt.method_10554("holdPosition", 6)));
        }
        this.setForcedHoldingPosition(this.holdPosition != null && nbt.method_10577("movementRestricted"));
    }

    protected void method_5652(class_2487 nbt) {
        if (!this.getStack().method_7960()) {
            nbt.method_10566("stack", this.getStack().method_57358((class_7225.class_7874)this.method_37908().method_30349()));
        }
        this.getMasterId().ifPresent(owner -> nbt.method_25927("owner", owner));
        nbt.method_10566("polarPositionOffset", (class_2520)this.method_5846(new double[]{this.polarPositionOffset.field_1352, this.polarPositionOffset.field_1351, this.polarPositionOffset.field_1350}));
        nbt.method_10566("manualPositionOffset", (class_2520)this.method_5846(new double[]{this.manualPositionOffset.field_1352, this.manualPositionOffset.field_1351, this.manualPositionOffset.field_1350}));
        if (this.holdPosition != null) {
            nbt.method_10566("holdPosition", (class_2520)this.method_5846(new double[]{this.holdPosition.field_1352, this.holdPosition.field_1351, this.holdPosition.field_1350}));
        }
        nbt.method_10556("movementRestricted", !this.canChangePositionHoldingFreely());
    }

    public void method_5878(class_1297 original) {
        super.method_5878(original);
        if (original instanceof LevitatingItemEntity) {
            LevitatingItemEntity l = (LevitatingItemEntity)original;
            this.setSlot(l.getSlot());
        }
    }

    public boolean method_5732() {
        return true;
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_31746() {
        return this.method_5782() && super.method_31746();
    }

    public boolean method_5753() {
        return this.getStack().method_57826(class_9334.field_50076) || super.method_5753();
    }

    public boolean method_5679(class_1282 damage) {
        return !this.method_5655() && super.method_5679(damage);
    }

    public boolean method_5655() {
        return this.field_6012 < 50 || super.method_5655();
    }

    public class_2596<class_2602> method_18002(class_3231 entry) {
        class_1657 master = this.getMaster();
        return new class_2604((class_1297)this, entry, master == null ? 0 : master.method_5628());
    }

    public void method_36209() {
        @Nullable class_1657 master = this.getMaster();
        if (master != null) {
            Pony.of(master).getLevitatingItems().onEntityDespawned(this);
        }
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        class_1297 class_12972 = this.method_37908().method_8469(packet.method_11166());
        if (class_12972 instanceof class_1657) {
            class_1657 m;
            this.master = m = (class_1657)class_12972;
        }
    }

    public static enum Action {
        MOVE,
        MOVE_VERTICALLY,
        MOVE_HORIZONTALLY,
        DROP,
        GRAB,
        FOLLOW,
        TETHER,
        STOP;

        private final class_2561 label = class_2561.method_43471((String)("entity.unicopia.levitating_item.action." + this.name().toLowerCase(Locale.ROOT)));

        public int getU() {
            return this.ordinal() % 4;
        }

        public int getV() {
            return this.ordinal() / 4;
        }

        public class_2561 getLabel() {
            return this.label;
        }
    }
}

