/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.google.common.collect.ImmutableSet;
import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractDisguiseSpell;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.entity.AmuletSelectors;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.ai.ArenaAttackGoal;
import com.minelittlepony.unicopia.entity.mob.ArenaCombatant;
import com.minelittlepony.unicopia.entity.mob.CrystalShardsEntity;
import com.minelittlepony.unicopia.entity.mob.StormCloudEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.AmuletItem;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.particle.FollowingParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleSource;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.util.VecHelper;
import com.minelittlepony.unicopia.util.shape.Sphere;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_11;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1369;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1439;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1924;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_4255;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class SombraEntity
extends class_1588
implements ArenaCombatant,
ParticleSource<SombraEntity> {
    static final byte BITE = 70;
    static final int MAX_BITE_TIME = 20;
    static final Predicate<class_1297> EFFECT_TARGET_PREDICATE = class_1301.field_6156.and(e -> e instanceof class_1657).and(e -> !(AbstractDisguiseSpell.getAppearance(e) instanceof SombraEntity));
    private static final class_2940<Optional<class_2338>> HOME_POS = class_2945.method_12791(SombraEntity.class, (class_2941)class_2943.field_13315);
    private static final class_2940<Float> TARGET_SIZE = class_2945.method_12791(SombraEntity.class, (class_2941)class_2943.field_13320);
    private final class_3213 bossBar;
    final EntityReference<StormCloudEntity> stormCloud = new EntityReference();
    private int prevBiteTime;
    private int biteTime;
    private float prevSize;
    private float currentSize;

    public static void startEncounter(class_1937 world, class_2338 pos) {
        if (world.method_8390(class_1297.class, new class_238(pos).method_1014(16.0), e -> {
            if (e instanceof SombraEntity) return true;
            if (!(e instanceof StormCloudEntity)) return false;
            StormCloudEntity cloud = (StormCloudEntity)e;
            if (!cloud.cursed) return false;
            return true;
        }).size() > 0) {
            return;
        }
        StormCloudEntity cloud = (StormCloudEntity)UEntities.STORM_CLOUD.method_5883(world);
        cloud.method_33574(pos.method_10086(10).method_46558());
        cloud.setSize(1.0f);
        cloud.cursed = true;
        world.method_8649((class_1297)cloud);
    }

    public SombraEntity(class_1299<SombraEntity> type, class_1937 world) {
        this(type, world, null);
    }

    public SombraEntity(class_1299<SombraEntity> type, class_1937 world, @Nullable class_3213 bossBar) {
        super(type, world);
        this.bossBar = bossBar == null ? SombraEntity.createBossBar(this.method_5476()) : bossBar;
        this.bossBar.method_5413(this.method_5476());
        this.bossBar.method_5409(class_1259.class_1261.field_5791);
    }

    public static class_3213 createBossBar(class_2561 name) {
        return new SombraBossBar(name);
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 2000.0).method_26868(class_5134.field_23722, 1.5).method_26868(class_5134.field_23721, 22.0);
    }

    @Override
    public SombraEntity asEntity() {
        return this;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public boolean method_5696() {
        return true;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_38069;
    }

    protected class_3414 method_6002() {
        return class_3417.field_38065;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HOME_POS, Optional.empty());
        builder.method_56912(TARGET_SIZE, (Object)Float.valueOf(1.0f));
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, new ArenaAttackGoal<SombraEntity>(this));
        this.field_6201.method_6277(2, (class_1352)new class_1359((class_1308)this, 1.3f));
        this.field_6201.method_6277(2, (class_1352)new class_4255((class_1308)this, true));
        this.field_6201.method_6277(2, (class_1352)new class_1369((class_1314)this, 1.5, 32.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1309.class, 32.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3988.class, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1588.class, true));
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1409 nav = new class_1409((class_1308)this, world){

            protected class_13 method_6336(int range) {
                this.field_6678 = new class_6();
                this.field_6678.method_15(true);
                return new class_13(this.field_6678, range);
            }

            protected boolean method_6341(class_243 origin, class_243 target) {
                return class_1407.method_43394((class_1308)this.field_6684, (class_243)origin, (class_243)target, (boolean)true);
            }

            protected boolean method_6358() {
                return this.method_6350() && SombraEntity.this.method_52535() || !this.field_6684.method_5765();
            }

            protected class_243 method_6347() {
                return this.field_6684.method_19538();
            }

            @Nullable
            public class_11 method_6348(class_2338 target, int distance) {
                return this.method_35142((Set)ImmutableSet.of((Object)target), 8, false, distance);
            }
        };
        nav.method_6363(true);
        nav.method_6354(true);
        nav.method_35139(true);
        nav.method_48158(class_7.field_25418);
        return nav;
    }

    @Override
    public Optional<class_2338> getHomePos() {
        return (Optional)this.field_6011.method_12789(HOME_POS);
    }

    public void setHomePos(class_2338 pos) {
        this.field_6011.method_12778(HOME_POS, Optional.of(pos));
    }

    public void setHomePos(Optional<class_2338> pos) {
        this.field_6011.method_12778(HOME_POS, pos);
    }

    public float getBiteAmount(float tickDelta) {
        float progress = (float)class_3532.method_48781((float)tickDelta, (int)this.prevBiteTime, (int)this.biteTime) / 20.0f;
        return 1.0f - Math.abs(class_3532.method_15374((float)(progress * (float)Math.PI * 3.0f)));
    }

    public float method_17825() {
        return Math.max(1.0f, ((Float)this.field_6011.method_12789(TARGET_SIZE)).floatValue());
    }

    public float getScaleFactor(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevSize, (float)this.currentSize);
    }

    public void setScaleFactor(float targetSize) {
        this.field_6011.method_12778(TARGET_SIZE, (Object)Float.valueOf(targetSize));
        this.method_18382();
    }

    public void method_5773() {
        this.method_5971();
        Optional<class_2338> homePos = this.getHomePos();
        if (homePos.isEmpty()) {
            this.setHomePos(this.method_37908().method_8598(class_2902.class_2903.field_13203, this.method_24515()));
            homePos = this.getHomePos();
        }
        if (!this.method_31481()) {
            if (this.method_5942().method_6357() && this.method_24515().method_10262((class_2382)homePos.get()) > (double)class_3532.method_27285((float)this.getAreaRadius())) {
                this.teleportTo(class_243.method_24953((class_2382)((class_2382)homePos.get())));
                this.method_5942().method_6340();
            }
            this.prevBiteTime = this.biteTime;
            if (this.biteTime > 0) {
                --this.biteTime;
            }
            float targetSize = this.method_17825();
            boolean sizeChanging = this.prevSize != this.currentSize;
            this.prevSize = this.currentSize;
            this.tickGrowth(targetSize, sizeChanging);
        }
        super.method_5773();
        if (this.method_5968() == null && this.method_18798().field_1351 < (double)-0.1f) {
            this.method_18799(this.method_18798().method_18805(1.0, 0.4, 1.0));
        }
        this.method_5762(0.0, 0.0442f, 0.0);
        class_1309 target = this.method_5968();
        if (target != null && target.method_23318() > this.method_23318() && this.method_18798().method_10214() < 0.5) {
            float velocityChange = (float)class_3532.method_15350((double)((target.method_23318() - this.method_23318()) * (double)0.05f), (double)-0.3f, (double)0.3f);
            if (target instanceof class_1528 || target instanceof class_1307) {
                target.method_5762(0.0, (double)(-velocityChange * 20.0f), 0.0);
            } else {
                this.method_5762(0.0, velocityChange, 0.0);
            }
        }
        if (this.method_29504()) {
            return;
        }
        if (this.method_5869()) {
            this.method_6043();
        }
        if (this.field_5974.method_43048(1200) == 0) {
            this.laugh();
        }
        if (this.field_5974.method_43048(340) == 0) {
            this.method_5783((class_3414)class_3417.field_14564.comp_349(), 1.0f, 0.3f);
        } else if (this.field_5974.method_43048(1340) == 0) {
            this.method_5783(USounds.ENTITY_SOMBRA_AMBIENT, 1.0f, 1.0f);
        }
        if (this.method_37908().field_9236) {
            this.generateBodyParticles();
        } else {
            if (((class_1928.class_4310)this.method_37908().method_8450().method_20746(class_1928.field_19388)).method_20753()) {
                for (class_2338 p : class_2338.method_25996((class_2338)this.method_24515(), (int)2, (int)1, (int)2)) {
                    if (this.method_37908().method_8320(p).method_26213() <= 13) continue;
                    this.destroyLightSource(p);
                }
            }
            float healthPercentage = 100.0f * (this.method_6032() / this.method_6063());
            float difference = class_3532.method_15379((float)(healthPercentage - (float)class_3532.method_15375((float)healthPercentage)));
            if (this.field_5974.method_43048(healthPercentage < 90.0f && difference < 0.25f ? 19 : 120) == 0) {
                for (class_2338 p : class_2338.method_34848((class_5819)this.field_5974, (int)5, (class_2338)this.method_24515(), (int)20)) {
                    CrystalShardsEntity.infestBlock((class_3218)this.method_37908(), p);
                }
            }
            if (this.method_5968() == null && this.method_5942().method_6357()) {
                this.method_5942().method_6337((double)homePos.get().method_10263(), (double)(homePos.get().method_10264() + 5), (double)homePos.get().method_10260(), 2.0);
            }
        }
        if (this.method_5968() != null && this.method_5968().method_31481()) {
            this.method_5980(null);
        }
        if (this.method_6032() < this.method_6063()) {
            for (class_1297 shard : this.method_37908().method_8390(CrystalShardsEntity.class, this.method_5829().method_1014(50.0), class_1301.field_6154)) {
                if (this.field_6012 % 150 != 0) continue;
                this.method_6025(2.0f);
                ParticleUtils.spawnParticle(this.method_37908(), new FollowingParticleEffect(UParticles.HEALTH_DRAIN, (class_1297)this, 0.2f).withChild((class_2394)class_2398.field_17431), shard.method_19538(), class_243.field_1353);
            }
        }
        this.getHomePos().ifPresent(this::generateArenaEffects);
    }

    protected void tickGrowth(float targetSize, boolean changing) {
        if (this.currentSize != targetSize) {
            float sizeDifference = ((Float)this.field_6011.method_12789(TARGET_SIZE)).floatValue() - this.currentSize;
            this.currentSize = Math.abs(sizeDifference) < 0.01f ? targetSize : this.currentSize + sizeDifference * 0.2f;
            this.method_18382();
        }
        if (this.currentSize == targetSize && changing) {
            this.laugh();
        }
        if (this.currentSize == targetSize && this.method_29504()) {
            this.setScaleFactor(this.currentSize + 1.0f);
        }
    }

    private void laugh() {
        if (!this.method_37908().field_9236) {
            this.method_5783(USounds.ENTITY_SOMBRA_LAUGH, 1.0f, 1.0f);
            this.method_37908().method_8421((class_1297)this, (byte)70);
        }
    }

    protected void applyAreaEffects(class_1657 target) {
        if (this.field_6012 % 150 == 0) {
            target.method_5783(this.field_5974.method_43048(30) == 0 ? USounds.ENTITY_SOMBRA_AMBIENT : (this.field_5974.method_43048(10) == 0 ? USounds.ENTITY_SOMBRA_SCARY : (class_3414)USounds.Vanilla.field_14564.comp_349()), (float)this.field_5974.method_43385(1.0, (double)0.2f), (float)this.field_5974.method_43385((double)0.3f, (double)0.2f));
        }
        if (this.field_6012 % 1000 < 50) {
            target.method_6092(new class_1293(class_1294.field_5919, 26, 0, true, false));
            target.method_6092(new class_1293(class_1294.field_38092, 26, 0, true, false));
        }
        if (this.method_5968() == null && target.method_5739((class_1297)this) < this.getAreaRadius() / 2.0f && this.teleportTo(target.method_19538())) {
            this.method_33574(this.method_19538().method_1031(0.0, 4.0, 0.0));
        }
    }

    protected void destroyLightSource(class_2338 pos) {
        this.method_37908().method_22352(pos, true);
        this.method_5783(USounds.ENTITY_SOMBRA_SNICKER, 1.0f, 1.0f);
    }

    protected void generateBodyParticles() {
        for (int i = 0; i < 3; ++i) {
            this.method_37908().method_8406((class_2394)class_2398.field_11237, this.field_5974.method_43385(this.method_23317(), 3.0), this.field_5974.method_43385(this.method_23318(), 3.0), this.field_5974.method_43385(this.method_23321(), 3.0), 0.0, 0.0, 0.0);
        }
    }

    private void generateArenaEffects(class_2338 home) {
        if (this.method_37908().method_8608()) {
            Stream.concat(new Sphere(false, this.getAreaRadius()).translate((class_2382)home).randomPoints(this.field_5974).filter(this::isSurfaceBlock).limit(80L), new Sphere(true, this.getAreaRadius()).translate((class_2382)home).randomPoints(this.field_5974).filter(this::isSurfaceBlock).limit(30L)).forEach(pos -> {
                class_2400 type = this.field_5974.method_43048(3) < 1 ? class_2398.field_11237 : class_2398.field_22246;
                ParticleUtils.spawnParticle(this.method_37908(), (class_2394)type, pos, class_243.field_1353);
                ParticleUtils.spawnParticle(this.method_37908(), (class_2394)type, pos, pos.method_1020(this.method_19538()).method_1031(0.0, 0.1, 0.0).method_1021(-0.013));
            });
        } else {
            VecHelper.findInRange((class_1297)this, (class_1924)this.method_37908(), home.method_46558(), this.getAreaRadius() - 0.2f, EFFECT_TARGET_PREDICATE).forEach(e -> this.applyAreaEffects((class_1657)e));
        }
    }

    private boolean isSurfaceBlock(class_243 pos) {
        class_2338 bPos = class_2338.method_49638((class_2374)pos);
        return this.method_37908().method_22347(bPos) && !this.method_37908().method_22347(bPos.method_10074());
    }

    protected void method_5958() {
        super.method_5958();
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
    }

    public boolean method_5640(double distance) {
        double d = 64.0 * SombraEntity.method_5824();
        return distance < d * d;
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 cause) {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            TrinketsDelegate.EquippedStack amulet;
            class_1657 player = (class_1657)class_12972;
            if (AmuletSelectors.ALICORN_AMULET.test((class_1309)player) && !this.method_37908().field_9236) {
                this.method_5783(USounds.ENTITY_SOMBRA_SNICKER, 1.0f, 1.0f);
                player.method_43496((class_2561)class_2561.method_43471((String)"entity.unicopia.sombra.taunt"));
            }
            if (!(amulet = AmuletItem.getForEntity((class_1309)player, (class_1935)UItems.ALICORN_AMULET)).stack().method_7960()) {
                amulet.stack().method_7934(1);
                amulet.sendUpdate().run();
            }
        }
        boolean damaged = super.method_5643(source, amount);
        if (!this.method_37908().field_9236) {
            float targetSize;
            class_1297 class_12973 = source.method_5529();
            if (class_12973 instanceof class_1309) {
                class_1657 player;
                class_1309 attacker = (class_1309)class_12973;
                this.teleportRandomly(6);
                if (!(attacker instanceof class_1657) || !(player = (class_1657)attacker).method_7337() && !player.method_7325()) {
                    this.method_5980(attacker);
                }
            }
            if ((targetSize = this.method_17825()) > 1.0f) {
                this.setScaleFactor(Math.max(1.0f, targetSize * 0.9f));
            }
        }
        return damaged;
    }

    public void method_6078(class_1282 damageSource) {
        if (!this.field_6272) {
            this.stormCloud.ifPresent(this.method_37908(), cloud -> {
                cloud.setStormTicks(0);
                cloud.setDissipating(true);
            });
            this.stormCloud.set(null);
            this.getHomePos().ifPresent(home -> {
                VecHelper.findInRange((class_1297)this, (class_1924)this.method_37908(), home.method_46558(), this.getAreaRadius() - 0.2f, e -> e instanceof CrystalShardsEntity).forEach(e -> ((CrystalShardsEntity)e).setDecaying(true));
                VecHelper.findInRange((class_1297)this, (class_1924)this.method_37908(), home.method_46558(), this.getAreaRadius() - 0.2f, EFFECT_TARGET_PREDICATE).forEach(player -> {
                    Pony.of((class_1657)player).getCorruption().set(0);
                    UCriteria.DEFEAT_SOMBRA.trigger((class_1297)player);
                });
            });
        }
        super.method_6078(damageSource);
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
        super.method_6099(world, source, causedByPlayer);
        class_1542 itemEntity = this.method_5706((class_1935)UItems.BROKEN_ALICORN_AMULET);
        if (itemEntity != null) {
            itemEntity.method_6976();
        }
    }

    protected void method_6108() {
        if (++this.field_6213 >= 180 && this.field_6213 <= 200) {
            this.method_37908().method_8406((class_2394)class_2398.field_11221, this.field_5974.method_43385(this.method_23317(), 4.0), this.field_5974.method_43385(this.method_23318() + 2.0, 2.0), this.field_5974.method_43385(this.method_23321(), 4.0), 0.0, 0.0, 0.0);
        }
        this.method_5784(class_1313.field_6308, new class_243(0.0, (double)0.3f, 0.0));
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            boolean dropLoot = this.method_37908().method_8450().method_8355(class_1928.field_19391);
            int experience = 500;
            if (this.field_6213 > 150 && this.field_6213 % 5 == 0 && dropLoot) {
                class_1303.method_31493((class_3218)sw, (class_243)this.method_19538(), (int)class_3532.method_15375((float)40.0f));
            }
            if (this.field_6213 == 1 && !this.method_5701()) {
                this.method_37908().method_8474(1028, this.method_24515(), 0);
            }
            if (this.field_6213 == 200) {
                if (dropLoot) {
                    class_1303.method_31493((class_3218)sw, (class_243)this.method_19538(), (int)class_3532.method_15375((float)100.0f));
                }
                this.method_5650(class_1297.class_5529.field_26998);
                this.method_32876((class_6880)class_5712.field_37676);
            }
        }
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    public boolean method_18395(class_1309 target) {
        if (target instanceof SombraEntity || EquinePredicates.IS_MAGIC_IMMUNE.test((class_1297)target) || !class_1301.field_6156.test(target)) {
            return false;
        }
        if (target != null && !target.method_31481() && target == this.method_5968()) {
            return true;
        }
        return super.method_18395(target) && this.getHomePos().filter(home -> target.method_19538().method_24802((class_2374)home.method_46558(), (double)this.getAreaRadius())).isPresent();
    }

    public boolean method_18407(class_2338 pos) {
        class_2338 center = this.getHomePos().orElse(this.method_24515());
        double distance = pos.method_10268((double)center.method_10263() + 0.5, (double)center.method_10264() + 0.5, (double)center.method_10260() + 0.5);
        return distance < (double)class_3532.method_27285((float)this.getAreaRadius());
    }

    public boolean method_6121(class_1297 target) {
        this.laugh();
        return super.method_6121(target);
    }

    public void method_5711(byte status) {
        if (status == 70) {
            this.biteTime = 20;
        } else {
            super.method_5711(status);
        }
    }

    protected boolean teleportRandomly(int maxDistance) {
        if (this.method_37908().method_8608() || !this.method_5805()) {
            return false;
        }
        return this.teleportTo(this.method_19538().method_1019(VecHelper.triangular(this.field_5974, 0.0, maxDistance)));
    }

    @Override
    public boolean teleportTo(class_243 destination) {
        class_243 oldPos = this.method_19538();
        if (this.canTeleportTo(destination) && this.method_6082(destination.field_1352, destination.field_1351, destination.field_1350, true)) {
            this.method_37908().method_32888((class_6880)class_5712.field_39446, oldPos, class_5712.class_7397.method_43285((class_1297)this));
            return true;
        }
        return false;
    }

    private boolean canTeleportTo(class_243 destination) {
        class_2338.class_2339 mutable = new class_2338.class_2339(destination.field_1352, destination.field_1351, destination.field_1350);
        while (mutable.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutable).method_51366()) {
            mutable.method_10098(class_2350.field_11033);
        }
        class_2680 destinationState = this.method_37908().method_8320((class_2338)mutable);
        return destinationState.method_51366() && !destinationState.method_26227().method_15767(class_3486.field_15517);
    }

    @Deprecated
    public float method_5718() {
        return super.method_5718() * 0.2f;
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.getHomePos().map(class_2512::method_10692).ifPresent(pos -> nbt.method_10566("homePos", pos));
        nbt.method_10566("cloud", (class_2520)this.stormCloud.toNBT((class_7225.class_7874)this.method_56673()));
        nbt.method_10548("size", this.method_17825());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("homePos", 10)) {
            this.setHomePos(class_2512.method_10691((class_2487)nbt, (String)"homePos"));
        }
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        this.setScaleFactor(nbt.method_10583("size"));
        this.stormCloud.fromNBT(nbt.method_10562("cloud"), (class_7225.class_7874)this.method_56673());
    }

    private static class SombraBossBar
    extends class_3213 {
        public SombraBossBar(class_2561 displayName) {
            super(displayName, class_1259.class_1260.field_5783, class_1259.class_1261.field_5795);
            this.method_5406(true);
            this.method_5411(true);
            this.method_5410(true);
        }

        public void method_5408(float percent) {
            super.method_5408(percent);
            if (percent > 0.6f && this.method_5420() == class_1259.class_1260.field_5783) {
                this.method_5416(class_1259.class_1260.field_5784);
            }
        }
    }
}

