/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.minelittlepony.common.util.animation.MotionCompositor;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractDisguiseSpell;
import com.minelittlepony.unicopia.client.render.spell.DarkVortexSpellRenderer;
import com.minelittlepony.unicopia.entity.player.PlayerCamera;
import com.minelittlepony.unicopia.entity.player.Pony;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class PlayerCameraImpl
extends MotionCompositor
implements PlayerCamera {
    private final Pony player;

    public PlayerCameraImpl(Pony player) {
        this.player = player;
    }

    @Override
    public float calculateRoll() {
        return this.player.getInterpolator().interpolate("roll", (float)this.applyModifiers(-this.getMotionRoll()), 15.0f);
    }

    @Override
    public float calculateFirstPersonRoll() {
        return this.player.getInterpolator().interpolate("roll_fp", (float)this.applyModifiers(-this.getMotionRoll() * (double)this.getFovScale() * 0.25), 25.0f);
    }

    private double getMotionRoll() {
        if (!this.player.getMotion().isFlying() || ((class_1657)this.player.asEntity()).method_5765() || ((class_1657)this.player.asEntity()).method_24828()) {
            return 0.0;
        }
        class_243 vel = ((class_1657)this.player.asEntity()).method_18798();
        return this.calculateRoll((class_1309)this.player.asEntity(), vel.field_1352, vel.field_1351, vel.field_1350);
    }

    private double applyModifiers(double motionRoll) {
        if (this.player.getAcrobatics().isFloppy()) {
            motionRoll += 90.0;
        }
        return this.player.getPhysics().isGravityNegative() ? 180.0 - motionRoll : motionRoll;
    }

    @Override
    public float calculatePitch(float pitch) {
        return pitch + this.getEnergyAddition();
    }

    @Override
    public float calculateYaw(float yaw) {
        return yaw + this.getEnergyAddition();
    }

    @Override
    public float calculateDistance(float distance) {
        return this.player.getSpellSlot().get(SpellPredicate.IS_DISGUISE).map(AbstractDisguiseSpell::getDisguise).flatMap(d -> d.getDistance(this.player)).orElse(Float.valueOf(1.0f)).floatValue() * distance;
    }

    @Override
    public double calculateFieldOfView(double fov) {
        fov += (double)(this.player.getMagicalReserves().getExertion().get() / 5.0f * this.getFovScale());
        fov += (double)(this.getEnergyAddition() * this.getFovScale());
        return fov += (double)(DarkVortexSpellRenderer.getCameraDistortion() * 2.5f);
    }

    private float getFovScale() {
        return ((Double)class_310.method_1551().field_1690.method_42454().method_41753()).floatValue();
    }

    protected float getEnergyAddition() {
        int maxE = (int)Math.floor(this.player.getMagicalReserves().getEnergy().get() * 100.0f);
        if (maxE <= 0) {
            return 0.0f;
        }
        float energyAddition = (float)(this.player.asWorld().field_9229.method_43048(maxE) - maxE / 2) / 100.0f;
        if ((double)Math.abs(energyAddition) <= 0.001) {
            return 0.0f;
        }
        return energyAddition;
    }
}

