/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.google.common.collect.Streams;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.EnchantableItem;
import com.minelittlepony.unicopia.util.Copyable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3414;
import net.minecraft.class_7225;

public class PlayerCharmTracker
implements NbtSerialisable,
Copyable<PlayerCharmTracker> {
    private final Pony pony;
    private CustomisedSpellType<?>[] handSpells = new CustomisedSpellType[]{SpellType.SHIELD.withTraits(), SpellType.CATAPULT.withTraits()};

    PlayerCharmTracker(Pony pony) {
        this.pony = pony;
    }

    public CustomisedSpellType<?>[] getHandSpells() {
        return this.handSpells;
    }

    public CustomisedSpellType<?> getEquippedSpell(class_1268 hand) {
        return this.handSpells[hand.ordinal()] == null ? SpellType.EMPTY_KEY.withTraits() : this.handSpells[hand.ordinal()];
    }

    public class_1268 getHand() {
        return ((class_1657)this.pony.asEntity()).method_5715() ? class_1268.field_5810 : class_1268.field_5808;
    }

    public class_1271<CustomisedSpellType<?>> getSpellInHand(boolean consume) {
        return this.getSpellInHand(this.getHand(), consume);
    }

    public class_1271<CustomisedSpellType<?>> getSpellInHand(class_1268 hand, boolean consume) {
        return Streams.stream((Iterable)((class_1657)this.pony.asEntity()).method_5877()).filter(EnchantableItem::isEnchanted).map(stack -> EnchantableItem.consumeSpell(stack, (class_1657)this.pony.asEntity(), null, consume)).findFirst().orElse(this.getEquippedSpell(hand).toAction());
    }

    public CustomisedSpellType<?> equipSpell(class_1268 hand, CustomisedSpellType<?> spell) {
        CustomisedSpellType<?> previous = this.handSpells[hand.ordinal()];
        this.handSpells[hand.ordinal()] = spell;
        if (!Objects.equals(previous, spell)) {
            ((class_1657)this.pony.asEntity()).method_5783((class_3414)USounds.GUI_SPELL_EQUIP.comp_349(), 0.25f, 1.75f);
        }
        this.pony.sendUpdatePacket();
        return previous;
    }

    @Override
    public void copyFrom(PlayerCharmTracker old, boolean alive) {
        for (int i = 0; i < this.handSpells.length; ++i) {
            this.handSpells[i] = old.handSpells[i];
        }
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        class_2499 equippedSpells = new class_2499();
        for (CustomisedSpellType<?> spell : this.handSpells) {
            equippedSpells.add((Object)spell.toNbt(new class_2487()));
        }
        compound.method_10566("handSpells", (class_2520)equippedSpells);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        if (compound.method_10573("handSpells", 9)) {
            class_2499 list = compound.method_10554("handSpells", 10);
            for (int i = 0; i < this.handSpells.length && i < list.size(); ++i) {
                this.handSpells[i] = CustomisedSpellType.fromNBT(list.method_10602(i));
            }
        }
    }
}

