/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.entity.Creature;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.AmuletItem;
import com.minelittlepony.unicopia.item.component.Charges;
import com.minelittlepony.unicopia.item.component.UDataComponentTypes;
import com.minelittlepony.unicopia.particle.FollowingParticleEffect;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.util.VecHelper;
import com.minelittlepony.unicopia.util.shape.Sphere;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1543;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;

public class BellItem
extends class_1792 {
    public BellItem(class_1792.class_1793 settings) {
        super(settings.method_57349(UDataComponentTypes.CHARGES, (Object)Charges.of(1000, 1000)));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 3000;
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 hand) {
        player.method_6019(hand);
        Pony pony = Pony.of(player);
        pony.getCorruption().add(1 + player.method_59922().method_39332(1, 10));
        pony.playSound(USounds.ITEM_GROGAR_BELL_USE, 0.4f, 0.2f);
        Living targetLiving = target instanceof class_1308 || target instanceof class_1657 ? (Living)Living.getOrEmpty((class_1297)target).filter(living -> {
            Creature c;
            return !(living instanceof Creature && (c = (Creature)living).isDiscorded());
        }).orElse(null) : null;
        pony.setTarget(targetLiving);
        return targetLiving == null ? class_1269.field_5814 : class_1269.field_33562;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_1799 offhandStack = AmuletItem.get((class_1309)player).stack();
        if (!Charges.of(offhandStack).canHoldCharge()) {
            offhandStack = player.method_5998(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808);
        }
        Pony pony = Pony.of(player);
        Charges charges = Charges.of(stack);
        if (charges.energy() > 0) {
            pony.playSound(USounds.ITEM_GROGAR_BELL_CHARGE, 0.6f, 1.0f);
            pony.getCorruption().add(player.method_59922().method_39332(1, 10));
            Charges offhandCharges = Charges.of(offhandStack);
            if (offhandCharges.canHoldCharge()) {
                int maxChargeBy = charges.maximum() - offhandCharges.energy();
                int energyTransferred = Math.min(charges.energy(), maxChargeBy);
                Charges.recharge(offhandStack, energyTransferred);
                Charges.discharge(stack, energyTransferred);
            } else {
                pony.getMagicalReserves().getMana().add(charges.energy());
                stack.method_57379(UDataComponentTypes.CHARGES, (Object)charges.withEnergy(0));
            }
            pony.spawnParticles(pony.getPhysics().getHeadPosition().method_46558(), new Sphere(false, 0.5), 7, p -> pony.addParticle(new MagicParticleEffect(0xAAFFFF), (class_243)p, class_243.field_1353));
            return class_1271.method_22428((Object)stack);
        }
        pony.playSound(USounds.ITEM_GROGAR_BELL_USE, 0.01f, 0.9f);
        return class_1271.method_22428((Object)stack);
    }

    public void method_7852(class_1937 world, class_1309 userEntity, class_1799 stack, int remainingUseTicks) {
        if (userEntity.field_6012 % 5 != 0) {
            return;
        }
        Living.getOrEmpty((class_1297)userEntity).ifPresent(user -> user.getTarget().ifPresent(living -> {
            float maxUseTime = this.method_7881(stack, userEntity);
            float progress = (maxUseTime - (float)remainingUseTicks) / maxUseTime;
            if (this.tickDraining((Living<?>)user, (Living<?>)living, stack, progress)) {
                this.onStoppedDraining((Living<?>)user, (Living<?>)living, true);
            }
        }));
    }

    private void onStoppedDraining(Living<?> user, Living<?> target, boolean completed) {
        user.setTarget(null);
        user.playSound(USounds.ITEM_GROGAR_BELL_STOP_USING, 0.2f, 0.3f);
        if (target instanceof Creature) {
            Creature creature = (Creature)target;
            if (completed || target.asEntity().method_6032() < target.asEntity().method_6063() * 0.5f + 1.0f) {
                class_1799 handStack = creature.asEntity().method_5998(class_1268.field_5808);
                if (!handStack.method_7960()) {
                    creature.asEntity().method_6122(class_1268.field_5808, class_1799.field_8037);
                    creature.asEntity().method_5775(handStack);
                }
                creature.setDiscorded(true);
            }
        }
    }

    private boolean tickDraining(Living<?> user, Living<?> living, class_1799 stack, float progress) {
        float amountDrawn;
        if (living.getOrigin().method_10262((class_2382)user.getOrigin()) > 25.0 || living.asEntity().method_31481()) {
            return true;
        }
        class_2400 particleType = class_2398.field_17741;
        if (living instanceof Pony) {
            Pony pony = (Pony)living;
            amountDrawn = pony.getMagicalReserves().getMana().get() * 0.2f;
            pony.getMagicalReserves().getMana().multiply(0.8f);
            if (pony.getSpecies() == Race.CHANGELING) {
                particleType = class_2398.field_11201;
            }
        } else {
            float damageAmount = Math.min(Math.max(1.0f, living.asEntity().method_6063() / 25.0f), living.asEntity().method_6032() - 1.0f);
            living.asEntity().method_5643((class_1282)user.damageOf(UDamageTypes.EXHAUSTION, user), damageAmount);
            living.asEntity().method_6015(user.asEntity());
            Object obj = living.asEntity();
            if (obj instanceof class_1308) {
                class_1308 mob = (class_1308)obj;
                mob.method_5980(null);
            }
            amountDrawn = Math.max(living.asEntity().method_17681(), living.asEntity().method_17682()) + living.asEntity().method_6032();
            obj = living.asEntity();
            if (obj instanceof class_1548) {
                class_1548 creeper = (class_1548)obj;
                creeper.method_7005(-1);
                if (((Boolean)creeper.method_5841().method_12789(class_1548.field_7224)).booleanValue()) {
                    creeper.method_5841().method_12778(class_1548.field_7224, (Object)false);
                    amountDrawn += 60.0f;
                }
                creeper.method_5841().method_12778(class_1548.field_7231, (Object)false);
            }
            if (living.asEntity() instanceof class_1543) {
                particleType = class_2398.field_11231;
            }
            if (living.asEntity().method_6032() <= 1.0f) {
                return true;
            }
        }
        if (Charges.discharge(stack, -((int)amountDrawn))) {
            user.playSound(USounds.ITEM_GROGAR_BELL_DRAIN, 0.2f, progress);
            for (int i = 0; i < 4; ++i) {
                living.addParticle(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, (class_1297)user.asEntity(), 0.4f).withChild((class_2394)particleType), living.getOriginVector().method_1031(0.0, (double)((float)living.getPhysics().getGravitySignum() * living.asEntity().method_17682() / 2.0f), 0.0).method_1019(VecHelper.triangular(user.asWorld().field_9229, 0.0, 0.2)), class_243.field_1353);
            }
        }
        return false;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        Living.getOrEmpty((class_1297)user).ifPresent(living -> living.getTarget().ifPresent(target -> this.onStoppedDraining((Living<?>)living, (Living<?>)target, true)));
        return super.method_7861(stack, world, user);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        Living.getOrEmpty((class_1297)user).ifPresent(living -> living.getTarget().ifPresent(target -> this.onStoppedDraining((Living<?>)living, (Living<?>)target, false)));
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) || Charges.of(stack).energy() > 0;
    }
}

