/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item;

import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.item.component.UDataComponentTypes;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import org.jetbrains.annotations.Nullable;

public interface EnchantableItem
extends class_1935 {
    public static CustomisedSpellType<?> getSpellEffect(class_1799 stack) {
        return EnchantableItem.getSpellKey(stack).withTraits(SpellTraits.of(stack));
    }

    public static class_1271<CustomisedSpellType<?>> consumeSpell(class_1799 stack, class_1657 player, @Nullable Predicate<CustomisedSpellType<?>> filter, boolean consume) {
        if (!EnchantableItem.isEnchanted(stack)) {
            return class_1271.method_22430(SpellType.EMPTY_KEY.withTraits());
        }
        SpellType key = EnchantableItem.getSpellKey(stack);
        if (key.isEmpty()) {
            return class_1271.method_22431(SpellType.EMPTY_KEY.withTraits());
        }
        CustomisedSpellType result = key.withTraits(SpellTraits.of(stack));
        if (filter != null && !filter.test(result)) {
            return class_1271.method_22431(SpellType.EMPTY_KEY.withTraits());
        }
        if (!player.method_37908().field_9236 && consume) {
            player.method_6104(player.method_5998(class_1268.field_5810) == stack ? class_1268.field_5810 : class_1268.field_5808);
            player.method_7357().method_7906(stack.method_7909(), 20);
            if (!player.method_7337()) {
                if (stack.method_7947() == 1) {
                    EnchantableItem.unenchant(stack);
                } else {
                    player.method_7270(EnchantableItem.unenchant(stack.method_7971(1)));
                }
            }
        }
        return class_1271.method_22428(result);
    }

    public static boolean isEnchanted(class_1799 stack) {
        return !EnchantableItem.getSpellKey(stack).isEmpty();
    }

    public static class_1799 enchant(class_1799 stack, SpellType<?> type) {
        return EnchantableItem.enchant(stack, type, type.getAffinity());
    }

    public static class_1799 enchant(class_1799 stack, SpellType<?> type, Affinity affinity) {
        if (type.isEmpty()) {
            return EnchantableItem.unenchant(stack);
        }
        stack.method_57379(UDataComponentTypes.STORED_SPELL, type);
        return type.getTraits().applyTo(stack);
    }

    public static class_1799 unenchant(class_1799 stack) {
        stack.method_57381(UDataComponentTypes.STORED_SPELL);
        stack.method_57381(UDataComponentTypes.SPELL_TRAITS);
        return stack;
    }

    public static Optional<SpellType<?>> getSpellKeyOrEmpty(class_1799 stack) {
        SpellType type = EnchantableItem.getSpellKey(stack);
        return type.isEmpty() ? Optional.empty() : Optional.of(type);
    }

    public static <T extends Spell> SpellType<T> getSpellKey(class_1799 stack) {
        return (SpellType)stack.method_57825(UDataComponentTypes.STORED_SPELL, SpellType.empty());
    }
}

