/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item.enchantment;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.item.enchantment.UEnchantments;
import com.minelittlepony.unicopia.util.RegistryUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Predicate;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_3532;
import net.minecraft.class_3856;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9699;
import org.jetbrains.annotations.Nullable;

public interface EnchantmentUtil {
    public static boolean consumeEnchantment(class_6880<class_1887> enchantment, int levels, class_1799 stack) {
        return EnchantmentUtil.consumeEnchantment(enchantment, levels, stack, null, 0);
    }

    public static boolean consumeEnchantment(class_6880<class_1887> enchantment, int levels, class_1799 stack, @Nullable class_5819 random, int chance) {
        class_9304.class_9305 enchantments = new class_9304.class_9305(class_1890.method_57532((class_1799)stack));
        int level = enchantments.method_57546(enchantment);
        if (level <= 0) {
            return false;
        }
        if (random == null || chance <= 1 || random.method_43048(chance) == 0) {
            enchantments.method_57547(enchantment, Math.max(0, level - levels));
            class_1890.method_57530((class_1799)stack, (class_9304)enchantments.method_57549());
        }
        return true;
    }

    public static boolean prefersEquipment(class_1799 newStack, class_1799 oldStack) {
        int oldLevel;
        int newLevel = EnchantmentUtil.getWantItNeedItLevel(newStack);
        return newLevel > (oldLevel = EnchantmentUtil.getWantItNeedItLevel(oldStack));
    }

    public static int getWantItNeedItLevel(class_1297 entity) {
        int n;
        if (entity instanceof class_1309) {
            class_1309 l = (class_1309)entity;
            n = EnchantmentUtil.getWantItNeedItLevel(l);
        } else if (entity instanceof class_1542) {
            class_1542 i = (class_1542)entity;
            n = EnchantmentUtil.getWantItNeedItLevel(i);
        } else if (entity instanceof class_3856) {
            class_3856 p = (class_3856)entity;
            n = EnchantmentUtil.getWantItNeedItLevel(p.method_7495());
        } else {
            n = 0;
        }
        return n;
    }

    public static int getWantItNeedItLevel(class_1542 entity) {
        return EnchantmentUtil.getLevel(UEnchantments.WANT_IT_NEED_IT, entity.method_6983());
    }

    public static int getWantItNeedItLevel(class_1309 entity) {
        return EnchantmentUtil.getLevel(UEnchantments.WANT_IT_NEED_IT, entity);
    }

    public static int getWantItNeedItLevel(class_1799 stack) {
        return EnchantmentUtil.getLevel(UEnchantments.WANT_IT_NEED_IT, stack);
    }

    public static int getLuck(int baseline, class_1309 entity) {
        boolean naturallyLucky = Living.getOrEmpty((class_1297)entity).filter(c -> c.getCompositeRace().canUseEarth()).isPresent();
        if (naturallyLucky) {
            baseline += 15;
        }
        float luckAmplifier = EnchantmentUtil.getEffectAmplifier(entity, (class_6880<class_1291>)class_1294.field_5926) * (naturallyLucky ? 2 : 1);
        float dolphinsGraceAmplifier = (float)EnchantmentUtil.getEffectAmplifier(entity, (class_6880<class_1291>)class_1294.field_5900) * 0.5f;
        float unluckAmplifier = (float)EnchantmentUtil.getEffectAmplifier(entity, (class_6880<class_1291>)class_1294.field_5908) * (naturallyLucky ? 0.5f : 1.0f);
        float badOmenAmplifier = EnchantmentUtil.getEffectAmplifier(entity, (class_6880<class_1291>)class_1294.field_16595) * (naturallyLucky ? 1 : 2);
        return (int)class_3532.method_15363((float)((float)baseline + luckAmplifier + dolphinsGraceAmplifier - unluckAmplifier - badOmenAmplifier), (float)-10.0f, (float)10.0f);
    }

    public static int getLevel(class_5321<class_1887> enchantment, class_1799 stack) {
        class_9304 enchantments = class_1890.method_57532((class_1799)stack);
        return enchantments.method_57534().stream().filter(entry -> entry.method_40225(enchantment)).map(arg_0 -> ((class_9304)enchantments).method_57536(arg_0)).findFirst().orElse(0);
    }

    private static boolean forEachEnchantment(class_1799 stack, class_1304 slot, class_1309 entity, Predicate<class_6880<class_1887>> consumer) {
        class_9304 component;
        if (!stack.method_7960() && (component = (class_9304)stack.method_57824(class_9334.field_49633)) != null && !component.method_57543()) {
            for (Object2IntMap.Entry entry : component.method_57539()) {
                class_6880 enchantment = (class_6880)entry.getKey();
                if (!((class_1887)enchantment.comp_349()).method_60026(slot) || !consumer.test((class_6880<class_1887>)enchantment)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean forEachEnchantment(class_1309 entity, Predicate<class_6880<class_1887>> predicate) {
        for (class_1304 slot : class_1304.values()) {
            if (!EnchantmentUtil.forEachEnchantment(entity.method_6118(slot), slot, entity, predicate)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnyEnchantmentsIn(class_1309 user, class_6862<class_1887> tag) {
        return EnchantmentUtil.forEachEnchantment(user, enchantment -> enchantment.method_40220(tag));
    }

    public static boolean hasAnyEnchantmentsWith(class_1309 user, class_9331<?> componentType) {
        return EnchantmentUtil.forEachEnchantment(user, enchantment -> ((class_1887)enchantment.comp_349()).comp_2689().method_57832(componentType));
    }

    public static int getLevel(class_1309 user, class_6862<class_1887> tag) {
        return RegistryUtils.entriesForTag(user.method_37908(), tag).method_40239().mapToInt(entry -> class_1890.method_8203((class_6880)entry, (class_1309)user)).sum();
    }

    public static int getGemfinderLevel(class_1309 user) {
        return EnchantmentUtil.getLevel(UEnchantments.GEM_FINDER, user);
    }

    @Deprecated
    public static int getLevel(class_5321<class_1887> enchantment, class_1309 entity) {
        return entity.method_56673().method_30530(class_7924.field_41265).method_40264(enchantment).map(entry -> class_1890.method_8203((class_6880)entry, (class_1309)entity)).orElse(0);
    }

    private static int getTotalLevel(class_5321<class_1887> enchantment, class_1309 entity) {
        return entity.method_56673().method_30530(class_7924.field_41265).method_40264(enchantment).map(entry -> EnchantmentUtil.getTotalEquipmentLevel((class_6880<class_1887>)entry, entity)).orElse(0);
    }

    public static int getTotalEquipmentLevel(class_6880<class_1887> enchantment, class_1309 entity) {
        int level = 0;
        for (class_1799 stack : ((class_1887)enchantment.comp_349()).method_8185(entity).values()) {
            level += class_1890.method_8225(enchantment, (class_1799)stack);
        }
        return level;
    }

    public static int getEffectAmplifier(class_1309 entity, class_6880<class_1291> effect) {
        return entity.method_6059(effect) ? entity.method_6112(effect).method_5578() : 0;
    }

    public static float getWeight(class_1309 entity) {
        return 1 + EnchantmentUtil.getTotalLevel(UEnchantments.HEAVY, entity);
    }

    public static float getWindBuffetResistance(class_1309 entity) {
        return 1.0f + (float)EnchantmentUtil.getTotalLevel(UEnchantments.HEAVY, entity) * 0.8f + (float)(EquinePredicates.PLAYER_EARTH.test((class_1297)entity) ? 1 : 0);
    }

    public static float getImpactReduction(class_1309 entity) {
        return 1.0f + (float)EnchantmentUtil.getTotalLevel(UEnchantments.PADDED, entity) / 6.0f;
    }

    public static float getBouncyness(class_1309 entity) {
        return EnchantmentUtil.getTotalLevel(UEnchantments.PADDED, entity) * 6;
    }

    public static float getAirResistance(class_1309 entity) {
        return 1.0f + (float)EnchantmentUtil.getTotalLevel(UEnchantments.HEAVY, entity) * 0.009f;
    }

    @FunctionalInterface
    public static interface ContextAwareConsumer {
        public boolean accept(class_6880<class_1887> var1, int var2, class_9699 var3);
    }
}

