/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.network.track;

import com.minelittlepony.unicopia.network.track.MsgTrackedValues;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.network.track.TrackableObject;
import com.minelittlepony.unicopia.util.Untyped;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class DataTracker {
    private final List<Pair<?>> codecs = new ObjectArrayList();
    private IntSet dirtyIndices = new IntOpenHashSet();
    private List<TrackableObject<?>> persistentObjects = new ObjectArrayList();
    private boolean initial = true;
    final int id;

    public DataTracker(int id) {
        this.id = id;
    }

    public <T extends TrackableObject<T>> T startTracking(T value) {
        this.persistentObjects.add(value);
        return value;
    }

    public <T> Entry<T> startTracking(TrackableDataType<T> type, T initialValue) {
        Entry entry = new Entry(this, this.codecs.size());
        this.codecs.add(new Pair<T>(entry.id(), type, initialValue));
        return entry;
    }

    private <T> Pair<T> getPair(Entry<T> entry) {
        return this.codecs.get(entry.id());
    }

    private <T> T get(Entry<T> entry) {
        return this.getPair(entry).value.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void set(Entry<T> entry, T value) {
        Pair<T> pair = this.getPair(entry);
        if (!Objects.equals(pair.value, value)) {
            DataTracker dataTracker = this;
            synchronized (dataTracker) {
                pair.value.value = value;
                this.dirtyIndices.add(entry.id());
            }
        }
    }

    synchronized void copyTo(DataTracker destination) {
        for (int i = 0; i < this.codecs.size(); ++i) {
            destination.codecs.get((int)i).value.value = this.codecs.get((int)i).value.value;
            if (i >= this.persistentObjects.size() || i >= destination.persistentObjects.size()) continue;
            TrackableObject<?> a = this.persistentObjects.get(i);
            TrackableObject<?> b = destination.persistentObjects.get(i);
            if (a == null || b == null) continue;
            a.copyTo(b);
        }
    }

    synchronized Optional<MsgTrackedValues.TrackerEntries> getInitialPairs(class_7225.class_7874 lookup) {
        this.initial = false;
        this.dirtyIndices = new IntOpenHashSet();
        return Optional.of(new MsgTrackedValues.TrackerEntries(this.id, true, this.codecs, (Map)Untyped.cast(this.writePersistentObjects(lookup, true))));
    }

    public synchronized Optional<MsgTrackedValues.TrackerEntries> getDirtyPairs(class_7225.class_7874 lookup) {
        if (this.initial) {
            return this.getInitialPairs(lookup);
        }
        Map<Integer, byte[]> updates = this.writePersistentObjects(lookup, false);
        if (this.dirtyIndices.isEmpty() && updates.isEmpty()) {
            return Optional.empty();
        }
        IntSet toSend = this.dirtyIndices;
        this.dirtyIndices = new IntOpenHashSet();
        ArrayList pairs = new ArrayList();
        IntIterator intIterator = toSend.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            pairs.add(this.codecs.get(i));
        }
        return Optional.of(new MsgTrackedValues.TrackerEntries(this.id, false, pairs, updates));
    }

    private Map<Integer, byte[]> writePersistentObjects(class_7225.class_7874 lookup, boolean initial) {
        HashMap<Integer, byte[]> updates = new HashMap<Integer, byte[]>();
        int i = 0;
        while (i < this.persistentObjects.size()) {
            TrackableObject<?> o = this.persistentObjects.get(i);
            TrackableObject.Status status = initial ? TrackableObject.Status.NEW : o.getStatus();
            int id = i++;
            o.write(status, lookup).ifPresent(data -> updates.put(id, data.copy().array()));
        }
        return updates;
    }

    public synchronized void load(MsgTrackedValues.TrackerEntries values, class_5455 lookup) {
        if (values.wipe()) {
            this.codecs.clear();
            this.codecs.addAll(values.values());
        } else {
            for (Pair<?> pair : values.values()) {
                if (pair.id < 0 || pair.id >= this.codecs.size() || this.codecs.get((int)pair.id).value.type != pair.value.type) continue;
                this.codecs.set(pair.id, pair);
            }
        }
        for (Map.Entry entry : values.objects().entrySet()) {
            TrackableObject<?> o = this.persistentObjects.get((Integer)entry.getKey());
            if (o == null) continue;
            o.read(new class_9129(Unpooled.wrappedBuffer((byte[])((byte[])entry.getValue())), lookup), (class_7225.class_7874)lookup);
        }
    }

    public record Entry<T>(DataTracker tracker, int id) {
        public T get() {
            return this.tracker.get(this);
        }

        public T getOrDefault(T def) {
            T t = this.get();
            return t == null ? def : t;
        }

        public void set(T t) {
            this.tracker.set(this, t);
        }
    }

    record Pair<T>(int id, TrackableDataType.TypedValue<T> value) {
        public static final class_9139<class_9129, Pair<?>> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.field_49675, Pair::id, TrackableDataType.PACKET_CODEC, Pair::value, Pair::new);

        public Pair(int id, TrackableDataType<T> type, T value) {
            this(id, new TrackableDataType.TypedValue<T>(type, value));
        }
    }

    public static interface Updater<T> {
        public void update(T var1);
    }
}

