/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.network.track;

import com.minelittlepony.unicopia.network.track.MsgTrackedValues;
import com.minelittlepony.unicopia.network.track.TrackableObject;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class ObjectTracker<T extends TrackableObject<T>> {
    private final Map<UUID, T> trackedObjects = new Object2ObjectOpenHashMap();
    private volatile Map<UUID, T> quickAccess = Map.of();
    private final int id;
    private final Supplier<T> constructor;

    public ObjectTracker(int id, Supplier<T> constructor) {
        this.id = id;
        this.constructor = constructor;
    }

    public Map<UUID, T> entries() {
        return this.quickAccess;
    }

    public Set<UUID> keySet() {
        return this.quickAccess.keySet();
    }

    public Collection<T> values() {
        return this.quickAccess.values();
    }

    @Nullable
    public T get(UUID id) {
        return (T)((TrackableObject)this.quickAccess.get(id));
    }

    @Nullable
    public T remove(UUID id, boolean immediate) {
        TrackableObject entry = (TrackableObject)this.quickAccess.get(id);
        if (entry != null) {
            entry.discard(immediate);
        }
        return (T)entry;
    }

    public boolean contains(UUID id) {
        return this.quickAccess.containsKey(id);
    }

    public boolean isEmpty() {
        return this.quickAccess.isEmpty();
    }

    public boolean clear(boolean immediate) {
        if (this.isEmpty()) {
            return false;
        }
        this.values().forEach(value -> value.discard(immediate));
        return true;
    }

    public synchronized void add(UUID id, T obj) {
        this.trackedObjects.put(id, obj);
        this.quickAccess = Map.copyOf(this.trackedObjects);
    }

    synchronized void copyTo(ObjectTracker<T> destination) {
        for (Map.Entry<UUID, T> entry : this.trackedObjects.entrySet()) {
            TrackableObject copy = (TrackableObject)destination.constructor.get();
            ((TrackableObject)entry.getValue()).copyTo(copy);
            destination.trackedObjects.put(entry.getKey(), copy);
        }
        destination.quickAccess = Map.copyOf(destination.trackedObjects);
    }

    synchronized Optional<MsgTrackedValues.TrackerObjects> getInitialPairs(class_7225.class_7874 lookup) {
        if (this.trackedObjects.isEmpty()) {
            return Optional.empty();
        }
        HashMap<UUID, byte[]> updates = new HashMap<UUID, byte[]>();
        this.quickAccess.entrySet().forEach(object -> ((TrackableObject)object.getValue()).write(TrackableObject.Status.NEW, lookup).ifPresent(data -> updates.put((UUID)object.getKey(), data.copy().array())));
        return Optional.of(new MsgTrackedValues.TrackerObjects(this.id, Set.of(), updates));
    }

    synchronized Optional<MsgTrackedValues.TrackerObjects> getDirtyPairs(class_7225.class_7874 lookup) {
        if (!this.trackedObjects.isEmpty()) {
            HashMap<UUID, byte[]> updates = new HashMap<UUID, byte[]>();
            HashSet<UUID> removedTrackableObjects = new HashSet<UUID>();
            this.trackedObjects.entrySet().removeIf(object -> {
                TrackableObject.Status status = ((TrackableObject)object.getValue()).getStatus();
                if (status == TrackableObject.Status.REMOVED) {
                    removedTrackableObjects.add((UUID)object.getKey());
                    return true;
                }
                ((TrackableObject)object.getValue()).write(status, lookup).ifPresent(data -> updates.put((UUID)object.getKey(), data.copy().array()));
                return false;
            });
            this.quickAccess = Map.copyOf(this.trackedObjects);
            if (!updates.isEmpty() || !removedTrackableObjects.isEmpty()) {
                return Optional.of(new MsgTrackedValues.TrackerObjects(this.id, removedTrackableObjects, updates));
            }
        }
        return Optional.empty();
    }

    synchronized void load(MsgTrackedValues.TrackerObjects objects, class_5455 lookup) {
        objects.removedValues().forEach(removedId -> {
            TrackableObject o = (TrackableObject)this.trackedObjects.remove(removedId);
            if (o != null) {
                o.discard(true);
            }
        });
        objects.values().forEach((id, data) -> {
            TrackableObject o = (TrackableObject)this.trackedObjects.get(id);
            if (o == null) {
                o = (TrackableObject)this.constructor.get();
                this.trackedObjects.put((UUID)id, (T)o);
            }
            o.read(new class_9129(Unpooled.wrappedBuffer((byte[])data), lookup), (class_7225.class_7874)lookup);
        });
        this.quickAccess = Map.copyOf(this.trackedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Map<UUID, T> values) {
        ObjectTracker objectTracker = this;
        synchronized (objectTracker) {
            this.trackedObjects.clear();
            this.trackedObjects.putAll(values);
            this.quickAccess = Map.copyOf(this.trackedObjects);
        }
    }
}

