/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.item.component.ConversionComponent;
import com.minelittlepony.unicopia.item.component.UDataComponentTypes;
import com.minelittlepony.unicopia.server.world.WorldOverlay;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class DragonBreathStore
extends class_18 {
    private static final long PURGE_INTERVAL = 3600000L;
    private static final long MAX_MESSAGE_HOLD_TIME = 86400000L;
    private static final class_2960 ID = Unicopia.id("dragon_breath");
    private final Map<String, List<Entry>> payloads = new HashMap<String, List<Entry>>();
    private final Object locker = new Object();

    public static DragonBreathStore get(class_1937 world) {
        return WorldOverlay.getPersistableStorage(world, ID, DragonBreathStore::new, DragonBreathStore::new);
    }

    DragonBreathStore(class_1937 world, class_2487 compound) {
        this(world);
        compound.method_10541().forEach(key -> compound.method_10554(key, 10).forEach(entry -> this.put((String)key, new Entry((class_2487)entry, (class_7225.class_7874)world.method_30349(), this))));
    }

    DragonBreathStore(class_1937 world) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_2487 method_75(class_2487 compound, class_7225.class_7874 lookup) {
        Object object = this.locker;
        synchronized (object) {
            this.payloads.forEach((id, uuids) -> {
                class_2499 list = new class_2499();
                uuids.forEach(entry -> {
                    if (entry.created < System.currentTimeMillis() - 86400000L) {
                        list.add((Object)entry.toNBT(new class_2487()));
                    }
                });
                compound.method_10566(id, (class_2520)list);
            });
            return compound;
        }
    }

    public static Stream<Entry> popAll(MinecraftServer server, String recipient) {
        return StreamSupport.stream(server.method_3738().spliterator(), false).map(DragonBreathStore::get).flatMap(store -> store.popEntries(recipient).stream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> popEntries(String recipient) {
        Object object = this.locker;
        synchronized (object) {
            List<Entry> entries = this.doPurge().get(recipient);
            if (entries == null) {
                return List.of();
            }
            long now = System.currentTimeMillis();
            ArrayList<Entry> collected = new ArrayList<Entry>();
            entries.removeIf(entry -> {
                if (entry.created < now - 1000L) {
                    collected.add((Entry)entry);
                    return true;
                }
                return false;
            });
            return collected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> peekEntries(String recipient) {
        Object object = this.locker;
        synchronized (object) {
            return this.doPurge().getOrDefault(recipient, List.of());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String recipient, class_1799 payload) {
        Optional<class_1792> item;
        ConversionComponent conversion = (ConversionComponent)payload.method_57824(UDataComponentTypes.ITEM_AFTER_DRAGON_BREATH);
        if (conversion != null && (item = conversion.getItem()).isPresent()) {
            payload = payload.method_60503((class_1935)item.get());
        }
        class_1799 finalPayload = payload;
        Object object = this.locker;
        synchronized (object) {
            this.doPurge();
            if (this.peekEntries(recipient).stream().noneMatch(i -> {
                int combinedCount;
                if (class_1799.method_31577((class_1799)i.payload(), (class_1799)finalPayload) && (combinedCount = i.payload().method_7947() + finalPayload.method_7947()) <= i.payload().method_7914()) {
                    i.payload().method_7939(combinedCount);
                    return true;
                }
                return false;
            })) {
                this.put(recipient, new Entry(System.currentTimeMillis() + (long)(Math.random() * 1999.0), payload, this));
            }
        }
    }

    private void put(String recipient, Entry entry) {
        this.payloads.computeIfAbsent(recipient, id -> new ArrayList()).add(entry);
    }

    private Map<String, List<Entry>> doPurge() {
        long now = System.currentTimeMillis();
        if (now % 3600000L == 0L) {
            this.payloads.entrySet().removeIf(entry -> {
                ((List)entry.getValue()).removeIf(e -> e.created < now - 86400000L);
                return ((List)entry.getValue()).isEmpty();
            });
        }
        return this.payloads;
    }

    public record Entry(long created, class_1799 payload, DragonBreathStore store) {
        public Entry(class_2487 compound, class_7225.class_7874 lookup, DragonBreathStore store) {
            this(compound.method_10537("created"), class_1799.method_57359((class_7225.class_7874)lookup, (class_2487)compound.method_10562("payload")), store);
        }

        public class_2487 toNBT(class_2487 compound) {
            compound.method_10544("created", this.created);
            compound.method_10566("payload", (class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.payload()).getOrThrow());
            return compound;
        }
    }
}

