/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.entity.DynamicLightSource;
import com.minelittlepony.unicopia.server.world.WorldOverlay;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class LightSources
extends class_18 {
    private static final class_2960 ID = Unicopia.id("light_sources");
    private final Object2LongMap<UUID> lightSourceLocations = new Object2LongOpenHashMap();
    private final Long2ObjectMap<ObjectSet<UUID>> lightSources = new Long2ObjectOpenHashMap();
    private final Object2IntMap<UUID> lightSourceClientIds = new Object2IntOpenHashMap();
    private volatile boolean empty = true;
    private final class_1937 world;
    private final Function<UUID, class_1297> entitySupplier;

    public static LightSources get(class_1937 world) {
        return WorldOverlay.getPersistableStorage(world, ID, LightSources::new, LightSources::new);
    }

    LightSources(class_1937 world, class_2487 compound) {
        this(world);
    }

    LightSources(class_1937 world) {
        Function<UUID, class_1297> function;
        this.world = world;
        if (world instanceof class_3218) {
            class_3218 s = (class_3218)world;
            function = arg_0 -> ((class_3218)s).method_14190(arg_0);
        } else {
            function = id -> world.method_8469(this.lightSourceClientIds.getInt(id));
        }
        this.entitySupplier = function;
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 lookup) {
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends class_1297> void addLightSource(T entity) {
        Long2ObjectMap<ObjectSet<UUID>> long2ObjectMap = this.lightSources;
        synchronized (long2ObjectMap) {
            this.lightSourceLocations.computeLong((Object)entity.method_5667(), (id, lastPos) -> {
                this.lightSourceClientIds.put(id, entity.method_5628());
                long pos = ((DynamicLightSource)entity).getLightSourcePosition().method_10063();
                if (lastPos == null || lastPos != pos) {
                    if (lastPos != null) {
                        ((ObjectSet)this.lightSources.get(lastPos.longValue())).remove(id);
                        this.checkBlock((long)lastPos);
                    }
                    ((ObjectSet)this.lightSources.computeIfAbsent(pos, l -> new ObjectOpenHashSet())).add(id);
                    this.checkBlock(pos);
                }
                return pos;
            });
            this.empty = false;
        }
    }

    private void checkBlock(long pos) {
        try {
            this.world.method_22336().method_15513(class_2338.method_10092((long)pos));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLightSource(UUID id) {
        if (this.empty) {
            return;
        }
        Long2ObjectMap<ObjectSet<UUID>> long2ObjectMap = this.lightSources;
        synchronized (long2ObjectMap) {
            this.lightSourceClientIds.removeInt((Object)id);
            if (this.lightSourceLocations.containsKey((Object)id)) {
                this.lightSources.computeIfPresent(this.lightSourceLocations.removeLong((Object)id), (p, ids) -> {
                    ids.remove((Object)id);
                    this.checkBlock((long)p);
                    return ids.isEmpty() ? null : ids;
                });
            }
            this.empty = this.lightSources.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLuminance(long blockPos) {
        if (this.empty) {
            return 0;
        }
        int result = 0;
        Long2ObjectMap<ObjectSet<UUID>> long2ObjectMap = this.lightSources;
        synchronized (long2ObjectMap) {
            ObjectSet ids = (ObjectSet)this.lightSources.get(blockPos);
            if (ids != null) {
                ObjectIterator each = ids.iterator();
                while (each.hasNext()) {
                    UUID id = (UUID)each.next();
                    int level = this.getLightLevel(id);
                    if (level > 0) {
                        if ((result += level) < 15) continue;
                        break;
                    }
                    each.remove();
                    this.lightSourceClientIds.removeInt((Object)id);
                    this.lightSourceLocations.removeLong((Object)id);
                }
                if (ids.isEmpty()) {
                    this.lightSources.remove(blockPos);
                }
            }
        }
        return Math.min(result, 15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachLightSource(class_1923 chunkPos, LightSourceConsumer consumer) {
        if (this.empty) {
            return;
        }
        Long2ObjectMap<ObjectSet<UUID>> long2ObjectMap = this.lightSources;
        synchronized (long2ObjectMap) {
            this.lightSources.long2ObjectEntrySet().removeIf(entry -> {
                if (this.checkPos(chunkPos, entry.getLongKey())) {
                    int result = 0;
                    ObjectIterator each = ((ObjectSet)entry.getValue()).iterator();
                    while (each.hasNext()) {
                        UUID id = (UUID)each.next();
                        int level = this.getLightLevel(id);
                        if (level > 0) {
                            if ((result += level) < 15) continue;
                            break;
                        }
                        each.remove();
                        this.lightSourceClientIds.removeInt((Object)id);
                        this.lightSourceLocations.removeLong((Object)id);
                    }
                    consumer.accept(entry.getLongKey(), Math.min(result, 15));
                }
                return ((ObjectSet)entry.getValue()).isEmpty();
            });
            this.empty = this.lightSources.isEmpty();
        }
    }

    private int getLightLevel(UUID id) {
        class_1297 entity = this.entitySupplier.apply(id);
        if (entity instanceof DynamicLightSource) {
            DynamicLightSource source = (DynamicLightSource)entity;
            if (!entity.method_31481()) {
                return source.getLightLevel();
            }
        }
        return 0;
    }

    private boolean checkPos(class_1923 chunkPos, long pos) {
        return this.world.method_31601(class_2338.method_10071((long)pos)) && this.checkPos(class_2338.method_10061((long)pos), chunkPos.method_8326(), chunkPos.method_8327()) && this.checkPos(class_2338.method_10083((long)pos), chunkPos.method_8328(), chunkPos.method_8329());
    }

    private boolean checkPos(int p, int min, int max) {
        return p >= min && p <= max;
    }

    public static interface LightSourceConsumer {
        public void accept(long var1, int var3);
    }
}

