/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world.chunk;

import com.minelittlepony.unicopia.server.world.chunk.PositionalDataMap;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_3532;

public class Section<T extends PositionalDataMap.Hotspot> {
    private final Set<T> entries = Section.weakSet();
    private Set<T>[] states;
    final long pos;

    public Section(long pos) {
        this.pos = pos;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean remove(T entry) {
        if (this.entries.remove(entry)) {
            this.states = null;
            return true;
        }
        return false;
    }

    public boolean update(T entry, class_238 box) {
        this.entries.add(entry);
        this.states = null;
        return true;
    }

    public Set<T> getState(class_2338 pos) {
        Set<T> state;
        int localPos = Section.toLocalIndex(pos);
        if (this.states == null) {
            this.states = new Set[4096];
        }
        return (state = this.states[localPos]) == null ? this.calculateState(pos) : state;
    }

    private Set<T> calculateState(class_2338 pos) {
        Set<T> state = Section.weakSet();
        for (PositionalDataMap.Hotspot entry : this.entries) {
            class_2338 center = entry.getCenter();
            int radius = class_3532.method_15386((float)entry.getRadius());
            if (!pos.equals((Object)center) && (!Section.isInRange(pos.method_10263(), center.method_10263(), radius) || !Section.isInRange(pos.method_10260(), center.method_10260(), radius) || !Section.isInRange(pos.method_10264(), center.method_10264(), radius) || !center.method_19771((class_2382)pos, (double)radius))) continue;
            state.add(entry);
        }
        return state;
    }

    static boolean isInRange(int value, int center, int radius) {
        return value >= center - radius && value <= center + radius;
    }

    static int toLocalIndex(class_2338 pos) {
        int x = pos.method_10263() % 16;
        int y = pos.method_10264() % 16;
        int z = pos.method_10260() % 16;
        return x + y * 16 + z * 16 * 16;
    }

    static <T> Set<T> weakSet() {
        return Collections.newSetFromMap(new WeakHashMap());
    }
}

