/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world.gen;

import com.minelittlepony.unicopia.server.world.gen.BiomeSelectionContext;
import com.minelittlepony.unicopia.server.world.gen.OverworldBiomeSelectionCallback;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.include.com.google.common.base.Objects;

public final class BiomeSelectionInjector
implements Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> {
    private final Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameterConsumer;

    public BiomeSelectionInjector(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameterConsumer) {
        this.parameterConsumer = parameterConsumer;
    }

    @Override
    public void accept(Pair<class_6544.class_4762, class_5321<class_1959>> parameter) {
        Context context = new Context(this, parameter);
        ((OverworldBiomeSelectionCallback)OverworldBiomeSelectionCallback.EVENT.invoker()).onSelectingBiome(context);
        if (!context.overrides.isEmpty()) {
            List<Object> subSections = List.of(parameter);
            List<Map.Entry> divisions = context.overrides.entrySet().stream().sorted(Comparator.comparing(entry -> Float.valueOf(Context.getVolume((BiomeSelectionContext.SplittableBiomeCoordinate)entry.getKey()))).reversed()).toList();
            for (Map.Entry division : divisions) {
                subSections = subSections.stream().flatMap(par -> Stream.of(Pair.of((Object)Context.write((BiomeSelectionContext.SplittableBiomeCoordinate)division.getKey(), (class_6544.class_4762)par.getFirst()), (Object)((class_5321)division.getValue())), par)).toList();
            }
            subSections.forEach(this.parameterConsumer);
        } else {
            this.parameterConsumer.accept(parameter);
        }
    }

    class Context
    implements BiomeSelectionContext {
        private final Pair<class_6544.class_4762, class_5321<class_1959>> parameter;
        private final Map<BiomeSelectionContext.SplittableBiomeCoordinate, class_5321<class_1959>> overrides = new LinkedHashMap<BiomeSelectionContext.SplittableBiomeCoordinate, class_5321<class_1959>>();

        public Context(BiomeSelectionInjector this$0, Pair<class_6544.class_4762, class_5321<class_1959>> parameter) {
            this.parameter = parameter;
        }

        @Override
        public class_5321<class_1959> biomeKey() {
            return (class_5321)this.parameter.getSecond();
        }

        @Override
        public BiomeSelectionContext.SplittableBiomeCoordinate referenceFrame() {
            return Context.createStart((class_6544.class_4762)this.parameter.getFirst());
        }

        @Override
        @Nullable
        public class_5321<class_1959> addOverride(BiomeSelectionContext.SplittableBiomeCoordinate coordinate, class_5321<class_1959> biome) {
            return this.overrides.put(coordinate, biome);
        }

        static float getVolume(BiomeSelectionContext.SplittableBiomeCoordinate coordinate) {
            return ((SplitableParameterRangeImpl)coordinate.temperature()).length() * ((SplitableParameterRangeImpl)coordinate.humidity()).length() * ((SplitableParameterRangeImpl)coordinate.continentalness()).length() * ((SplitableParameterRangeImpl)coordinate.erosion()).length() * ((SplitableParameterRangeImpl)coordinate.depth()).length() * ((SplitableParameterRangeImpl)coordinate.weirdness()).length();
        }

        static class_6544.class_4762 write(BiomeSelectionContext.SplittableBiomeCoordinate coordinate, class_6544.class_4762 referenceFrame) {
            return new class_6544.class_4762(((SplitableParameterRangeImpl)coordinate.temperature()).write(referenceFrame.comp_105()), ((SplitableParameterRangeImpl)coordinate.humidity()).write(referenceFrame.comp_106()), ((SplitableParameterRangeImpl)coordinate.continentalness()).write(referenceFrame.comp_107()), ((SplitableParameterRangeImpl)coordinate.erosion()).write(referenceFrame.comp_108()), ((SplitableParameterRangeImpl)coordinate.depth()).write(referenceFrame.comp_109()), ((SplitableParameterRangeImpl)coordinate.weirdness()).write(referenceFrame.comp_110()), coordinate.offset());
        }

        static BiomeSelectionContext.SplittableBiomeCoordinate createStart(class_6544.class_4762 referenceFrame) {
            BiomeSelectionContext.SplittableBiomeCoordinate[] self;
            self = new BiomeSelectionContext.SplittableBiomeCoordinate[]{new BiomeSelectionContext.SplittableBiomeCoordinate(new SplitableParameterRangeImpl(self, BiomeSelectionContext.SplittableBiomeCoordinate::temperature, 0.0f, 1.0f), new SplitableParameterRangeImpl(self, BiomeSelectionContext.SplittableBiomeCoordinate::humidity, 0.0f, 1.0f), new SplitableParameterRangeImpl(self, BiomeSelectionContext.SplittableBiomeCoordinate::continentalness, 0.0f, 1.0f), new SplitableParameterRangeImpl(self, BiomeSelectionContext.SplittableBiomeCoordinate::erosion, 0.0f, 1.0f), new SplitableParameterRangeImpl(self, BiomeSelectionContext.SplittableBiomeCoordinate::depth, 0.0f, 1.0f), new SplitableParameterRangeImpl(self, BiomeSelectionContext.SplittableBiomeCoordinate::weirdness, 0.0f, 1.0f), referenceFrame.comp_111())};
            return self[0];
        }

        static BiomeSelectionContext.SplittableBiomeCoordinate createCopy(BiomeSelectionContext.SplittableBiomeCoordinate old) {
            BiomeSelectionContext.SplittableBiomeCoordinate[] self;
            self = new BiomeSelectionContext.SplittableBiomeCoordinate[]{new BiomeSelectionContext.SplittableBiomeCoordinate(new SplitableParameterRangeImpl(self, (SplitableParameterRangeImpl)old.temperature()), new SplitableParameterRangeImpl(self, (SplitableParameterRangeImpl)old.humidity()), new SplitableParameterRangeImpl(self, (SplitableParameterRangeImpl)old.continentalness()), new SplitableParameterRangeImpl(self, (SplitableParameterRangeImpl)old.erosion()), new SplitableParameterRangeImpl(self, (SplitableParameterRangeImpl)old.depth()), new SplitableParameterRangeImpl(self, (SplitableParameterRangeImpl)old.weirdness()), old.offset())};
            return self[0];
        }

        private static final class SplitableParameterRangeImpl
        implements BiomeSelectionContext.SplitableParameterRange {
            private final BiomeSelectionContext.SplittableBiomeCoordinate[] coordinate;
            private final Function<BiomeSelectionContext.SplittableBiomeCoordinate, BiomeSelectionContext.SplitableParameterRange> dimension;
            private float min;
            private float max;

            SplitableParameterRangeImpl(BiomeSelectionContext.SplittableBiomeCoordinate[] coordinate, SplitableParameterRangeImpl original) {
                this(coordinate, original.dimension, original.min, original.max);
            }

            SplitableParameterRangeImpl(BiomeSelectionContext.SplittableBiomeCoordinate[] coordinate, Function<BiomeSelectionContext.SplittableBiomeCoordinate, BiomeSelectionContext.SplitableParameterRange> dimension, float min, float max) {
                this.coordinate = coordinate;
                this.dimension = dimension;
                this.min = min;
                this.max = max;
            }

            @Override
            public BiomeSelectionContext.SplittableBiomeCoordinate splitAbove(float midpoint) {
                return this.copyWithDifference(o -> {
                    o.min = class_3532.method_16439((float)midpoint, (float)o.min, (float)o.max);
                });
            }

            @Override
            public BiomeSelectionContext.SplittableBiomeCoordinate splitBelow(float midpoint) {
                return this.copyWithDifference(o -> {
                    o.max = class_3532.method_16439((float)midpoint, (float)o.min, (float)o.max);
                });
            }

            private BiomeSelectionContext.SplittableBiomeCoordinate copyWithDifference(Consumer<SplitableParameterRangeImpl> mutator) {
                BiomeSelectionContext.SplittableBiomeCoordinate copy = Context.createCopy(this.coordinate[0]);
                mutator.accept((SplitableParameterRangeImpl)this.dimension.apply(copy));
                return copy;
            }

            public class_6544.class_6546 write(class_6544.class_6546 range) {
                return class_6544.class_6546.method_38121((float)(class_6544.method_38666((long)range.comp_103()) * (1.0f + this.min)), (float)(class_6544.method_38666((long)range.comp_104()) * this.max));
            }

            public float length() {
                return this.max - this.min;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object o) {
                if (!(o instanceof SplitableParameterRangeImpl)) return false;
                SplitableParameterRangeImpl i = (SplitableParameterRangeImpl)o;
                if (!class_3532.method_15347((float)i.min, (float)this.min)) return false;
                if (!class_3532.method_15347((float)i.max, (float)this.max)) return false;
                return true;
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.min), Float.valueOf(this.max)});
            }
        }
    }
}

