/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.util;

import com.minelittlepony.unicopia.util.InventoryUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public record ItemStackSet(Int2ObjectMap<Entry> stacks) implements Iterable<class_1799>
{
    static final ItemStackSet EMPTY = new ItemStackSet((Int2ObjectMap<Entry>)new Int2ObjectOpenHashMap());

    public ItemStackSet(class_1263 inventory) {
        this((Int2ObjectMap<Entry>)new Int2ObjectOpenHashMap());
        InventoryUtil.stream(inventory).forEach(stack -> ((Entry)this.stacks.computeIfAbsent((int)class_1799.method_57355((class_1799)stack), (Int2ObjectFunction)(Int2ObjectFunction)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$new$0(net.minecraft.class_1799 int ), (I)Lcom/minelittlepony/unicopia/util/ItemStackSet$Entry;)((class_1799)stack))).count += stack.method_7947());
    }

    public ItemStackSet(ItemStackSet set) {
        this((Int2ObjectMap<Entry>)new Int2ObjectOpenHashMap(set.stacks));
    }

    public ItemStackSet(Int2ObjectMap<Entry> stacks) {
        this.stacks = stacks = new Int2ObjectOpenHashMap(stacks);
    }

    public ItemStackSet add(ItemStackSet set) {
        if (this.isEmpty()) {
            return set;
        }
        if (set.isEmpty()) {
            return this;
        }
        ItemStackSet copy = new ItemStackSet(this);
        set.stacks.forEach((i, entry) -> copy.stacks.compute(i, (key, copyEntry) -> copyEntry == null ? new Entry((Entry)entry) : copyEntry.add(entry.count)));
        return copy;
    }

    public ItemStackSet subtract(ItemStackSet set) {
        if (this.isEmpty()) {
            return set;
        }
        if (set.isEmpty()) {
            return this;
        }
        ItemStackSet copy = new ItemStackSet(this);
        set.stacks.forEach((i, entry) -> copy.stacks.compute(i, (key, copyEntry) -> copyEntry == null ? new Entry((Entry)entry) : copyEntry.add(entry.count)));
        return copy;
    }

    public ItemStackSet add(class_1799 stack) {
        if (!stack.method_7960()) {
            ItemStackSet copy = new ItemStackSet(this);
            ((Entry)copy.stacks.computeIfAbsent((int)class_1799.method_57355((class_1799)stack), (Int2ObjectFunction)(Int2ObjectFunction)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$add$6(net.minecraft.class_1799 int ), (I)Lcom/minelittlepony/unicopia/util/ItemStackSet$Entry;)((class_1799)stack))).count += stack.method_7947();
            return copy;
        }
        return this;
    }

    public ItemStackSet subtract(class_1799 stack) {
        if (!stack.method_7960()) {
            ItemStackSet copy = new ItemStackSet(this);
            copy.stacks.computeIfPresent(class_1799.method_57355((class_1799)stack), (e, entry) -> entry.add(-stack.method_7947()));
            return copy;
        }
        return this;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    public Iterator<class_1799> iterator() {
        return new Iterator<class_1799>(){
            private final ObjectIterator<Entry> iterator;
            @Nullable
            private Iterator<class_1799> stackIterator;
            {
                this.iterator = ItemStackSet.this.stacks.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext() || this.stackIterator != null && this.stackIterator.hasNext();
            }

            @Override
            public class_1799 next() {
                if (this.stackIterator == null || !this.stackIterator.hasNext()) {
                    this.stackIterator = ((Entry)this.iterator.next()).iterator();
                }
                return this.stackIterator.next();
            }
        };
    }

    private static /* synthetic */ Entry lambda$add$6(class_1799 stack, int i) {
        return new Entry(stack);
    }

    private static /* synthetic */ Entry lambda$new$0(class_1799 stack, int i) {
        return new Entry(stack);
    }

    static class Entry {
        final class_1799 stack;
        int count;

        public Entry(class_1799 stack) {
            this.stack = stack.method_46651(1);
        }

        public Entry(Entry entry) {
            this.stack = entry.stack.method_46651(1);
            this.count = entry.count;
        }

        @Nullable
        public Entry add(int count) {
            this.count += count;
            return this.count >= 0 ? this : null;
        }

        public Iterator<class_1799> iterator() {
            return new Iterator<class_1799>(){
                private int countRemaining;
                {
                    this.countRemaining = count;
                }

                @Override
                public boolean hasNext() {
                    return this.countRemaining > 0;
                }

                @Override
                public class_1799 next() {
                    int stackSize = Math.min(stack.method_7914(), this.countRemaining);
                    this.countRemaining -= stackSize;
                    return stack.method_46651(stackSize);
                }
            };
        }
    }
}

