/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia;

import com.google.common.base.MoreObjects;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.player.Pony;
import net.minecraft.class_1297;
import net.minecraft.class_1838;
import net.minecraft.class_3726;

public interface EquineContext {
    public static final EquineContext ABSENT = () -> Race.UNSET;

    public Race getSpecies();

    default public Race getObservedSpecies() {
        return this.getCompositeRace().physical();
    }

    default public Race.Composite getCompositeRace() {
        return this.getSpecies().composite();
    }

    default public float getCloudWalkingStrength() {
        return 0.0f;
    }

    default public boolean collidesWithClouds() {
        return this.getCompositeRace().canInteractWithClouds() || this.getCloudWalkingStrength() >= 1.0f;
    }

    default public boolean hasFeatherTouch() {
        return false;
    }

    public static EquineContext of(class_3726 context) {
        EquineContext equineContext;
        if (context == class_3726.method_16194()) {
            return InteractionManager.getInstance().getEquineContext();
        }
        if (context instanceof Container) {
            Container c = (Container)context;
            equineContext = c.get();
        } else {
            equineContext = ABSENT;
        }
        EquineContext result = equineContext;
        return result == null ? ABSENT : result;
    }

    public static EquineContext of(class_1838 context) {
        return (EquineContext)MoreObjects.firstNonNull((Object)Pony.of(context.method_8036()), (Object)ABSENT);
    }

    public static EquineContext of(class_1297 entity) {
        if (entity instanceof EquineContext) {
            EquineContext c = (EquineContext)entity;
            return c;
        }
        return (EquineContext)MoreObjects.firstNonNull((Object)Equine.of(entity).orElse(null), (Object)ABSENT);
    }

    public static interface Container {
        public EquineContext get();
    }
}

