/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia;

import com.minelittlepony.unicopia.Config;
import com.minelittlepony.unicopia.Debug;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.UGameEvents;
import com.minelittlepony.unicopia.UPOIs;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.data.tree.TreeTypeLoader;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.TraitLoader;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.block.UBlocks;
import com.minelittlepony.unicopia.block.state.StateMapLoader;
import com.minelittlepony.unicopia.block.state.StatePredicate;
import com.minelittlepony.unicopia.command.Commands;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.container.UScreenHandlers;
import com.minelittlepony.unicopia.container.spellbook.SpellbookChapterLoader;
import com.minelittlepony.unicopia.diet.DietsLoader;
import com.minelittlepony.unicopia.diet.affliction.AfflictionType;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.effect.SeaponyGraceStatusEffect;
import com.minelittlepony.unicopia.entity.effect.UPotions;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.item.component.UDataComponentTypes;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.server.world.BlockDestructionManager;
import com.minelittlepony.unicopia.server.world.Ether;
import com.minelittlepony.unicopia.server.world.UGameRules;
import com.minelittlepony.unicopia.server.world.UWorldGen;
import com.minelittlepony.unicopia.server.world.WeatherConditions;
import com.minelittlepony.unicopia.server.world.ZapAppleStageStore;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Unicopia
implements ModInitializer {
    public static final String DEFAULT_NAMESPACE = "unicopia";
    public static final String VANILLA_EXTENSIONS_NAMESPACE = "unicopiamc";
    public static final Logger LOGGER = LogManager.getLogger();
    private static Config CONFIG;

    public static Config getConfig() {
        if (CONFIG == null) {
            CONFIG = new Config();
            try {
                CONFIG.load();
            }
            catch (IllegalStateException ignored) {
                CONFIG.save();
            }
        }
        return CONFIG;
    }

    public static class_2960 id(String name) {
        return class_2960.method_60655((String)DEFAULT_NAMESPACE, (String)name);
    }

    public void onInitialize() {
        Channel.bootstrap();
        UCriteria.bootstrap();
        UDataComponentTypes.bootstrap();
        UEntities.bootstrap();
        Commands.bootstrap();
        TrinketsDelegate.getInstance(null).bootstrap();
        ServerTickEvents.END_WORLD_TICK.register(w -> {
            ((BlockDestructionManager.Source)w).getDestructionManager().tick();
            ZapAppleStageStore.get((class_1937)w).tick();
            WeatherConditions.get((class_1937)w).tick();
            Ether.get((class_1937)w).tick();
            if (Debug.SPELLBOOK_CHAPTERS) {
                SpellbookChapterLoader.INSTANCE.sendUpdate(w.method_8503());
            }
            if (Debug.CHECK_GAME_VALUES) {
                Debug.runTests((class_1937)w);
            }
        });
        PlayerBlockBreakEvents.AFTER.register(SeaponyGraceStatusEffect::processBlockChange);
        PlayerBlockBreakEvents.CANCELED.register((world, player, pos, state, blockEntity) -> Pony.of(player).onStoppedBreakingBlock(pos));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> Pony.of(player).interact(hand, hitResult));
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> Pony.of(player).interact(hand, entity, hitResult));
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> Pony.of(player).onStartedBreakingBlock(hand, pos, direction));
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> Pony.of(player).onAttackEntity(hand, entity, hitResult));
        EntitySleepEvents.ALLOW_SLEEP_TIME.register((player, pos, isDay) -> Pony.of(player).canSleepNow());
        this.registerServerDataReloaders(ResourceManagerHelper.get((class_3264)class_3264.field_14190));
        UGameEvents.bootstrap();
        UBlocks.bootstrap();
        UPOIs.bootstrap();
        UItems.bootstrap();
        UPotions.bootstrap();
        UParticles.bootstrap();
        USounds.bootstrap();
        Race.bootstrap();
        SpellType.bootstrap();
        AfflictionType.bootstrap();
        Abilities.bootstrap();
        UScreenHandlers.bootstrap();
        UWorldGen.bootstrap();
        UGameRules.bootstrap();
        UDamageTypes.bootstrap();
        StatePredicate.bootstrap();
    }

    private void registerServerDataReloaders(ResourceManagerHelper registry) {
        registry.registerReloadListener((IdentifiableResourceReloadListener)TreeTypeLoader.INSTANCE);
        registry.registerReloadListener((IdentifiableResourceReloadListener)new TraitLoader());
        registry.registerReloadListener((IdentifiableResourceReloadListener)StateMapLoader.INSTANCE);
        registry.registerReloadListener((IdentifiableResourceReloadListener)SpellbookChapterLoader.INSTANCE);
        registry.registerReloadListener((IdentifiableResourceReloadListener)new DietsLoader());
    }
}

