/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia;

import com.minelittlepony.unicopia.Owned;
import com.minelittlepony.unicopia.WorldConvertable;
import com.minelittlepony.unicopia.entity.EntityReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import org.jetbrains.annotations.Nullable;

public interface WeaklyOwned<E extends class_1297>
extends Owned<E>,
WorldConvertable {
    public EntityReference<E> getMasterReference();

    @Override
    @Nullable
    default public E getMaster() {
        return this.getMasterReference().get(this.asWorld());
    }

    @Override
    default public Optional<UUID> getMasterId() {
        return this.getMasterReference().getTarget().map(EntityReference.EntityValues::uuid);
    }

    public static interface Mutable<E extends class_1297>
    extends WeaklyOwned<E>,
    Owned.Mutable<E> {
        @Override
        public EntityReference<E> getMasterReference();

        @Override
        default public void setMaster(Owned<? extends E> sibling) {
            if (sibling instanceof WeaklyOwned) {
                WeaklyOwned w = (WeaklyOwned)sibling;
                this.getMasterReference().copyFrom(w.getMasterReference());
            } else {
                this.setMaster(sibling.getMaster());
            }
        }

        @Override
        default public void setMaster(E master) {
            this.getMasterReference().set(master);
        }
    }
}

