/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.AwaitTickQueue;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.data.Hit;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.entity.LandingEventHandler;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.item.enchantment.EnchantmentUtil;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.server.world.BlockDestructionManager;
import com.minelittlepony.unicopia.server.world.ModificationType;
import com.minelittlepony.unicopia.util.PosHelper;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class EarthPonyStompAbility
implements Ability<Hit> {
    private final double rad = 4.0;
    private final class_238 areaOfEffect = new class_238(-4.0, -4.0, -4.0, 4.0, 4.0, 4.0);

    @Override
    public int getWarmupTime(Pony player) {
        return 3;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 50;
    }

    @Override
    public class_2960 getIcon(Pony player) {
        class_2960 id = Abilities.REGISTRY.method_10221((Object)this);
        Race race = player.getObservedSpecies();
        return id.method_45134(p -> "textures/gui/ability/" + p + "_" + (race.isHuman() ? Race.EARTH : race).getId().method_12832() + ".png");
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 4.0;
    }

    @Override
    @Nullable
    public Optional<Hit> prepare(Pony player) {
        if (((class_1657)player.asEntity()).method_18798().field_1351 * (double)player.getPhysics().getGravitySignum() < 0.0 && !((class_1657)player.asEntity()).method_31549().field_7479 && !((class_1657)player.asEntity()).method_6128() && !((class_1657)player.asEntity()).method_6123()) {
            this.thrustDownwards(player);
            return Hit.INSTANCE;
        }
        return Optional.empty();
    }

    @Override
    public class_9139<? super class_9129, Hit> getSerializer() {
        return Hit.CODEC;
    }

    private void thrustDownwards(Pony player) {
        class_2338 ppos = player.getOrigin();
        class_2338 pos = PosHelper.findSolidGroundAt(player.asWorld(), ppos, player.getPhysics().getGravitySignum());
        double downV = Math.sqrt(ppos.method_10262((class_2382)pos)) * (double)player.getPhysics().getGravitySignum();
        ((class_1657)player.asEntity()).method_5762(0.0, -downV, 0.0);
        player.updateVelocity();
    }

    @Override
    public boolean apply(final Pony iplayer, Hit data) {
        final class_1657 player = (class_1657)iplayer.asEntity();
        final double initialY = player.method_23318() + 5.0;
        LandingEventHandler.Callback r = new LandingEventHandler.Callback(){

            @Override
            public float dispatch(float fallDistance) {
                if (player.method_23318() > initialY) {
                    return fallDistance;
                }
                player.field_6017 = 0.0f;
                class_2338 center = PosHelper.findSolidGroundAt(player.method_5770(), player.method_24515(), iplayer.getPhysics().getGravitySignum());
                float heavyness = EnchantmentUtil.getWeight((class_1309)player);
                iplayer.asWorld().method_8335((class_1297)player, EarthPonyStompAbility.this.areaOfEffect.method_997(iplayer.getOriginVector())).forEach(i -> {
                    double dist = Math.sqrt(center.method_10262((class_2382)i.method_24515()));
                    if (dist <= 7.0) {
                        double inertia = 2.0 / dist;
                        if (i instanceof class_1309) {
                            class_1309 l = (class_1309)i;
                            inertia *= (double)EnchantmentUtil.getWeight(l);
                        }
                        double liftAmount = Math.sin(Math.PI * dist / 4.0) * 12.0 * (double)iplayer.getPhysics().getGravitySignum();
                        i.method_5762(-(player.method_23317() - i.method_23317()) / (inertia /= (double)heavyness), -(player.method_23318() - i.method_23318() - liftAmount) / inertia + (dist < 1.0 ? dist : 0.0), -(player.method_23321() - i.method_23321()) / inertia);
                        double amount = (1.5 * player.method_5996(class_5134.field_23721).method_6194() + (double)heavyness * 0.4) / (double)((float)(dist * (double)1.3f));
                        if (i instanceof class_1657) {
                            Race.Composite race = Pony.of((class_1657)i).getCompositeRace();
                            if (race.canUseEarth()) {
                                amount /= 3.0;
                            }
                            if (race.canFly()) {
                                amount *= 4.0;
                            }
                        }
                        if (i instanceof class_1309) {
                            class_1309 l = (class_1309)i;
                            amount /= (double)EnchantmentUtil.getImpactReduction(l);
                        }
                        i.method_5643((class_1282)iplayer.damageOf(UDamageTypes.SMASH, iplayer), (float)amount);
                        Living.updateVelocity(i);
                    }
                });
                double radius = 4.0 + (double)heavyness * 0.3;
                EarthPonyStompAbility.spawnEffectAround(iplayer, (class_1297)player, center, radius, 4.0);
                ParticleUtils.spawnParticle(player.method_37908(), (class_2394)UParticles.GROUND_POUND, player.method_23317(), player.method_23318() - 1.0, player.method_23321(), 0.0, 0.0, 0.0);
                class_2680 steppingState = player.method_25936();
                if (steppingState.method_26164(UTags.Blocks.KICKS_UP_DUST)) {
                    ParticleUtils.spawnParticle(player.method_37908(), (class_2394)new class_2388(UParticles.DUST_CLOUD, steppingState), player.method_24515().method_10074().method_46558(), class_243.field_1353);
                }
                iplayer.subtractEnergyCost(4.0);
                ((class_1657)iplayer.asEntity()).method_7322(3.0f);
                return 0.0f;
            }

            @Override
            public void onCancelled() {
                iplayer.playSound(USounds.GUI_ABILITY_FAIL, 1.0f);
            }
        };
        if (((class_1657)iplayer.asEntity()).method_24828()) {
            iplayer.setAnimation(PlayerPoser.Animation.STOMP, PlayerPoser.Animation.Recipient.ANYONE, 10);
            ((class_1657)iplayer.asEntity()).method_6043();
            iplayer.updateVelocity();
            AwaitTickQueue.scheduleTask(iplayer.asWorld(), arg_0 -> EarthPonyStompAbility.lambda$apply$1(r, arg_0), 5);
        } else {
            this.thrustDownwards(iplayer);
            iplayer.waitForFall(r);
        }
        return true;
    }

    public static void spawnEffectAround(Pony pony, class_1297 source, class_2338 center, double radius, double range) {
        class_2338.method_23627((class_3341)new class_3341(center).method_35410(class_3532.method_15384((double)radius))).forEach(i -> {
            double dist = Math.sqrt(i.method_40081(source.method_23317(), source.method_23318(), source.method_23321()));
            if (dist <= radius) {
                EarthPonyStompAbility.spawnEffect(pony, source.method_37908(), i, dist, range);
            }
        });
    }

    public static void spawnEffect(Pony pony, class_1937 w, class_2338 pos, double dist, double rad) {
        if (w.method_8320(pos.method_10084()).method_26215()) {
            class_2680 state = w.method_8320(pos);
            float hardness = state.method_26214((class_1922)w, pos);
            float scaledHardness = 1.0f - hardness / 70.0f;
            float damage = hardness < 0.0f ? 0.0f : (float)class_3532.method_15340((int)((int)((1.0 - dist / rad) * 9.0 * (double)scaledHardness)), (int)0, (int)9);
            EarthPonyStompAbility.stompBlock(pony, w, pos, damage);
        }
    }

    public static void stompBlock(Pony pony, class_1937 w, class_2338 pos, float damage) {
        class_2680 state = w.method_8320(pos);
        if (state.method_26215() || damage <= 0.0f) {
            return;
        }
        if (BlockDestructionManager.of(w).damageBlock(pos, damage) >= 10.0f && pony.canModifyAt(pos, ModificationType.PHYSICAL)) {
            w.method_22352(pos, true);
            if (w instanceof class_3218 && state.method_26164(class_3481.field_25806) && w.method_8409().method_43048(4) == 0) {
                class_1799 stack = new class_1799((class_1935)UItems.PEBBLES, 1 + w.method_8409().method_43048(2));
                class_2248.method_9577((class_1937)w, (class_2338)pos, (class_1799)stack);
                state.method_26180((class_3218)w, pos, stack, true);
            }
        } else {
            w.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
        }
        if (state.method_26164(UTags.Blocks.KICKS_UP_DUST) && w.field_9229.method_43048(4) == 0 && w.method_22347(pos.method_10084()) && w.method_8316(pos.method_10084()).method_15769()) {
            ParticleUtils.spawnParticle(w, (class_2394)new class_2388(UParticles.DUST_CLOUD, state), pos.method_10084().method_46558(), VecHelper.triangular(w.field_9229, 0.0, 0.1f));
        }
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExertion().addPercent(40.0f);
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
    }

    private static /* synthetic */ void lambda$apply$1(1 r, class_1937 w) {
        r.dispatch(0.0f);
    }
}

