/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.data.tree;

import com.minelittlepony.unicopia.ability.data.tree.TreeType;
import com.minelittlepony.unicopia.util.PosHelper;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class TreeTraverser {
    private static final class_2350[] WIDE_DIRS = new class_2350[]{class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039};
    private final TreeType type;
    private PosHelper.PositionRecord logs = new PosHelper.PositionRecord();
    private PosHelper.PositionRecord leaves = new PosHelper.PositionRecord();
    private final int maxRecurse = 50;

    public TreeTraverser(TreeType type) {
        this.type = type;
    }

    public PosHelper.PositionRecord collectLogs(class_1937 w, class_2338 pos) {
        this.traverse(w, pos.method_25503());
        return this.logs;
    }

    public PosHelper.PositionRecord collectLeaves(class_1937 w, class_2338 pos) {
        this.traverse(w, this.findCanopy(w, pos));
        return this.leaves;
    }

    public void traverse(class_1937 w, class_2338 pos) {
        this.traverse(w, pos.method_25503());
    }

    private void traverse(class_1937 w, class_2338.class_2339 pos) {
        this.logs = new PosHelper.PositionRecord();
        this.leaves = new PosHelper.PositionRecord();
        this.innerTraverse(w, pos, 0);
    }

    private void innerTraverse(class_1937 w, class_2338.class_2339 pos, int recurseLevel) {
        if (recurseLevel >= 50 || this.logs.hasVisited((class_2338)pos) || this.leaves.hasVisited((class_2338)pos)) {
            return;
        }
        class_2680 state = w.method_8320((class_2338)pos);
        boolean yay = false;
        if (this.type.isLeaves(state)) {
            this.leaves.visit((class_2338)pos);
            yay = true;
        } else if (this.type.isLog(state)) {
            this.logs.visit((class_2338)pos);
            yay = true;
        }
        if (yay) {
            PosHelper.fastAll((class_2338)pos, p -> this.innerTraverse(w, (class_2338.class_2339)p, recurseLevel + 1), WIDE_DIRS);
        }
    }

    private class_2338.class_2339 findCanopy(class_1937 w, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        while (this.type.isLog(w.method_8320((class_2338)mutable.method_10098(class_2350.field_11036))) && !PosHelper.fastAny((class_2338)mutable, p -> this.type.isLeaves(w.method_8320(p)), PosHelper.HORIZONTAL)) {
        }
        return mutable.method_10098(class_2350.field_11033);
    }

    public Optional<class_2338> findBase(class_1937 w, class_2338 pos) {
        this.logs.clear();
        return this.findBase(w, pos.method_25503());
    }

    private Optional<class_2338> findBase(class_1937 w, class_2338.class_2339 pos) {
        if (this.logs.hasVisited((class_2338)pos) || !this.type.isLog(w.method_8320((class_2338)pos))) {
            return Optional.empty();
        }
        do {
            this.logs.visit((class_2338)pos);
        } while (this.type.isLog(w.method_8320((class_2338)pos.method_10098(class_2350.field_11033))));
        pos.method_10098(class_2350.field_11036);
        if (this.type.isWide()) {
            PosHelper.fastAll((class_2338)pos, p -> this.findBase(w, (class_2338.class_2339)p).filter(a -> a.method_10264() < pos.method_10264()).ifPresent(arg_0 -> ((class_2338.class_2339)pos).method_10101(arg_0)), PosHelper.HORIZONTAL);
        }
        return Optional.of(this.logs.visit((class_2338)pos).method_10062());
    }
}

