/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.data.tree;

import com.google.gson.JsonElement;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.data.tree.TreeType;
import com.minelittlepony.unicopia.ability.data.tree.TreeTypeImpl;
import com.minelittlepony.unicopia.ability.data.tree.TreeTypes;
import com.minelittlepony.unicopia.util.Resources;
import com.minelittlepony.unicopia.util.Weighted;
import com.minelittlepony.unicopia.util.serialization.CodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class TreeTypeLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final class_2960 ID = Unicopia.id("data/tree_type");
    public static final TreeTypeLoader INSTANCE = new TreeTypeLoader();
    private Map<class_2960, TreeTypeDef> entries = new HashMap<class_2960, TreeTypeDef>();

    TreeTypeLoader() {
        super(Resources.GSON, "tree_types");
    }

    public Map<class_2960, TreeTypeDef> getEntries() {
        return this.entries;
    }

    public class_2960 getFabricId() {
        return ID;
    }

    protected void apply(Map<class_2960, JsonElement> resources, class_3300 manager, class_3695 profiler) {
        this.entries = Map.ofEntries((Map.Entry[])resources.entrySet().stream().filter(Objects::nonNull).map(entry -> TreeTypeDef.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).result().map(p -> (TreeTypeDef)p.getFirst()).map(p -> Map.entry((class_2960)entry.getKey(), p)).orElse(null)).filter(Objects::nonNull).toArray(Map.Entry[]::new));
        TreeTypes.load(this.entries);
    }

    public record TreeTypeDef(Set<class_2960> logs, Set<class_2960> leaves, Set<Drop> drops, boolean wideTrunk, int rarity, float leavesRatio) {
        public static final Codec<TreeTypeDef> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.setOf(class_2960.field_25139).fieldOf("logs").forGetter(TreeTypeDef::logs), (App)CodecUtils.setOf(class_2960.field_25139).fieldOf("leaves").forGetter(TreeTypeDef::leaves), (App)CodecUtils.setOf(Drop.CODEC).fieldOf("drops").forGetter(TreeTypeDef::drops), (App)Codec.BOOL.fieldOf("wideTrunk").forGetter(TreeTypeDef::wideTrunk), (App)Codec.INT.fieldOf("rarity").forGetter(TreeTypeDef::rarity), (App)Codec.FLOAT.fieldOf("leavesRatio").forGetter(TreeTypeDef::leavesRatio)).apply((Applicative)instance, TreeTypeDef::new));
        public static final class_9139<class_9129, TreeTypeDef> PACKET_CODEC = class_9139.method_58025((class_9139)class_2960.field_48267.method_56433(class_9135.method_56374(HashSet::new)), TreeTypeDef::logs, (class_9139)class_2960.field_48267.method_56433(class_9135.method_56374(HashSet::new)), TreeTypeDef::leaves, (class_9139)Drop.PACKET_CODEC.method_56433(class_9135.method_56374(HashSet::new)), TreeTypeDef::drops, (class_9139)class_9135.field_48547, TreeTypeDef::wideTrunk, (class_9139)class_9135.field_49675, TreeTypeDef::rarity, (class_9139)class_9135.field_48552, TreeTypeDef::leavesRatio, TreeTypeDef::new);

        public static Builder builder() {
            return new Builder();
        }

        public TreeType toTreeType(class_2960 id) {
            return new TreeTypeImpl(id, this.wideTrunk, Objects.requireNonNull(this.logs, "TreeType must have logs"), Objects.requireNonNull(this.leaves, "TreeType must have leaves"), Weighted.of(this.drops), this.rarity, this.leavesRatio);
        }

        public static class Builder {
            private final Set<class_2960> logs = new HashSet<class_2960>();
            private final Set<class_2960> leaves = new HashSet<class_2960>();
            private final Set<Drop> drops = new HashSet<Drop>();
            private boolean wideTrunk = false;
            private int rarity;
            private float leavesRatio = 0.5f;

            public Builder drop(int weight, class_6862<class_1792> tag) {
                this.drops.add(new Drop(weight, Optional.of(tag.comp_327()), Optional.empty()));
                return this;
            }

            public Builder drop(int weight, class_1935 item) {
                this.drops.add(new Drop(weight, Optional.empty(), Optional.of(class_7923.field_41178.method_10221((Object)item.method_8389()))));
                return this;
            }

            public Builder logs(class_2248 ... blocks) {
                Arrays.stream(blocks).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).forEach(this.logs::add);
                return this;
            }

            public Builder leaves(class_2248 ... blocks) {
                Arrays.stream(blocks).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).forEach(this.leaves::add);
                return this;
            }

            public Builder wideTrunk() {
                this.wideTrunk = true;
                return this;
            }

            public Builder rarity(int rarity) {
                this.rarity = rarity;
                return this;
            }

            public Builder leavesRatio(float leavesRatio) {
                this.leavesRatio = leavesRatio;
                return this;
            }

            public TreeTypeDef build() {
                return new TreeTypeDef(this.logs, this.leaves, this.drops, this.wideTrunk, this.rarity, this.leavesRatio);
            }
        }

        record Drop(int weight, Optional<class_2960> tag, Optional<class_2960> item) implements Weighted.Buildable<Supplier<class_1799>>
        {
            public static final Codec<Drop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("weight").forGetter(Drop::weight), (App)class_2960.field_25139.optionalFieldOf("tag").forGetter(Drop::tag), (App)class_2960.field_25139.optionalFieldOf("item").forGetter(Drop::item)).apply((Applicative)instance, Drop::new));
            public static final class_9139<class_9129, Drop> PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.field_49675, Drop::weight, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), Drop::tag, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), Drop::item, Drop::new);

            @Override
            public void appendTo(Weighted.Builder<Supplier<class_1799>> weighted) {
                if (this.item.isPresent()) {
                    class_7923.field_41178.method_17966(this.item.get()).ifPresent(item -> weighted.put(this.weight, () -> ((class_1792)item).method_7854()));
                } else {
                    weighted.put(this.weight, () -> class_7923.field_41178.method_40260(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)this.tag.get())).method_40243(Weighted.getRng()).map(class_6880::comp_349).map(class_1792::method_7854).orElse(class_1799.field_8037));
                }
            }
        }
    }
}

