/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.MultiSpellSlot;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.SpellSlots;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.network.track.Trackable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

class SingleSpellSlot
implements SpellSlots,
NbtSerialisable {
    private final Caster<?> owner;
    private final MultiSpellSlot.Entry<Spell> entry;

    public SingleSpellSlot(Caster<?> owner) {
        this.owner = owner;
        this.entry = new MultiSpellSlot.Entry(owner);
        Trackable.of(owner.asEntity()).getDataTrackers().getPrimaryTracker().startTracking(this.entry);
    }

    @Override
    public boolean contains(UUID id) {
        return this.entry.spell.equalsOrContains(id);
    }

    @Override
    public void put(@Nullable Spell effect) {
        this.entry.spell.set(effect, this.owner);
    }

    @Override
    public void remove(UUID id, boolean force) {
        if (this.contains(id)) {
            this.entry.discard(force);
        }
    }

    @Override
    public <T extends Spell> Stream<T> stream(@Nullable SpellPredicate<T> type) {
        return this.entry.spell.findMatches(type);
    }

    @Override
    public boolean clear(boolean force) {
        if (this.entry.spell.get() != null) {
            this.entry.discard(force);
            return true;
        }
        return false;
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10566("effect", (class_2520)this.entry.spell.toNBT(lookup));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.entry.spell.fromNBT(compound.method_10562("effect"), lookup);
    }

    @Override
    public void copyFrom(SpellSlots other, boolean alive) {
        other.get().ifPresent(this::put);
    }
}

