/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellSlots;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import java.util.function.Function;

public class SpellInventory {
    private final Caster<?> owner;
    private final SpellSlots slots;

    public SpellInventory(Caster<?> owner, SpellSlots slots) {
        this.owner = owner;
        this.slots = slots;
    }

    public SpellSlots getSlots() {
        return this.slots;
    }

    public boolean tick(Situation situation) {
        return this.tick((Spell spell) -> {
            if (spell.isDying()) {
                spell.tickDying(this.owner);
                return Operation.ofBoolean(!spell.isDead());
            }
            return Operation.ofBoolean(spell.tick(this.owner, situation));
        });
    }

    public boolean tick(Function<Spell, Operation> tickAction) {
        try {
            return this.forEach(spell -> {
                try {
                    return (Operation)((Object)((Object)tickAction.apply((Spell)spell)));
                }
                catch (Throwable t) {
                    Unicopia.LOGGER.error("Error whilst ticking spell on entity {}", this.owner, (Object)t);
                    return Operation.REMOVE;
                }
            });
        }
        catch (Exception e) {
            Unicopia.LOGGER.error("Error whilst ticking spell on entity {}", this.owner.asEntity(), (Object)e);
            return false;
        }
    }

    public boolean forEach(Function<Spell, Operation> test) {
        return this.slots.reduce((initial, spell) -> {
            Operation op = (Operation)((Object)((Object)test.apply((Spell)spell)));
            if (op == Operation.REMOVE) {
                this.slots.remove(spell.getUuid(), true);
            } else {
                initial = initial | op != Operation.SKIP;
            }
            return initial;
        });
    }

    public static enum Operation {
        SKIP,
        KEEP,
        REMOVE;


        public static Operation ofBoolean(boolean result) {
            return result ? KEEP : REMOVE;
        }
    }
}

