/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.google.common.base.MoreObjects;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.EmptySpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.SpellReference;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.server.world.Ether;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public abstract class AbstractDelegatingSpell
implements Spell {
    private UUID uuid = UUID.randomUUID();
    private final CustomisedSpellType<?> type;
    protected final SpellReference<Spell> delegate = new SpellReference();

    public AbstractDelegatingSpell(CustomisedSpellType<?> type) {
        this.type = type;
    }

    public AbstractDelegatingSpell(CustomisedSpellType<?> type, Spell delegate) {
        this.type = type;
        this.delegate.set(delegate);
    }

    public final Spell getDelegate() {
        return this.delegate.get();
    }

    @Override
    public final DataTracker getDataTracker() {
        return this.getOrEmpty().getDataTracker();
    }

    private Spell getOrEmpty() {
        return (Spell)MoreObjects.firstNonNull((Object)this.delegate.get(), (Object)EmptySpell.INSTANCE);
    }

    @Override
    public boolean equalsOrContains(UUID id) {
        return Spell.super.equalsOrContains(id) || this.delegate.equalsOrContains(id);
    }

    @Override
    public <T extends Spell> Stream<T> findMatches(SpellPredicate<T> predicate) {
        return Stream.concat(Spell.super.findMatches(predicate), this.delegate.findMatches(predicate));
    }

    @Override
    public CustomisedSpellType<?> getTypeAndTraits() {
        return this.type;
    }

    @Override
    public final UUID getUuid() {
        return this.uuid;
    }

    @Override
    public void setDead() {
        this.getOrEmpty().setDead();
    }

    @Override
    public void tickDying(Caster<?> caster) {
        this.getOrEmpty().tickDying(caster);
    }

    @Override
    public boolean isDead() {
        return this.getOrEmpty().isDead();
    }

    @Override
    public boolean isDying() {
        return this.getOrEmpty().isDying();
    }

    @Override
    public boolean isHidden() {
        return this.getOrEmpty().isHidden();
    }

    @Override
    public void setHidden(boolean hidden) {
        this.getOrEmpty().setHidden(hidden);
    }

    @Override
    public final void destroy(Caster<?> caster) {
        if (!caster.isClient()) {
            Ether.get(caster.asWorld()).remove(this, caster);
        }
        this.getOrEmpty().destroy(caster);
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        Spell s = this.getOrEmpty();
        if (s.isDying()) {
            s.tickDying(source);
            return !s.isDead();
        }
        return s.tick(source, situation);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_25927("uuid", this.uuid);
        compound.method_10566("spell", (class_2520)this.delegate.toNBT(lookup));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        if (compound.method_10545("uuid")) {
            this.uuid = compound.method_25926("uuid");
        }
        this.delegate.fromNBT(compound.method_10562("spell"), lookup);
    }

    public final String toString() {
        return "Delegate{" + String.valueOf(this.getTypeAndTraits()) + "}[uuid=" + String.valueOf(this.uuid) + "][spell=" + String.valueOf(this.delegate.get()) + "]";
    }
}

