/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class SpellReference<T extends Spell>
implements NbtSerialisable {
    @Nullable
    private transient T spell;

    @Nullable
    public T get() {
        return this.spell == null || this.spell.isDead() ? null : (T)this.spell;
    }

    public void set(T spell) {
        this.set(spell, null);
    }

    public boolean set(T spell, @Nullable Caster<?> owner) {
        Object v0 = (spell = spell == null || spell.isDead() ? null : spell);
        if (spell == this.spell) {
            return false;
        }
        T oldValue = this.spell;
        this.spell = spell;
        if (!(owner == null || oldValue == null || spell != null && oldValue.getUuid().equals(spell.getUuid()))) {
            oldValue.destroy(owner);
        }
        return true;
    }

    public boolean equalsOrContains(UUID id) {
        @Nullable T spell = this.get();
        return spell != null && spell.equalsOrContains(id);
    }

    public <V extends Spell> Stream<V> findMatches(SpellPredicate<V> predicate) {
        @Nullable V spell = this.get();
        return spell != null ? (predicate == null ? Stream.of(spell) : spell.findMatches(predicate)) : Stream.empty();
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        if (this.spell != null && !this.spell.isDead()) {
            this.spell.toNBT(compound, lookup);
            this.spell.getTypeAndTraits().toNbt(compound);
        }
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        if (this.spell == null || !Objects.equals(Spell.getUuid(compound), this.spell.getUuid())) {
            this.spell = Spell.readNbt(compound, lookup);
        } else {
            this.spell.fromNBT(compound, lookup);
        }
    }
}

