/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.data.Rot;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.server.world.UGameRules;
import com.minelittlepony.unicopia.server.world.UnicopiaWorldProperties;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class TimeControlAbilitySpell
extends AbstractSpell {
    private boolean initilized;
    private long timeOffset;
    private float angleOffset;

    public TimeControlAbilitySpell(CustomisedSpellType<?> type) {
        super(type);
        this.setHidden(true);
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        if (!source.asWorld().method_8450().method_8355(UGameRules.DO_TIME_MAGIC) || situation != Situation.BODY || !source.canUse(Abilities.TIME)) {
            return false;
        }
        this.update(source, Rot.of(source));
        return source.subtractEnergyCost(2.0);
    }

    public void update(Caster<?> source, Rot rotation) {
        if (!source.asWorld().method_8450().method_8355(UGameRules.DO_TIME_MAGIC)) {
            return;
        }
        class_1937 class_19372 = source.asWorld();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)class_19372;
        float yaw = -(rotation.yaw() + 90.0f);
        float pitch = -(rotation.pitch() / 90.0f);
        long time = (long)(pitch * 6000.0f);
        if (!this.initilized) {
            this.initilized = true;
            this.timeOffset = sw.method_8532() - time;
            this.angleOffset = UnicopiaWorldProperties.forWorld(sw).getTangentalSkyAngle() - yaw;
        }
        if (this.angleOffset > 90.0f && this.angleOffset < 270.0f) {
            time *= -1L;
        }
        if ((time += this.timeOffset) < 0L) {
            time += 24000L;
        }
        sw.method_29199(time %= 24000L);
        sw.method_8503().method_49749();
        UnicopiaWorldProperties.forWorld(sw).setTangentalSkyAngle(this.angleOffset + yaw);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10556("initilized", this.initilized);
        compound.method_10544("timeOffset", this.timeOffset);
        compound.method_10548("angleOffset", this.angleOffset);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.initilized = compound.method_10577("initilized");
        this.timeOffset = compound.method_10537("timeOffset");
        this.angleOffset = compound.method_10583("angleOffset");
    }
}

