/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.crafting;

import com.minelittlepony.unicopia.util.MutableVector;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public class AltarRecipeMatch {
    private final class_243 position;
    private final List<class_1542> stacks = new ArrayList<class_1542>();
    private final Int2ObjectMap<ItemInput> inputs = new Int2ObjectOpenHashMap();
    private final int minCrafts;
    private final class_1799 result;

    public AltarRecipeMatch(Stream<class_1542> stacks, class_1799 result) {
        MutableVector position = new MutableVector(class_243.field_1353);
        stacks.forEach(stack -> {
            this.stacks.add((class_1542)stack);
            position.add(stack.method_19538());
            ((ItemInput)this.inputs.computeIfAbsent(class_1792.method_7880((class_1792)stack.method_6983().method_7909()), i -> new ItemInput(this))).add((class_1542)stack);
        });
        position.multiply(1.0 / (double)this.stacks.size());
        this.position = position.toImmutable();
        this.minCrafts = this.inputs.values().stream().mapToInt(i -> i.count).min().orElse(0);
        this.result = result.method_46651(this.minCrafts * result.method_7947());
    }

    public int getMinCrafts() {
        return this.minCrafts;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public boolean isRemoved() {
        return this.stacks.stream().anyMatch(class_1297::method_31481);
    }

    public void consumeInputs(int crafts) {
        IntIterator intIterator = new IntOpenHashSet((IntCollection)this.inputs.keySet()).iterator();
        while (intIterator.hasNext()) {
            int itemId = (Integer)intIterator.next();
            this.consumeInput(itemId, crafts);
        }
    }

    public void consumeInput(int itemId, int amount) {
        this.inputs.compute(itemId, (i, entities) -> entities == null ? null : entities.consume(amount));
    }

    public void craft(class_1937 world) {
        class_1542 output = new class_1542(world, this.position.method_10216(), this.position.method_10214(), this.position.method_10215(), this.result);
        output.method_5684(true);
        this.consumeInputs(this.minCrafts);
        world.method_8649((class_1297)output);
    }

    class ItemInput {
        int count;
        final List<class_1542> entities = new ArrayList<class_1542>();

        ItemInput(AltarRecipeMatch this$0) {
        }

        public void add(class_1542 stack) {
            this.count += stack.method_6983().method_7947();
            this.entities.add(stack);
        }

        @Nullable
        public ItemInput consume(int amount) {
            int decremented;
            if (this.entities.isEmpty()) {
                return null;
            }
            this.count = Math.max(0, this.count - amount);
            for (int remainder = amount; remainder > 0 && !this.entities.isEmpty(); remainder -= decremented) {
                class_1542 entity = this.entities.get(0);
                class_1799 stack = entity.method_6983();
                decremented = Math.min(remainder, stack.method_7947());
                stack.method_7934(decremented);
                if (stack.method_7960()) {
                    entity.method_31472();
                    this.entities.remove(0);
                    continue;
                }
                entity.method_6979(stack);
            }
            if (this.entities.isEmpty()) {
                return null;
            }
            return this;
        }
    }
}

