/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.crafting;

import com.google.common.base.Suppliers;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.item.EnchantableItem;
import com.minelittlepony.unicopia.util.serialization.CodecUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class IngredientWithSpell
implements Predicate<class_1799> {
    private static final IngredientWithSpell EMPTY = new IngredientWithSpell(Optional.empty(), Optional.empty());
    private static final Predicate<class_1856> INGREDIENT_IS_PRESENT = ((Predicate<class_1856>)class_1856::method_8103).negate();
    public static final Codec<IngredientWithSpell> CODEC = CodecUtils.extend(class_1856.field_46095, SpellType.REGISTRY.method_39673().fieldOf("spell")).xmap(pair -> new IngredientWithSpell((Optional)pair.getFirst(), (Optional)pair.getSecond()), ingredient -> new Pair(ingredient.stack, ingredient.spell));
    public static final class_9139<class_9129, IngredientWithSpell> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.method_56382((class_9139)class_1856.field_48355), i -> i.stack, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267.method_56432(SpellType::getKey, SpellType::getId)), i -> i.spell, IngredientWithSpell::new);
    public static final Codec<class_2371<IngredientWithSpell>> LIST_CODEC = CODEC.listOf().xmap(list -> class_2371.method_10212((Object)EMPTY, (Object[])((IngredientWithSpell[])list.toArray(IngredientWithSpell[]::new))), Function.identity());
    private final Optional<class_1856> stack;
    private final Optional<SpellType<?>> spell;
    private final Supplier<class_1799[]> stacks;

    public static IngredientWithSpell mundane(class_1935 item) {
        return new IngredientWithSpell(Optional.of(class_1856.method_8091((class_1935[])new class_1935[]{item})), Optional.empty());
    }

    public static IngredientWithSpell of(class_1935 base, SpellType<?> spell) {
        if (spell == SpellType.EMPTY_KEY) {
            return IngredientWithSpell.mundane(base);
        }
        return new IngredientWithSpell(Optional.of(class_1856.method_8091((class_1935[])new class_1935[]{base})), Optional.of(spell));
    }

    private IngredientWithSpell(Optional<class_1856> stack, Optional<SpellType<?>> spell) {
        this.stack = stack;
        this.spell = spell;
        this.stacks = Suppliers.memoize(() -> (class_1799[])stack.stream().map(class_1856::method_8105).flatMap(Arrays::stream).map(s -> spell.map(p -> EnchantableItem.enchant(s, p)).orElse((class_1799)s)).toArray(class_1799[]::new));
    }

    @Override
    public boolean test(class_1799 t) {
        boolean stackMatch = this.stack.map(m -> m.method_8093(t)).orElse(true);
        boolean spellMatch = this.spell.map(m -> EnchantableItem.getSpellKey(t).equals(m)).orElse(true);
        return stackMatch && spellMatch;
    }

    public class_1799[] getMatchingStacks() {
        return this.stacks.get();
    }

    public boolean isEmpty() {
        return this.stack.filter(INGREDIENT_IS_PRESENT).isEmpty() && this.spell.isEmpty();
    }
}

