/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractAreaEffectSpell;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.CastOn;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.FriendshipBraceletItem;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.server.world.Ether;
import com.minelittlepony.unicopia.util.shape.Sphere;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;

public class AreaProtectionSpell
extends AbstractAreaEffectSpell {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.FOCUS, 50.0f).with(Trait.STRENGTH, 30.0f).build();
    private static final SpellAttribute<CastOn> CAST_ON = SpellAttribute.createEnumerated(SpellAttributeType.CAST_ON, Trait.FOCUS, focus -> focus > 0.0f ? CastOn.SELF : CastOn.LOCATION);
    static final TooltipFactory TOOLTIP = TooltipFactory.of(CAST_ON, RANGE);

    protected AreaProtectionSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public Spell prepareForCast(Caster<?> caster, CastingMethod method) {
        return method == CastingMethod.STAFF || CAST_ON.get(this.getTraits()) == CastOn.LOCATION ? this.toPlaceable() : this;
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        if (situation == Situation.PROJECTILE || situation == Situation.BODY) {
            return false;
        }
        float radius = (float)this.getRange(source);
        if (source.isClient()) {
            class_243 origin = source.getOriginVector();
            source.spawnParticles(origin, new Sphere(true, radius), (int)(radius * 6.0f), pos -> {
                if (!source.asWorld().method_22347(class_2338.method_49638((class_2374)pos))) {
                    source.addParticle(new MagicParticleEffect(this.getType().getColor()), (class_243)pos, class_243.field_1353);
                }
            });
        } else {
            Ether.get(source.asWorld()).getOrCreate(this, source).setRadius(radius);
        }
        source.findAllSpellsInRange(radius, e -> this.isValidTarget(source, (class_1297)e)).filter(caster -> !caster.hasCommonOwner(source)).forEach(caster -> caster.asEntity().method_5768());
        return !this.isDead();
    }

    private double getRange(Caster<?> source) {
        Pony pony;
        float multiplier = source instanceof Pony && ((class_1657)(pony = (Pony)source).asEntity()).method_5715() ? 1 : 2;
        float min = ((Float)RANGE.get(this.getTraits())).floatValue();
        double range = (min + source.getLevel().getScaled(4.0f) * 2.0f) / multiplier;
        if (source instanceof Pony && range > 2.0) {
            range = Math.sqrt(range);
        }
        return range;
    }

    public boolean blocksMagicFor(Caster<?> source, Caster<?> other, class_243 position) {
        return !FriendshipBraceletItem.isComrade(other, other.asEntity()) && source.getOriginVector().method_1022(position) <= this.getRange(source);
    }

    protected boolean isValidTarget(Caster<?> source, class_1297 entity) {
        return entity.method_5864() == UEntities.MAGIC_BEAM;
    }
}

