/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.Affects;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.duck.Hoverable;
import com.minelittlepony.unicopia.projectile.MagicBeamEntity;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class CatapultSpell
extends AbstractSpell
implements ProjectileDelegate.BlockHitListener,
ProjectileDelegate.EntityHitListener {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.FOCUS, 50.0f).with(Trait.KNOWLEDGE, 1.0f).with(Trait.EARTH, 60.0f).with(Trait.STRENGTH, 50.0f).build();
    private static final float HORIZONTAL_VARIANCE = 0.25f;
    private static final float MAX_STRENGTH = 120.0f;
    private static final SpellAttribute<Float> LAUNCH_SPEED = SpellAttribute.create(SpellAttributeType.VERTICAL_VELOCITY, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.STRENGTH, strength -> Float.valueOf(0.1f + (class_3532.method_15363((float)strength, (float)-120.0f, (float)120.0f) - 40.0f) / 16.0f));
    private static final SpellAttribute<Float> HANG_TIME = SpellAttribute.create(SpellAttributeType.HANG_TIME, AttributeFormat.TIME, AttributeFormat.PERCENTAGE, Trait.AIR, air -> Float.valueOf(50.0f + (float)((int)class_3532.method_15363((float)air, (float)0.0f, (float)10.0f)) * 20.0f));
    private static final SpellAttribute<Float> PUSHING_POWER = SpellAttribute.create(SpellAttributeType.PUSHING_POWER, AttributeFormat.REGULAR, Trait.POWER, power -> Float.valueOf(1.0f + class_3532.method_15363((float)power, (float)0.0f, (float)10.0f) / 10.0f));
    private static final SpellAttribute<Boolean> CAUSES_LEVITATION = SpellAttribute.createConditional(SpellAttributeType.CAUSES_LEVITATION, Trait.FOCUS, (Float2ObjectFunction<Boolean>)((Float2ObjectFunction)focus -> focus > 50.0f));
    private static final SpellAttribute<Affects> AFFECTS = SpellAttribute.createEnumerated(SpellAttributeType.AFFECTS, Trait.ORDER, order -> {
        if (order <= 0.0f) {
            return Affects.BOTH;
        }
        if (order <= 10.0f) {
            return Affects.ENTITIES;
        }
        return Affects.BLOCKS;
    });
    static final TooltipFactory TOOLTIP = TooltipFactory.of(LAUNCH_SPEED, HANG_TIME, PUSHING_POWER, CAUSES_LEVITATION, AFFECTS);

    static void appendTooltip(CustomisedSpellType<? extends CatapultSpell> type, List<class_2561> tooltip) {
        TOOLTIP.appendTooltip(type, tooltip);
    }

    protected CatapultSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3965 hit) {
        MagicBeamEntity source;
        if (!AFFECTS.get(this.getTraits()).allowsBlocks()) {
            return;
        }
        if (!projectile.isClient() && projectile instanceof MagicBeamEntity && (source = (MagicBeamEntity)projectile).canModifyAt(hit.method_17777())) {
            CatapultSpell.createBlockEntity(projectile.method_37908(), hit.method_17777(), e -> {
                e.method_24830(true);
                this.apply(source, (class_1297)e);
                e.method_24830(false);
            });
        }
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3966 hit) {
        if (!projectile.isClient() && projectile instanceof MagicBeamEntity) {
            MagicBeamEntity source = (MagicBeamEntity)projectile;
            class_1297 e = hit.method_17782();
            if (!(e instanceof class_1540) && !AFFECTS.get(this.getTraits()).allowsEntities()) {
                return;
            }
            this.apply(source, hit.method_17782());
        }
    }

    @Override
    public boolean tick(Caster<?> caster, Situation situation) {
        if (situation == Situation.PROJECTILE) {
            return true;
        }
        this.getTypeAndTraits().create().toThrowable().throwProjectile(caster);
        this.setDead();
        return this.isDead();
    }

    protected void apply(Caster<?> caster, class_1297 e) {
        float power = 1.0f + this.getTraits().get(Trait.POWER, 0.0f, 10.0f) / 10.0f;
        if (!e.method_24828()) {
            e.method_18799(caster.asEntity().method_18798().method_1021((double)power));
        } else {
            class_1309 l;
            class_5819 rng = caster.asWorld().field_9229;
            e.method_5762(rng.method_43385(0.0, 0.25) * (double)0.1f, (double)LAUNCH_SPEED.get(this.getTraits()).floatValue(), rng.method_43385(0.0, 0.25) * (double)0.1f);
            int hoverDuration = HANG_TIME.get(this.getTraits()).intValue();
            boolean noGravity = CAUSES_LEVITATION.get(this.getTraits());
            if (e instanceof class_1309) {
                l = (class_1309)e;
                if (l.method_6059(class_1294.field_5906)) {
                    l.method_6016(class_1294.field_5906);
                }
                l.method_6092(new class_1293(class_1294.field_5906, hoverDuration, 1));
            }
            if (noGravity || e instanceof class_1540 && this.hasRoof(e.method_37908(), e.method_24515().method_10084())) {
                if (e instanceof class_1309) {
                    l = (class_1309)e;
                    l.method_6092(new class_1293(class_1294.field_5902, 200, 1));
                } else {
                    e.method_5875(true);
                    if (e instanceof Hoverable) {
                        Hoverable h = (Hoverable)e;
                        h.setTicksHovering(20);
                    }
                }
            }
        }
        e.field_6007 = true;
        e.field_6037 = true;
    }

    private boolean hasRoof(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return !state.method_45474() && !state.method_26220((class_1922)world, pos).method_1110();
    }

    static void createBlockEntity(class_1937 world, class_2338 bpos, @Nullable Consumer<class_1297> apply) {
        if (world.method_22347(bpos)) {
            return;
        }
        class_2680 state = world.method_8320(bpos);
        if (state.method_26164(UTags.Blocks.CATAPULT_IMMUNE)) {
            return;
        }
        class_243 pos = class_243.method_24955((class_2382)bpos);
        class_1540 e = new class_1540(world, pos.field_1352, pos.field_1351, pos.field_1350, (class_2680)((class_2680)state.method_47968((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).method_47968((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12569));
        if (state.method_31709()) {
            e.field_7194 = world.method_22350(bpos).method_20598(bpos, (class_7225.class_7874)world.method_30349());
        }
        world.method_8544(bpos);
        world.method_8650(bpos, true);
        e.method_24830(false);
        e.field_7192 = Integer.MIN_VALUE;
        e.method_6965(1.0f + world.field_9229.method_43057() * 10.0f, 100);
        if (apply != null) {
            apply.accept((class_1297)e);
        }
        world.method_8649((class_1297)e);
    }
}

