/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractAreaEffectSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.block.state.StateMaps;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import com.minelittlepony.unicopia.util.shape.Sphere;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_8110;
import net.minecraft.class_8111;

public class FireSpell
extends AbstractAreaEffectSpell
implements ProjectileDelegate.BlockHitListener,
ProjectileDelegate.EntityHitListener {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.FIRE, 15.0f).build();

    protected FireSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3965 hit) {
        if (!projectile.isClient()) {
            class_243 pos = hit.method_17784();
            projectile.asWorld().method_8437(projectile.method_24921(), pos.method_10216(), pos.method_10214(), pos.method_10215(), 2.0f, class_1937.class_7867.field_40890);
        }
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3966 hit) {
        if (!projectile.isClient()) {
            class_1297 entity = hit.method_17782();
            projectile.asWorld().method_8437(projectile.method_24921(), entity.method_23317(), entity.method_23318(), entity.method_23321(), 2.0f, class_1937.class_7867.field_40890);
        }
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        if (source.isClient()) {
            this.generateParticles(source);
        }
        return new Sphere(false, ((Float)RANGE.get(this.getTraits())).floatValue()).translate((class_2382)source.getOrigin()).getBlockPositions().reduce(false, (r, i) -> source.canModifyAt((class_2338)i) && this.applyBlocks(source.asWorld(), (class_2338)i), (a, b) -> a != false || b != false) != false || this.applyEntities(source, source.getOriginVector());
    }

    protected void generateParticles(Caster<?> source) {
        source.spawnParticles(new Sphere(false, ((Float)RANGE.get(this.getTraits())).floatValue()), (int)(1.0f + source.getLevel().getScaled(8.0f)) * 6, pos -> source.addParticle((class_2394)class_2398.field_11237, (class_243)pos, class_243.field_1353));
    }

    protected boolean applyBlocks(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (!state.method_26215()) {
            if (state.method_27852(class_2246.field_10515)) {
                if (world.method_22347(pos.method_10084())) {
                    if (world.field_9229.method_43048(300) == 0) {
                        world.method_8501(pos.method_10084(), class_2246.field_10036.method_9564());
                    }
                    return true;
                }
            } else {
                if (state.method_27852(class_2246.field_10091)) {
                    int power = world.field_9229.method_43048(5) == 3 ? 15 : 3;
                    this.sendPower(world, pos, power, 3, 0);
                    return true;
                }
                if (state.method_26164(class_3481.field_15466) && world.field_9229.method_43048(10) == 0) {
                    if (FireSpell.isSurroundedBySand(world, pos)) {
                        world.method_8501(pos, class_2246.field_10033.method_9564());
                        this.playEffect(world, pos);
                        return true;
                    }
                } else if (state.method_26164(class_3481.field_15503)) {
                    if (world.method_22347(pos.method_10084())) {
                        world.method_8501(pos.method_10084(), class_2246.field_10036.method_9564());
                        this.playEffect(world, pos);
                        return true;
                    }
                } else if (StateMaps.FIRE_AFFECTED.convert(world, pos)) {
                    this.playEffect(world, pos);
                    return true;
                }
            }
        }
        return false;
    }

    protected float getEntityEffectRange() {
        return Math.max(0.0f, ((Float)RANGE.get(this.getTraits())).floatValue() - 1.0f);
    }

    protected boolean applyEntities(Caster<?> source, class_243 pos) {
        return source.findAllEntitiesInRange(this.getEntityEffectRange(), e -> {
            class_1309 master = (class_1309)source.getMaster();
            return (!e.equals(source.asEntity()) && !e.equals((Object)master) || master instanceof class_1657 && !EquinePredicates.PLAYER_UNICORN.test((class_1297)master)) && !(e instanceof class_1542) && !(e instanceof Caster);
        }).filter(e -> {
            e.method_5639(60.0f);
            e.method_5643(this.getDamageCause(source, (class_1297)e), 0.1f);
            this.playEffect(source.asWorld(), e.method_24515());
            return true;
        }).count() > 0L;
    }

    protected class_1282 getDamageCause(Caster<?> source, class_1297 target) {
        return source.damageOf((class_5321<class_8110>)class_8111.field_42335, source);
    }

    private void sendPower(class_1937 w, class_2338 pos, int power, int max, int i) {
        class_2680 state = w.method_8320(pos);
        class_2248 id = state.method_26204();
        if (i < max && id == class_2246.field_10091) {
            w.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(power)));
            this.sendPower(w, pos.method_10084(), power, max, ++i);
            this.sendPower(w, pos.method_10074(), power, max, i);
            this.sendPower(w, pos.method_10095(), power, max, i);
            this.sendPower(w, pos.method_10072(), power, max, i);
            this.sendPower(w, pos.method_10078(), power, max, i);
            this.sendPower(w, pos.method_10067(), power, max, i);
        }
    }

    protected void playEffect(class_1937 world, class_2338 pos) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        world.method_8396(null, pos, USounds.SPELL_FIRE_CRACKLE, class_3419.field_15256, 0.5f, 2.6f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            ParticleUtils.spawnParticle(world, (class_2394)class_2398.field_11237, new class_243((double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random()), class_243.field_1353);
        }
    }

    public static boolean isSurroundedBySand(class_1937 w, class_2338 pos) {
        return FireSpell.isSand(w, pos.method_10084()) && FireSpell.isSand(w, pos.method_10074()) && FireSpell.isSand(w, pos.method_10095()) && FireSpell.isSand(w, pos.method_10072()) && FireSpell.isSand(w, pos.method_10078()) && FireSpell.isSand(w, pos.method_10067());
    }

    public static boolean isSand(class_1937 world, class_2338 pos) {
        class_2248 id = world.method_8320(pos).method_26204();
        return id == class_2246.field_10102 || id == class_2246.field_10033;
    }
}

