/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.OrientedSpell;
import com.minelittlepony.unicopia.ability.magic.spell.PlacementControlSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgCasterLookRequest;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.server.world.Ether;
import com.minelittlepony.unicopia.util.shape.Shape;
import com.minelittlepony.unicopia.util.shape.Sphere;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class PortalSpell
extends AbstractSpell
implements PlacementControlSpell.PlacementDelegate,
OrientedSpell {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.LIFE, 10.0f).with(Trait.KNOWLEDGE, 1.0f).with(Trait.ORDER, 25.0f).build();
    private static final Shape PARTICLE_AREA = new Sphere(true, 2.0, 1.0f, 1.0f, 0.0f);
    private final DataTracker.Entry<Optional<UUID>> targetPortalId;
    private final DataTracker.Entry<Float> targetPortalPitch;
    private final DataTracker.Entry<Float> targetPortalYaw;
    private final EntityReference<class_1297> teleportationTarget;
    private final DataTracker.Entry<Float> pitch;
    private final DataTracker.Entry<Float> yaw;
    private Shape particleArea;

    protected PortalSpell(CustomisedSpellType<?> type) {
        super(type);
        this.targetPortalId = this.dataTracker.startTracking(TrackableDataType.UUID, Optional.empty());
        this.targetPortalPitch = this.dataTracker.startTracking(TrackableDataType.FLOAT, Float.valueOf(0.0f));
        this.targetPortalYaw = this.dataTracker.startTracking(TrackableDataType.FLOAT, Float.valueOf(0.0f));
        this.teleportationTarget = this.dataTracker.startTracking(new EntityReference());
        this.pitch = this.dataTracker.startTracking(TrackableDataType.FLOAT, Float.valueOf(0.0f));
        this.yaw = this.dataTracker.startTracking(TrackableDataType.FLOAT, Float.valueOf(0.0f));
        this.particleArea = PARTICLE_AREA;
    }

    public EntityReference<class_1297> getDestinationReference() {
        return this.teleportationTarget;
    }

    public float getPitch() {
        return this.pitch.get().floatValue();
    }

    public float getYaw() {
        return this.yaw.get().floatValue();
    }

    public float getTargetPitch() {
        return this.targetPortalPitch.get().floatValue();
    }

    public float getTargetYaw() {
        return this.targetPortalYaw.get().floatValue();
    }

    public float getYawDifference() {
        return class_3532.method_15393((float)(180.0f + this.getTargetYaw() - this.getYaw()));
    }

    private Ether.Entry<PortalSpell> getDestination(Caster<?> source) {
        return this.targetPortalId.get().flatMap(id -> this.getDestinationReference().getTarget().map(target -> Ether.get(source.asWorld()).get(this.getType(), target.uuid(), (UUID)id)).filter(destination -> destination.isClaimedBy(this.getUuid()))).orElse(null);
    }

    @Override
    public boolean apply(Caster<?> caster) {
        return this.toPlaceable().apply(caster);
    }

    protected void setDestination(@Nullable Ether.Entry<?> destination) {
        if (destination == null) {
            this.teleportationTarget.set(null);
            this.targetPortalId.set(Optional.empty());
        } else {
            this.teleportationTarget.copyFrom(destination.entity);
            this.targetPortalId.set(Optional.of(destination.getSpellId()));
            this.targetPortalPitch.set(Float.valueOf(destination.getPitch()));
            this.targetPortalYaw.set(Float.valueOf(destination.getYaw()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        if (situation == Situation.GROUND) {
            if (source.isClient()) {
                source.spawnParticles(this.particleArea, 5, pos -> source.addParticle((class_2394)class_2398.field_29644, (class_243)pos, class_243.field_1353));
            } else {
                Ether.Entry<PortalSpell> ownEntry;
                Ether.Entry<PortalSpell> entry2 = ownEntry = Ether.get(source.asWorld()).get(this, source);
                synchronized (entry2) {
                    Ether.Entry<PortalSpell> targetEntry = this.getDestination(source);
                    if (targetEntry == null) {
                        if (this.teleportationTarget.isSet()) {
                            this.setDestination(null);
                            source.asWorld().method_20290(2001, source.getOrigin(), class_2248.method_9507((class_2680)class_2246.field_10033.method_9564()));
                        } else {
                            Ether.get(source.asWorld()).anyMatch(this.getType(), entry -> {
                                if (entry.isAlive() && !entry.hasClaimant() && !entry.entityMatches(source.asEntity().method_5667())) {
                                    entry.claim(this.getUuid());
                                    ownEntry.claim(entry.getSpellId());
                                    Ether.Entry entry2 = entry;
                                    synchronized (entry2) {
                                        Object patt0$temp = entry.getSpell();
                                        if (patt0$temp instanceof PortalSpell) {
                                            PortalSpell portal = (PortalSpell)patt0$temp;
                                            portal.setDestination(ownEntry);
                                        }
                                    }
                                    this.setDestination((Ether.Entry<?>)entry);
                                }
                                return false;
                            });
                        }
                    } else {
                        this.targetPortalPitch.set(Float.valueOf(targetEntry.getPitch()));
                        this.targetPortalYaw.set(Float.valueOf(targetEntry.getYaw()));
                        this.tickActive(source, targetEntry);
                    }
                }
                ownEntry.setPitch(this.getPitch());
                ownEntry.setYaw(this.getYaw());
            }
        }
        return !this.isDead();
    }

    private void tickActive(Caster<?> source, Ether.Entry<?> destination) {
        destination.entity.getTarget().ifPresent(target -> {
            Quaternionf rotationChange = this.getOrientationChange();
            Matrix4f matrix = this.getPositionMatrix(source, source.asEntity().method_19538(), rotationChange, new Matrix4f());
            float yawDifference = this.getYawDifference();
            source.findAllEntitiesInRange(1.0).forEach(entity -> {
                if (!entity.method_30230()) {
                    float approachYaw = Math.abs(class_3532.method_15393((float)(entity.method_36454() - this.yaw.get().floatValue())));
                    if (approachYaw > 80.0f) {
                        return;
                    }
                    Vector4f dest4f = matrix.transform(new Vector4f((Vector3fc)entity.method_19538().method_46409(), 1.0f));
                    class_243 dest = new class_243((double)dest4f.x, (double)dest4f.y - 0.5, (double)dest4f.z).method_1019(new class_243(0.0, 0.0, (double)-0.7f).method_1024(-this.getTargetYaw() * ((float)Math.PI / 180)));
                    for (int i = 0; i < 2; ++i) {
                        class_2338 destBlock = class_2338.method_49638((class_2374)dest);
                        class_2680 state = entity.method_37908().method_8320(destBlock);
                        if (!entity.method_37908().method_8515(destBlock, entity)) continue;
                        double maxY = state.method_26220((class_1922)entity.method_37908(), destBlock).method_1105(class_2350.class_2351.field_11052);
                        dest = new class_243(dest.field_1352, (double)destBlock.method_10264() + maxY, dest.field_1350);
                    }
                    entity.method_30229();
                    float yaw = class_3532.method_15393((float)(entity.method_36454() + yawDifference));
                    entity.method_18799(entity.method_18798().method_1024(yawDifference * ((float)Math.PI / 180)));
                    entity.method_37908().method_43129(null, entity, USounds.ENTITY_PLAYER_UNICORN_TELEPORT, entity.method_5634(), 1.0f, 1.0f);
                    entity.method_48105((class_3218)entity.method_37908(), dest.field_1352, dest.field_1351, dest.field_1350, class_2709.field_40710, yaw, entity.method_36455());
                    entity.method_37908().method_43129(null, entity, USounds.ENTITY_PLAYER_UNICORN_TELEPORT, entity.method_5634(), 1.0f, 1.0f);
                    Living.updateVelocity(entity);
                    if (!source.subtractEnergyCost(Math.sqrt(entity.method_19538().method_1020(dest).method_1033()))) {
                        this.setDead();
                    }
                }
                ParticleUtils.spawnParticles(new MagicParticleEffect(this.getType().getColor()), entity, 7);
            });
        });
    }

    public Matrix4f getPositionMatrix(Caster<?> source, class_243 pos, Quaternionf orientationChange, Matrix4f matrix) {
        this.getDestinationReference().getTarget().ifPresent(destEntity -> {
            Vector3f destPos = destEntity.pos().method_46409();
            Vector3f sourcePos = pos.method_46409();
            matrix.rotateAround((Quaternionfc)orientationChange.conjugate(), destPos.x, destPos.y, destPos.z);
            matrix.translate((Vector3fc)destPos.sub((Vector3fc)sourcePos));
        });
        return matrix;
    }

    public Quaternionf getOrientationChange() {
        return new Quaternionf().rotateTo((Vector3fc)class_243.method_1030((float)this.getPitch(), (float)this.getYaw()).method_46409(), (Vector3fc)class_243.method_1030((float)this.getTargetPitch(), (float)this.getTargetYaw()).method_46409());
    }

    @Override
    public void setOrientation(Caster<?> caster, float pitch, float yaw) {
        this.pitch.set(Float.valueOf(90.0f - pitch));
        this.yaw.set(Float.valueOf(-yaw));
        this.particleArea = PARTICLE_AREA.rotate(this.pitch.get().floatValue() * ((float)Math.PI / 180), (180.0f - this.yaw.get().floatValue()) * ((float)Math.PI / 180));
    }

    @Override
    public void onPlaced(Caster<?> source, PlacementControlSpell parent) {
        Object caster = source.asEntity();
        class_243 targetPos = caster.method_5720().method_1021(3.0).method_1019(caster.method_33571());
        parent.setOrientation(source, -90.0f - source.asEntity().method_36455(), -source.asEntity().method_36454());
        parent.setPosition(new class_243(targetPos.field_1352, caster.method_19538().field_1351, targetPos.field_1350));
        if (source instanceof Pony) {
            Pony pony = (Pony)source;
            Channel.SERVER_REQUEST_PLAYER_LOOK.sendToPlayer((Object)new MsgCasterLookRequest(parent.getUuid()), (class_3222)pony.asEntity());
        }
    }

    @Override
    protected void onDestroyed(Caster<?> caster) {
        Ether.Entry<PortalSpell> destination;
        super.onDestroyed(caster);
        if (!caster.isClient() && (destination = this.getDestination(caster)) != null) {
            destination.release(this.getUuid());
        }
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        this.targetPortalId.get().ifPresent(i -> compound.method_25927("targetPortalId", i));
        compound.method_10566("teleportationTarget", (class_2520)this.teleportationTarget.toNBT(lookup));
        compound.method_10548("pitch", this.getPitch());
        compound.method_10548("yaw", this.getYaw());
        compound.method_10548("targetPortalPitch", this.getTargetPitch());
        compound.method_10548("targetPortalYaw", this.getTargetYaw());
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.targetPortalId.set(compound.method_25928("targetPortalId") ? Optional.of(compound.method_25926("targetPortalId")) : Optional.empty());
        this.teleportationTarget.fromNBT(compound.method_10562("teleportationTarget"), lookup);
        this.pitch.set(Float.valueOf(compound.method_10583("pitch")));
        this.yaw.set(Float.valueOf(compound.method_10583("yaw")));
        this.targetPortalPitch.set(Float.valueOf(compound.method_10583("targetPortalPitch")));
        this.targetPortalYaw.set(Float.valueOf(compound.method_10583("targetPortalYaw")));
        this.particleArea = PARTICLE_AREA.rotate(this.pitch.get().floatValue() * ((float)Math.PI / 180), (180.0f - this.yaw.get().floatValue()) * ((float)Math.PI / 180));
    }
}

