/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.entity.mob.ButterflyEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import com.minelittlepony.unicopia.util.RegistryUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3966;
import net.minecraft.class_5819;

public class TransformationSpell
extends AbstractSpell
implements ProjectileDelegate.EntityHitListener {
    protected TransformationSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public boolean tick(Caster<?> caster, Situation situation) {
        return situation == Situation.PROJECTILE;
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3966 hit) {
        if (projectile.method_37908().field_9236) {
            return;
        }
        class_1297 entity = hit.method_17782();
        this.pickType(entity.method_5864(), entity.method_37908()).flatMap(type -> this.convert(entity, (class_1299<? extends class_1308>)type)).ifPresentOrElse(e -> entity.method_5783(USounds.SPELL_TRANSFORM_TRANSMUTE_ENTITY, 1.0f, 1.0f), () -> {
            ParticleUtils.spawnParticles((class_2394)class_2398.field_11251, entity, 20);
            entity.method_5783(USounds.GUI_ABILITY_FAIL, 1.0f, 1.0f);
        });
    }

    private Optional<? extends class_1308> convert(class_1297 entity, class_1299<? extends class_1308> type) {
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            try {
                return Optional.ofNullable(mob.method_29243(type, true));
            }
            catch (Exception e) {
                return Optional.ofNullable((ButterflyEntity)mob.method_29243(UEntities.BUTTERFLY, true));
            }
        }
        return Optional.empty();
    }

    private <T extends class_1308> Optional<class_1299<T>> pickType(class_1299<?> except, class_1937 world) {
        Set options = RegistryUtils.valuesForTag(world, UTags.Entities.TRANSFORMABLE).collect(Collectors.toSet());
        if (except.method_5891() == class_1311.field_6302) {
            options.removeIf(t -> t.method_5891() == class_1311.field_6302);
        } else {
            options.remove(except);
        }
        if (options.size() <= 1) {
            return options.stream().findFirst().map(t -> t);
        }
        return Optional.ofNullable((class_1299)class_156.method_32309(new ArrayList(options), (class_5819)world.field_9229));
    }
}

