/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.trait;

import com.minelittlepony.unicopia.ability.magic.spell.trait.ItemWithTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.client.gui.ItemTraitsTooltipRenderer;
import com.minelittlepony.unicopia.item.component.UDataComponentTypes;
import com.minelittlepony.unicopia.util.InventoryUtil;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class SpellTraits
implements Iterable<Map.Entry<Trait, Float>> {
    public static final SpellTraits EMPTY = new SpellTraits(Map.of());
    private static final SpellTraits SPAWN_EGG_TRAITS = new SpellTraits(Map.of(Trait.LIFE, Float.valueOf(20.0f)));
    private static Map<class_2960, SpellTraits> REGISTRY = new HashMap<class_2960, SpellTraits>();
    static final Map<Trait, List<class_1792>> ITEMS = new HashMap<Trait, List<class_1792>>();
    public static final Codec<SpellTraits> CODEC = Codec.unboundedMap(Trait.CODEC, (Codec)Codec.FLOAT).flatXmap(map -> DataResult.success((Object)SpellTraits.fromEntries(map.entrySet().stream())), traits -> DataResult.success(traits.traits));
    public static final class_9139<ByteBuf, SpellTraits> PACKET_CODEC = class_9135.method_56377(i -> new EnumMap(Trait.class), Trait.PACKET_CODEC, (class_9139)class_9135.field_48552).method_56432(entries -> SpellTraits.fromEntries(entries.entrySet().stream()), traits -> traits.traits);
    private final EnumMap<Trait, Float> traits;
    private final float corruption;

    public static void load(Map<class_2960, SpellTraits> newRegistry) {
        REGISTRY = newRegistry;
        ITEMS.clear();
        REGISTRY.forEach((? super K itemId, ? super V traits) -> class_7923.field_41178.method_17966(itemId).ifPresent(item -> traits.forEach(entry -> {
            List items = ITEMS.computeIfAbsent((Trait)entry.getKey(), k -> new ArrayList());
            if (!items.contains(item)) {
                items.add(item);
            }
        })));
    }

    public static SpellTraits empty() {
        return EMPTY;
    }

    public static Map<class_2960, SpellTraits> all() {
        return new HashMap<class_2960, SpellTraits>(REGISTRY);
    }

    private SpellTraits(Map<Trait, Float> traits) {
        this.traits = traits.isEmpty() ? new EnumMap(Trait.class) : new EnumMap<Trait, Float>(traits);
        this.corruption = (float)this.stream().filter(e -> ((Float)e.getValue()).floatValue() != 0.0f).mapToDouble(e -> ((Trait)e.getKey()).getGroup().getCorruption()).sum();
    }

    private SpellTraits(SpellTraits from) {
        this.traits = new EnumMap<Trait, Float>(from.traits);
        this.corruption = from.corruption;
    }

    public float getCorruption() {
        return this.corruption;
    }

    public SpellTraits multiply(float factor) {
        return factor == 0.0f ? EMPTY : this.map((Float v) -> Float.valueOf(v.floatValue() * factor));
    }

    public SpellTraits add(float amount) {
        return amount == 0.0f ? this : this.map((Float v) -> Float.valueOf(v.floatValue() + amount));
    }

    public SpellTraits add(SpellTraits traits) {
        return SpellTraits.union(this, traits);
    }

    public SpellTraits map(Function<Float, Float> function) {
        return this.map((Trait k, Float v) -> (Float)function.apply((Float)v));
    }

    public SpellTraits map(BiFunction<Trait, Float, Float> function) {
        if (this.isEmpty()) {
            return this;
        }
        EnumMap<Trait, Float> newMap = new EnumMap<Trait, Float>(this.traits);
        newMap.entrySet().forEach(entry -> entry.setValue((Float)function.apply((Trait)entry.getKey(), (Float)entry.getValue())));
        return SpellTraits.fromEntries(newMap.entrySet().stream());
    }

    public boolean isEmpty() {
        return this.traits.isEmpty();
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean includes(SpellTraits other) {
        return other.stream().allMatch(pair -> this.get((Trait)pair.getKey()) >= ((Float)pair.getValue()).floatValue());
    }

    @Override
    public Iterator<Map.Entry<Trait, Float>> iterator() {
        return this.entries().iterator();
    }

    public Set<Map.Entry<Trait, Float>> entries() {
        return this.traits.entrySet();
    }

    public Stream<Map.Entry<Trait, Float>> stream() {
        return this.entries().stream();
    }

    public float getOrDefault(Trait trait, float def) {
        float i = this.traits.getOrDefault(trait, Float.valueOf(def)).floatValue();
        return i == 0.0f ? def : i;
    }

    public float get(Trait trait) {
        return this.getOrDefault(trait, 0.0f);
    }

    public float get(Trait trait, float min, float max) {
        return class_3532.method_15363((float)this.get(trait), (float)min, (float)max);
    }

    @Environment(value=EnvType.CLIENT)
    public void appendTooltip(List<class_2561> tooltip) {
        if (this.isEmpty()) {
            return;
        }
        tooltip.add(1, new ItemTraitsTooltipRenderer(this));
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        this.traits.forEach((? super K key, ? super V value) -> nbt.method_10548(key.getId().toString(), value.floatValue()));
        return nbt;
    }

    public class_1799 applyTo(class_1799 stack) {
        stack = stack.method_7972();
        if (this.isEmpty()) {
            stack.method_57381(UDataComponentTypes.SPELL_TRAITS);
            return stack;
        }
        stack.method_57379(UDataComponentTypes.SPELL_TRAITS, (Object)this);
        return stack;
    }

    public String toString() {
        return "SpellTraits[" + this.traits.entrySet().stream().map((? super T e) -> String.valueOf(e.getKey()) + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(",")) + "]";
    }

    public int hashCode() {
        return this.traits.hashCode();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SpellTraits && Objects.equals(this.traits, ((SpellTraits)other).traits);
    }

    public static SpellTraits union(SpellTraits a, SpellTraits b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        HashMap<Trait, Float> traits = new HashMap<Trait, Float>();
        SpellTraits.combine(traits, a.traits);
        SpellTraits.combine(traits, b.traits);
        return traits.isEmpty() ? EMPTY : new SpellTraits(traits);
    }

    public static SpellTraits union(SpellTraits ... many) {
        HashMap<Trait, Float> traits = new HashMap<Trait, Float>();
        for (SpellTraits i : many) {
            SpellTraits.combine(traits, i.traits);
        }
        return traits.isEmpty() ? EMPTY : new SpellTraits(traits);
    }

    public static SpellTraits of(class_1263 inventory) {
        return SpellTraits.of(InventoryUtil.stream(inventory).toList());
    }

    public static SpellTraits of(Collection<class_1799> stacks) {
        return SpellTraits.fromEntries(stacks.stream().flatMap(a -> SpellTraits.of(a).entries().stream()));
    }

    public static SpellTraits of(class_1799 stack) {
        return SpellTraits.getEmbeddedTraits(stack).orElseGet(() -> SpellTraits.of(stack.method_7909()));
    }

    public static SpellTraits of(class_1792 item) {
        if (item instanceof ItemWithTraits) {
            ItemWithTraits i = (ItemWithTraits)item;
            return i.getDefaultTraits();
        }
        if (item instanceof class_1826) {
            return SPAWN_EGG_TRAITS;
        }
        return REGISTRY.getOrDefault(class_7923.field_41178.method_10221((Object)item), EMPTY);
    }

    public static SpellTraits of(class_2248 block) {
        return SpellTraits.of(block.method_8389());
    }

    public static Stream<class_1792> getItems(Trait trait) {
        return ITEMS.getOrDefault(trait, List.of()).stream();
    }

    public static Optional<SpellTraits> getEmbeddedTraits(class_1799 stack) {
        return Optional.ofNullable((SpellTraits)stack.method_57824(UDataComponentTypes.SPELL_TRAITS));
    }

    public static Optional<SpellTraits> fromNbt(class_2487 traits) {
        return CODEC.decode((DynamicOps)class_2509.field_11560, (Object)traits).result().map(Pair::getFirst);
    }

    public static Codec<SpellTraits> createStringCodec(String delimiter) {
        return Codec.STRING.xmap(traits -> SpellTraits.fromEntries(Arrays.stream(traits.split(delimiter)).map((? super T a) -> a.split(":")).flatMap(pair -> Trait.of(pair[0]).stream().map((? super T key) -> Map.entry(key, Float.valueOf(Float.parseFloat(pair[1])))))), spellTraits -> spellTraits.stream().map((? super T entry) -> ((Trait)entry.getKey()).method_15434() + ":" + String.valueOf(entry.getValue())).collect(Collectors.joining(delimiter)));
    }

    private static SpellTraits fromEntries(Stream<Map.Entry<Trait, Float>> entries) {
        EnumMap result = entries.filter(Objects::nonNull).filter(e -> ((Float)e.getValue()).floatValue() != 0.0f).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> Float.valueOf(a.floatValue() + b.floatValue()), () -> new EnumMap(Trait.class)));
        if (result.isEmpty()) {
            return EMPTY;
        }
        return new SpellTraits(result);
    }

    private static void combine(Map<Trait, Float> to, Map<Trait, Float> from) {
        if (from.isEmpty()) {
            return;
        }
        from.forEach((? super K trait, ? super V value) -> {
            if (value.floatValue() != 0.0f) {
                to.compute((Trait)trait, (k, v) -> Float.valueOf(v == null ? value.floatValue() : v.floatValue() + value.floatValue()));
            }
        });
    }

    public static final class Builder {
        private final Map<Trait, Float> traits = new EnumMap<Trait, Float>(Trait.class);

        public Builder with(Trait trait, float amount) {
            this.traits.put(trait, Float.valueOf(amount));
            return this;
        }

        public SpellTraits build() {
            return SpellTraits.fromEntries(this.traits.entrySet().stream());
        }
    }
}

