/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.trait;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.util.Resources;
import com.minelittlepony.unicopia.util.serialization.CodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class TraitLoader
extends class_4080<Multimap<class_2960, TraitStream>>
implements IdentifiableResourceReloadListener {
    private static final class_2960 ID = Unicopia.id("data/traits");

    public class_2960 getFabricId() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Multimap<class_2960, TraitStream> prepare(class_3300 manager, class_3695 profiler) {
        profiler.method_16065();
        HashMultimap prepared = HashMultimap.create();
        for (class_2960 path : manager.method_14488("traits", p -> p.method_12832().endsWith(".json")).keySet()) {
            profiler.method_15396(path.toString());
            try {
                for (class_3298 resource : manager.method_14489(path)) {
                    profiler.method_15396(resource.method_14480());
                    try (InputStreamReader reader = new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8);){
                        JsonObject data = (JsonObject)class_3518.method_15276((Gson)Resources.GSON, (Reader)reader, JsonObject.class);
                        TraitStream set = (TraitStream)((Pair)TraitStream.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(error -> new JsonParseException(error))).getFirst();
                        if (set.replace()) {
                            prepared.removeAll((Object)path);
                        }
                        prepared.put((Object)path, (Object)set);
                    }
                    catch (JsonParseException e) {
                        Unicopia.LOGGER.error("Error reading traits file " + resource.method_14480() + ":" + String.valueOf(path), (Throwable)e);
                    }
                    finally {
                        profiler.method_15407();
                    }
                }
            }
            catch (IOException e) {
                Unicopia.LOGGER.error("Error reading traits file " + String.valueOf(path), (Throwable)e);
            }
            finally {
                profiler.method_15407();
            }
        }
        profiler.method_16066();
        return prepared;
    }

    protected void apply(Multimap<class_2960, TraitStream> prepared, class_3300 manager, class_3695 profiler) {
        profiler.method_16065();
        Set<Map.Entry<TraitStream.Key, SpellTraits>> newRegistry = prepared.values().stream().flatMap(TraitStream::entries).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, SpellTraits::union)).entrySet();
        SpellTraits.load(class_7923.field_41178.method_29722().stream().map(entry -> Map.entry(((class_5321)entry.getKey()).method_29177(), newRegistry.stream().filter(p -> ((TraitStream.Key)p.getKey()).test((class_1935)entry.getValue())).map(Map.Entry::getValue).reduce(SpellTraits::union).orElse(SpellTraits.EMPTY))).filter(entry -> !((SpellTraits)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        profiler.method_16066();
    }

    static interface TraitStream {
        public static final TypeToken<Map<String, String>> TYPE = new TypeToken<Map<String, String>>(){};
        public static final Codec<TraitStream> CODEC = Codec.xor(TraitMap.CODEC, TraitSet.CODEC).xmap(Either::unwrap, stream -> {
            Either either;
            if (stream instanceof TraitMap) {
                TraitMap l = (TraitMap)stream;
                either = Either.left((Object)l);
            } else {
                either = Either.right((Object)((TraitSet)stream));
            }
            return either;
        });

        public boolean replace();

        public Stream<Map.Entry<Key, SpellTraits>> entries();

        public record TraitMap(boolean replace, Map<Key, SpellTraits> items) implements TraitStream
        {
            static final Codec<TraitMap> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(TraitMap::replace), (App)Codec.unboundedMap(Key.CODEC, SpellTraits.createStringCodec(" ")).fieldOf("items").forGetter(TraitMap::items)).apply((Applicative)i, TraitMap::new));

            @Override
            public Stream<Map.Entry<Key, SpellTraits>> entries() {
                return this.items.entrySet().stream();
            }
        }

        public record TraitSet(boolean replace, SpellTraits traits, Set<Key> items) implements TraitStream
        {
            static final Codec<TraitSet> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(TraitSet::replace), (App)SpellTraits.createStringCodec(" ").fieldOf("traits").forGetter(TraitSet::traits), (App)CodecUtils.setOf(Key.CODEC).fieldOf("items").forGetter(TraitSet::items)).apply((Applicative)i, TraitSet::new));

            @Override
            public Stream<Map.Entry<Key, SpellTraits>> entries() {
                return this.items().stream().map(item -> Map.entry(item, this.traits()));
            }
        }

        public static interface Key
        extends Predicate<class_1935> {
            public static final Codec<Key> CODEC = Codec.xor(Tag.CODEC, Id.CODEC).xmap(Either::unwrap, key -> {
                Either either;
                if (key instanceof Tag) {
                    Tag l = (Tag)key;
                    either = Either.left((Object)l);
                } else {
                    either = Either.right((Object)((Id)key));
                }
                return either;
            });

            public record Tag(class_6862<class_1792> tag) implements Key
            {
                static final Codec<Tag> CODEC = class_6862.method_40093((class_5321)class_7924.field_41197).xmap(Tag::new, Tag::tag);

                @Override
                public boolean test(class_1935 item) {
                    return item.method_8389().method_40131().method_40220(this.tag);
                }
            }

            public record Id(class_5321<class_1792> key) implements Key
            {
                static final Codec<Id> CODEC = class_5321.method_39154((class_5321)class_7924.field_41197).xmap(Id::new, Id::key);

                @Override
                public boolean test(class_1935 item) {
                    return item.method_8389().method_40131().method_40225(this.key);
                }
            }
        }
    }
}

