/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block;

import com.minelittlepony.unicopia.EquineContext;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.block.BlockEntityUtil;
import com.minelittlepony.unicopia.block.UBlockEntities;
import com.minelittlepony.unicopia.item.FriendshipBraceletItem;
import com.minelittlepony.unicopia.item.UItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8177;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class CrystalDoorBlock
extends class_2323
implements class_2343 {
    public static final class_2746 LOCKED = class_2741.field_12502;
    public static final MapCodec<CrystalDoorBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_8177.field_46534.fieldOf("block_set_type").forGetter(class_2323::method_51169), (App)class_2323.method_54096()).apply((Applicative)instance, CrystalDoorBlock::new));

    public CrystalDoorBlock(class_8177 blockSet, class_4970.class_2251 settings) {
        super(blockSet, settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends CrystalDoorBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LOCKED});
    }

    protected boolean method_9542(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)LOCKED);
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9514(state, world, pos, random);
        if (!this.isLocked((class_1937)world, pos)) {
            this.setOnGuard(state, (class_1937)world, pos, false);
        }
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (!((Boolean)state.method_11654((class_2769)LOCKED)).booleanValue()) {
            boolean powered;
            boolean bl = world.method_49803(pos) || world.method_49803(pos.method_10093(state.method_11654((class_2769)field_10946) == class_2756.field_12607 ? class_2350.field_11036 : class_2350.field_11033)) ? true : (powered = false);
            if (!this.method_9564().method_27852(sourceBlock) && powered != (Boolean)state.method_11654((class_2769)field_10940)) {
                if (powered) {
                    state = (class_2680)state.method_28493((class_2769)field_10945);
                    this.playOpenCloseSound(null, world, pos, (Boolean)state.method_11654((class_2769)field_10945));
                    world.method_33596(null, (class_6880)((Boolean)state.method_11654((class_2769)field_10945) != false ? class_5712.field_28168 : class_5712.field_28169), pos);
                }
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)field_10940, (Comparable)Boolean.valueOf(powered)), 2);
            }
        }
        if (state.method_11654((class_2769)field_10946) == class_2756.field_12607 && sourcePos.method_10264() == pos.method_10264() - 1 && !this.method_9558(state, (class_4538)world, pos) && world.method_22347(sourcePos)) {
            world.method_8501(sourcePos, class_2246.field_10566.method_9564());
        }
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!this.shouldProvideAccess(world, pos, player)) {
            if (this.isLocked(world, pos) || !stack.method_31574(UItems.MEADOWBROOKS_STAFF)) {
                this.playOpenCloseSound((class_1297)player, world, pos, false);
                this.setOnGuard(state, world, pos, true);
                return class_9062.field_47729;
            }
            world.method_8396(player, pos, USounds.ENTITY_CRYSTAL_SHARDS_AMBIENT, class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.1f + 0.9f);
        } else if (!this.isLocked(world, pos)) {
            if (stack.method_31574(UItems.FRIENDSHIP_BRACELET)) {
                @Nullable UUID signator = FriendshipBraceletItem.getSignatorId(stack);
                if (signator != null) {
                    BlockEntityUtil.getOrCreateBlockEntity(world, state.method_11654((class_2769)field_10946) == class_2756.field_12607 ? pos.method_10084() : pos, UBlockEntities.CRYSTAL_DOOR).ifPresent(data -> {
                        data.setSignator(signator);
                        this.setOnGuard(state, world, pos, true);
                        world.method_8396(player, pos, USounds.ENTITY_CRYSTAL_SHARDS_AMBIENT, class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.1f + 0.9f);
                    });
                    return class_9062.field_47728;
                }
            } else {
                this.setOnGuard(state, world, pos, false);
            }
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    private void setOnGuard(class_2680 state, class_1937 world, class_2338 pos, boolean locked) {
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(locked)));
        pos = pos.method_10093(state.method_11654((class_2769)field_10946) == class_2756.field_12607 ? class_2350.field_11036 : class_2350.field_11033);
        state = world.method_8320(pos);
        if (state.method_27852((class_2248)this)) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(locked)));
        }
    }

    private boolean shouldProvideAccess(class_1937 world, class_2338 pos, class_1657 player) {
        UUID signator = this.getSignator(world, pos);
        if (signator != null) {
            return signator.equals(player.method_5667()) || FriendshipBraceletItem.isComrade(signator, (class_1297)player);
        }
        return EquineContext.of((class_1297)player).getCompositeRace().any(Race::canCast);
    }

    private boolean isLocked(class_1937 world, class_2338 pos) {
        return this.getSignator(world, pos) != null;
    }

    @Nullable
    private UUID getSignator(class_1937 world, class_2338 pos) {
        pos = world.method_8320(pos).method_11654((class_2769)field_10946) == class_2756.field_12607 ? pos.method_10084() : pos;
        Optional d = world.method_35230(pos, UBlockEntities.CRYSTAL_DOOR);
        return d.map(data -> data.signator).orElse(null);
    }

    private void playOpenCloseSound(@Nullable class_1297 entity, class_1937 world, class_2338 pos, boolean open) {
        world.method_45445(entity, pos, open ? this.method_51169().comp_1292() : this.method_51169().comp_1291(), class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.1f + 0.9f);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileData(pos, state);
    }

    public static class TileData
    extends class_2586 {
        @Nullable
        private UUID signator;

        public TileData(class_2338 pos, class_2680 state) {
            super(UBlockEntities.CRYSTAL_DOOR, pos, state);
        }

        public void setSignator(UUID signator) {
            this.signator = signator;
            this.method_5431();
        }

        public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
            this.signator = nbt.method_25928("signator") ? nbt.method_25926("signator") : null;
        }

        protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
            if (this.signator != null) {
                nbt.method_25927("signator", this.signator);
            }
        }
    }
}

