/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block;

import com.minelittlepony.unicopia.ability.EarthPonyKickAbility;
import com.minelittlepony.unicopia.block.BlockConstructionUtils;
import com.minelittlepony.unicopia.block.FruitBearingBlock;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function5;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FruitBlock
extends class_2248
implements EarthPonyKickAbility.Buckable {
    public static final int DEFAULT_FRUIT_SIZE = 5;
    public static final double DEFAULT_STEM_OFFSET = (double)2.6f;
    public static final class_265 DEFAULT_SHAPE = FruitBlock.createFruitShape(2.6f, 5.0);
    private static final MapCodec<FruitBlock> CODEC = FruitBlock.createCodec(FruitBlock::new);
    protected final class_2350 attachmentFace;
    protected final class_2248 stem;
    protected final class_265 shape;
    @Nullable
    private class_1792 cachedItem;

    public static <T extends FruitBlock> MapCodec<T> createCodec(Function5<class_2350, class_2248, class_265, Boolean, class_4970.class_2251, T> constructor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2350.field_29502.fieldOf("attachment_face").forGetter(b -> b.attachmentFace), (App)class_7923.field_41175.method_39673().fieldOf("stem").forGetter(b -> b.stem), (App)RecordCodecBuilder.create(i -> i.group((App)Codec.DOUBLE.fieldOf("stem_offset").forGetter(b -> 0.0), (App)Codec.DOUBLE.fieldOf("fruit_offset").forGetter(b -> 0.0)).apply((Applicative)i, FruitBlock::createFruitShape)).fieldOf("shape").forGetter(b -> b.shape), (App)Codec.BOOL.fieldOf("flammable").forGetter(b -> false), (App)class_2244.method_54096()).apply((Applicative)instance, constructor));
    }

    public static class_265 createFruitShape(double stemOffset, double fruitSize) {
        double min = (16.0 - fruitSize) * 0.5;
        double max = 16.0 - min;
        double top = 16.0 - stemOffset;
        return FruitBlock.method_9541((double)min, (double)(top - fruitSize), (double)min, (double)max, (double)top, (double)max);
    }

    public MapCodec<? extends FruitBlock> method_53969() {
        return CODEC;
    }

    public FruitBlock(class_2350 attachmentFace, class_2248 stem, class_265 shape, class_4970.class_2251 settings) {
        this(attachmentFace, stem, shape, true, settings.method_9626(class_2498.field_11547).method_50012(class_3619.field_15971));
    }

    public FruitBlock(class_2350 attachmentFace, class_2248 stem, class_265 shape, boolean flammable, class_4970.class_2251 settings) {
        super(settings.method_22488().method_26243(BlockConstructionUtils::never).method_26245(BlockConstructionUtils::never));
        this.attachmentFace = attachmentFace;
        this.stem = stem;
        this.shape = shape;
        if (flammable) {
            FlammableBlockRegistry.getDefaultInstance().add((class_2248)this, 20, 50);
        }
    }

    public class_1792 method_8389() {
        if (this.cachedItem == null) {
            this.cachedItem = (class_1792)class_7923.field_41178.method_10223(class_7923.field_41175.method_10221((Object)this));
        }
        return this.cachedItem;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shape;
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 attachedPos = pos.method_10093(this.attachmentFace.method_10153());
        class_2680 attachedState = world.method_8320(attachedPos);
        return this.canAttachTo(attachedState);
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_26184((class_4538)world, pos)) {
            world.method_22352(pos, true);
        }
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2680 leaves;
        super.method_9536(state, world, pos, newState, moved);
        if (!newState.method_27852(state.method_26204()) && (leaves = world.method_8320(pos.method_10084())).method_28498(FruitBearingBlock.STAGE)) {
            world.method_8501(pos.method_10084(), (class_2680)((class_2680)leaves.method_47968((class_2769)FruitBearingBlock.AGE, (Comparable)Integer.valueOf(0))).method_11657(FruitBearingBlock.STAGE, (Comparable)((Object)FruitBearingBlock.Stage.IDLE)));
        }
    }

    protected boolean canAttachTo(class_2680 state) {
        return state.method_27852(this.stem);
    }

    @Override
    public List<class_1799> onBucked(class_3218 world, class_2680 state, class_2338 pos) {
        List stacks = class_2248.method_9562((class_2680)state, (class_3218)world, (class_2338)pos, null);
        world.method_22352(pos, false);
        return stacks;
    }
}

