/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.block.UBlockEntities;
import com.minelittlepony.unicopia.particle.TargetBoundParticleEffect;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.server.world.WeatherConditions;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class WeatherVaneBlock
extends class_2237 {
    public static final MapCodec<WeatherVaneBlock> CODEC = WeatherVaneBlock.method_54094(WeatherVaneBlock::new);
    private static final class_265 SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)14.0, (double)8.5), (class_265)class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0));

    protected WeatherVaneBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    protected MapCodec<? extends WeatherVaneBlock> method_53969() {
        return CODEC;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WeatherVane(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return WeatherVaneBlock.method_31618(type, UBlockEntities.WEATHER_VANE, (class_5558)(world.field_9236 ? WeatherVane::clientTick : WeatherVane::serverTick));
    }

    public static class WeatherVane
    extends class_2586 {
        private float angle;
        private float clientAngle;
        private float prevAngle;
        private float lastAngle;
        private class_243 airflow = class_243.field_1353;

        public WeatherVane(class_2338 pos, class_2680 state) {
            super(UBlockEntities.WEATHER_VANE, pos, state);
        }

        public float getAngle(float tickDelta) {
            return class_3532.method_16439((float)tickDelta, (float)this.prevAngle, (float)this.clientAngle);
        }

        public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
            this.angle = nbt.method_10583("angle");
            this.airflow = new class_243(nbt.method_10574("windX"), 0.0, nbt.method_10574("windZ"));
        }

        protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
            nbt.method_10548("angle", this.angle);
            nbt.method_10549("windX", this.airflow.field_1352);
            nbt.method_10549("windZ", this.airflow.field_1350);
        }

        public class_2596<class_2602> method_38235() {
            return class_2622.method_38585((class_2586)this);
        }

        public class_2487 method_16887(class_7225.class_7874 lookup) {
            return this.method_38244(lookup);
        }

        public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, WeatherVane entity) {
            class_243 airflow = WeatherConditions.get(world).getWindDirection();
            float angle = WeatherConditions.get(world).getWindYaw() % (float)Math.PI;
            entity.lastAngle = entity.prevAngle;
            entity.prevAngle = entity.angle;
            if (angle != entity.angle) {
                entity.angle = angle;
                entity.airflow = airflow;
                entity.method_5431();
                if (world instanceof class_3218) {
                    class_3218 sw = (class_3218)world;
                    sw.method_14178().method_14128(pos);
                }
                if (entity.lastAngle == entity.prevAngle) {
                    world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), USounds.BLOCK_WEATHER_VANE_ROTATE, class_3419.field_15245, 1.0f, 0.5f + (float)world.field_9229.method_43059());
                }
            }
        }

        public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, WeatherVane entity) {
            entity.prevAngle = entity.clientAngle;
            float angle = entity.angle + (float)Math.sin((float)world.method_8510() / 70.0f) * (float)(world.method_8546() ? 30 : 1);
            float step = (Math.abs(entity.clientAngle) - Math.abs(angle)) / 7.0f;
            if (entity.clientAngle < angle) {
                entity.clientAngle += step;
            } else if (entity.clientAngle > angle) {
                entity.clientAngle -= step;
            }
            if (world.field_9229.method_43048(3) == 0) {
                float radius = 10.0f;
                for (int i = 0; i < 5; ++i) {
                    world.method_8494((class_2394)new TargetBoundParticleEffect(UParticles.WIND, null), world.method_8409().method_43385((double)pos.method_10263(), (double)radius), world.method_8409().method_43385((double)pos.method_10264(), (double)radius), world.method_8409().method_43385((double)pos.method_10260(), (double)radius), entity.airflow.field_1352 / 10.0, 0.0, entity.airflow.field_1350 / 10.0);
                }
            }
        }
    }
}

