/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block.state;

import com.minelittlepony.unicopia.block.state.BlockStateConverter;
import com.minelittlepony.unicopia.block.state.ReversableBlockStateConverterImpl;
import com.minelittlepony.unicopia.block.state.ReversableStateChange;
import com.minelittlepony.unicopia.block.state.StatePredicate;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public interface ReversableBlockStateConverter
extends BlockStateConverter {
    public ReversableBlockStateConverter getInverse();

    public static Builder builder() {
        return new Builder();
    }

    public static Codec<ReversableBlockStateConverter> codec() {
        return ReversableBlockStateConverterImpl.CODEC;
    }

    public static final class Builder {
        private final List<ReversableBlockStateConverterImpl.Entry> entries = new ArrayList<ReversableBlockStateConverterImpl.Entry>();

        private Builder() {
        }

        public Builder add(StatePredicate match, ReversableStateChange stateChange) {
            this.entries.add(new ReversableBlockStateConverterImpl.Entry(match, stateChange, Optional.empty()));
            return this;
        }

        public Builder add(StatePredicate match, ReversableStateChange stateChange, StatePredicate inverseMatch, ReversableStateChange inverseStateChange) {
            this.entries.add(new ReversableBlockStateConverterImpl.Entry(match, stateChange, Optional.of(new ReversableBlockStateConverterImpl.Entry(inverseMatch, inverseStateChange, Optional.empty()))));
            return this;
        }

        public Builder apply(Function<Builder, Builder> function) {
            return function.apply(this);
        }

        public ReversableBlockStateConverter build() {
            return new ReversableBlockStateConverterImpl(this.entries, null);
        }
    }
}

