/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block.state;

import com.google.common.base.Suppliers;
import com.minelittlepony.unicopia.block.state.ReversableBlockStateConverter;
import com.minelittlepony.unicopia.block.state.ReversableStateChange;
import com.minelittlepony.unicopia.block.state.StatePredicate;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReversableBlockStateConverterImpl
implements ReversableBlockStateConverter {
    public static final Codec<ReversableBlockStateConverter> CODEC = Entry.CODEC.listOf().xmap(entries -> new ReversableBlockStateConverterImpl((List<Entry>)entries, null), converter -> ((ReversableBlockStateConverterImpl)converter).entries);
    private final List<Entry> entries;
    private final Supplier<ReversableBlockStateConverter> inverse;

    ReversableBlockStateConverterImpl(List<Entry> entries, @Nullable ReversableBlockStateConverter inverse) {
        this.entries = entries;
        this.inverse = inverse == null ? Suppliers.memoize(() -> new ReversableBlockStateConverterImpl(entries.stream().flatMap(entry -> entry.getInverse().stream()).toList(), this)) : Suppliers.ofInstance((Object)inverse);
    }

    @Override
    public boolean canConvert(@Nullable class_2680 state) {
        return this.entries.stream().anyMatch(entry -> entry.canConvert(state));
    }

    @Override
    public Optional<@NotNull class_2680> getConverted(class_1937 world, @NotNull class_2680 state) {
        return this.entries.stream().filter(entry -> entry.canConvert(state)).findFirst().flatMap(entry -> entry.getConverted(world, state));
    }

    @Override
    public ReversableBlockStateConverter getInverse() {
        return this.inverse.get();
    }

    record Entry(StatePredicate match, ReversableStateChange stateChange, Optional<Entry> inverse) {
        private static final Codec<Entry> INVERSE_CODEC = RecordCodecBuilder.create(i -> i.group((App)StatePredicate.CODEC.fieldOf("match").forGetter(Entry::match), (App)ReversableStateChange.CODEC.fieldOf("apply").forGetter(Entry::stateChange)).apply((Applicative)i, (match, change) -> new Entry((StatePredicate)match, (ReversableStateChange)change, Optional.empty())));
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(i -> i.group((App)StatePredicate.CODEC.fieldOf("match").forGetter(Entry::match), (App)ReversableStateChange.CODEC.fieldOf("apply").forGetter(Entry::stateChange), (App)INVERSE_CODEC.optionalFieldOf("inverse").forGetter(Entry::inverse)).apply((Applicative)i, Entry::new));

        public boolean canConvert(@Nullable class_2680 state) {
            return state != null && this.match.test(state);
        }

        public Optional<@NotNull class_2680> getConverted(class_1937 world, @NotNull class_2680 state) {
            return this.stateChange.getConverted(world, state);
        }

        @Nullable
        public Optional<Entry> getInverse() {
            return this.inverse.or(() -> this.stateChange.getInverse().flatMap(invertedMatch -> invertedMatch.getInverse().map(invertedStateChange -> new Entry((StatePredicate)invertedMatch, (ReversableStateChange)invertedStateChange, Optional.of(this)))));
        }
    }
}

