/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block.state;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.block.state.StatePredicate;
import com.minelittlepony.unicopia.block.state.StateUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public interface ReversableStateChange {
    public static final Codec<ReversableStateChange> CODEC = class_2960.field_25139.dispatch(ReversableStateChange::getType, type -> REGISTRY.get(type));
    public static final Map<class_2960, MapCodec<? extends ReversableStateChange>> REGISTRY = Map.of(Chance.ID, Chance.MAP_CODEC, SetRandomState.ID, SetRandomState.CODEC, SetState.ID, SetState.CODEC, SetProperty.ID, SetProperty.CODEC, CycleProperty.ID, CycleProperty.CODEC);

    public static void bootstrap() {
    }

    public class_2960 getType();

    public Optional<@NotNull class_2680> getConverted(class_1937 var1, @NotNull class_2680 var2);

    default public Optional<StatePredicate> getInverse() {
        return this.getInverse(this);
    }

    default public Optional<StatePredicate> getInverse(ReversableStateChange self) {
        return Optional.empty();
    }

    public record Chance(ReversableStateChange change, float chance) implements ReversableStateChange
    {
        public static final class_2960 ID = Unicopia.id("chance");
        public static final MapCodec<Chance> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)CODEC.fieldOf("change").forGetter(Chance::change), (App)Codec.FLOAT.fieldOf("chance").forGetter(Chance::chance)).apply((Applicative)i, Chance::new));

        @Override
        public Optional<StatePredicate> getInverse(ReversableStateChange self) {
            return this.change.getInverse(self);
        }

        @Override
        public class_2960 getType() {
            return ID;
        }

        @Override
        public Optional<@NotNull class_2680> getConverted(class_1937 world, @NotNull class_2680 state) {
            if (world.field_9229.method_43057() > this.chance) {
                return Optional.empty();
            }
            return this.change.getConverted(world, state);
        }
    }

    public record SetRandomState(StatePredicate.Tag tag) implements ReversableStateChange
    {
        public static final class_2960 ID = Unicopia.id("set_random_state");
        public static final MapCodec<SetRandomState> CODEC = StatePredicate.Tag.MAP_CODEC.xmap(SetRandomState::new, SetRandomState::tag);

        @Override
        public class_2960 getType() {
            return ID;
        }

        @Override
        public Optional<StatePredicate> getInverse(ReversableStateChange self) {
            return Optional.of(new StatePredicate.Tag(this.tag.tag(), Optional.of(self)));
        }

        @Override
        public Optional<@NotNull class_2680> getConverted(class_1937 world, @NotNull class_2680 state) {
            return class_7923.field_41175.method_40260(this.tag.tag()).method_40243(world.field_9229).map(class_6880::comp_349).map(class_2248::method_9564).map(newState -> StateUtil.copyState(state, newState));
        }
    }

    public record SetState(StatePredicate.State state) implements ReversableStateChange
    {
        public static final class_2960 ID = Unicopia.id("set_state");
        public static final MapCodec<SetState> CODEC = StatePredicate.State.MAP_CODEC.xmap(SetState::new, SetState::state);

        @Override
        public class_2960 getType() {
            return ID;
        }

        @Override
        public Optional<StatePredicate> getInverse(ReversableStateChange self) {
            return Optional.of(new StatePredicate.State(this.state.id(), this.state.properties(), Optional.of(self)));
        }

        @Override
        public Optional<@NotNull class_2680> getConverted(class_1937 world, @NotNull class_2680 state) {
            return class_7923.field_41175.method_17966(this.state.id()).map(class_2248::method_9564).map(newState -> this.state.applyTo(world, StateUtil.copyState(state, newState)));
        }
    }

    public record SetProperty(String property, String value) implements ReversableStateChange
    {
        public static final class_2960 ID = Unicopia.id("set_property");
        public static final MapCodec<SetProperty> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.fieldOf("property").forGetter(SetProperty::property), (App)Codec.STRING.fieldOf("value").forGetter(SetProperty::property)).apply((Applicative)i, SetProperty::new));

        @Override
        public class_2960 getType() {
            return ID;
        }

        @Override
        public Optional<@NotNull class_2680> getConverted(class_1937 world, @NotNull class_2680 state) {
            return StatePredicate.getProperty(state, this.property).flatMap(property -> property.method_11900(this.value).map(v -> (class_2680)state.method_11657(property, v)));
        }
    }

    public record CycleProperty(String property) implements ReversableStateChange
    {
        public static final class_2960 ID = Unicopia.id("cycle_property");
        public static final MapCodec<CycleProperty> CODEC = Codec.STRING.fieldOf("property").xmap(CycleProperty::new, CycleProperty::property);

        @Override
        public class_2960 getType() {
            return ID;
        }

        @Override
        public Optional<@NotNull class_2680> getConverted(class_1937 world, @NotNull class_2680 state) {
            return StatePredicate.getProperty(state, this.property).map(property -> (class_2680)state.method_28493(property));
        }
    }
}

