/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block.state;

import com.minelittlepony.unicopia.block.state.ExpandableList;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;

public record Schematic(int dx, int dy, int dz, Entry[] states) {
    public static final Schematic ALTAR = new Builder().fill(0, 0, 0, 8, 0, 8, class_2246.field_10114.method_9564()).fill(3, 1, 3, 5, 1, 5, class_2246.field_10540.method_9564()).set(4, 1, 4, class_2246.field_10114.method_9564()).set(4, 2, 4, class_2246.field_22089.method_9564()).set(4, 1, 6, class_2246.field_23261.method_9564()).fill(0, 1, 2, 0, 4, 2, class_2246.field_10540.method_9564()).fill(0, 1, 6, 0, 4, 6, class_2246.field_10540.method_9564()).fill(2, 1, 0, 2, 4, 0, class_2246.field_10540.method_9564()).fill(6, 1, 0, 6, 4, 0, class_2246.field_10540.method_9564()).fill(8, 1, 2, 8, 4, 2, class_2246.field_10540.method_9564()).fill(8, 1, 6, 8, 4, 6, class_2246.field_10540.method_9564()).fill(2, 1, 8, 2, 4, 8, class_2246.field_10540.method_9564()).fill(6, 1, 8, 6, 4, 8, class_2246.field_10540.method_9564()).build();

    public static Schematic fromPacket(class_2540 buffer) {
        Builder builder = new Builder();
        buffer.method_34068(ArrayList::new, buf -> {
            byte op = buf.readByte();
            return switch (op) {
                case 1 -> builder.set(buf.readInt(), buf.readInt(), buf.readInt(), class_2248.method_9531((int)buf.readInt()));
                case 2 -> builder.fill(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), class_2248.method_9531((int)buf.readInt()));
                default -> builder;
            };
        });
        return builder.build();
    }

    public int volume() {
        return this.states.length;
    }

    public record Entry(int x, int y, int z, class_2680 state) {
    }

    public static final class Builder {
        private static final class_2680 AIR = class_2246.field_10124.method_9564();
        private int dx = -1;
        private int dy = -1;
        private int dz = -1;
        private final ExpandableList<ExpandableList<ExpandableList<class_2680>>> layers = new ExpandableList<ExpandableList>(0, () -> new ExpandableList<ExpandableList>(this.dz, () -> new ExpandableList<class_2680>(this.dx, () -> AIR)));

        public Builder set(int x, int y, int z, class_2680 state) {
            this.dx = Math.max(this.dx, x);
            this.dy = Math.max(this.dy, y);
            this.dz = Math.max(this.dz, z);
            this.layers.getOrExpand(y).getOrExpand(z).set(x, state);
            return this;
        }

        public Builder fill(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 state) {
            this.dx = Math.max(this.dx, maxX);
            this.dy = Math.max(this.dy, maxY);
            this.dz = Math.max(this.dz, maxZ);
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        this.set(x, y, z, state);
                    }
                }
            }
            return this;
        }

        public Schematic build() {
            LinkedList<Entry> states = new LinkedList<Entry>();
            for (int y = 0; y <= this.dy && y < this.layers.size(); ++y) {
                for (int z = 0; z <= this.dz && z < this.layers.get(y).size(); ++z) {
                    for (int x = 0; x <= this.dx && x < this.layers.get(y).get(z).size(); ++x) {
                        class_2680 state = this.layers.get(y).get(z).get(x);
                        if (state.method_26215()) continue;
                        states.add(new Entry(x, y, z, state));
                    }
                }
            }
            return new Schematic(this.dx, this.dy, this.dz, (Entry[])states.toArray(Entry[]::new));
        }
    }
}

