/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.SortedSet;
import net.minecraft.class_2338;
import net.minecraft.class_3191;

public class ClientBlockDestructionManager {
    private final Long2ObjectMap<Destruction> destructions = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<SortedSet<class_3191>> combined = new Long2ObjectOpenHashMap();
    private final Object locker = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockDestruction(long pos, float amount) {
        Object object = this.locker;
        synchronized (object) {
            if (amount <= 0.0f || amount > 10.0f) {
                this.destructions.remove(pos);
            } else {
                ((Destruction)this.destructions.computeIfAbsent(pos, p -> new Destruction(this, pos))).set(amount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(Long2ObjectMap<SortedSet<class_3191>> vanilla) {
        Object object = this.locker;
        synchronized (object) {
            this.destructions.long2ObjectEntrySet().removeIf(entry -> ((Destruction)entry.getValue()).tick());
            this.combined.clear();
            if (!this.destructions.isEmpty()) {
                this.destructions.forEach((pos, value) -> ((SortedSet)this.combined.computeIfAbsent(pos.longValue(), p -> Sets.newTreeSet())).add(value.info));
                vanilla.forEach((pos, value) -> ((SortedSet)this.combined.computeIfAbsent(pos.longValue(), p -> Sets.newTreeSet())).addAll(value));
            }
        }
    }

    public Long2ObjectMap<SortedSet<class_3191>> getCombinedDestructions(Long2ObjectMap<SortedSet<class_3191>> vanilla) {
        return this.destructions.isEmpty() ? vanilla : this.combined;
    }

    private class Destruction {
        int age = 50;
        class_3191 info;

        Destruction(ClientBlockDestructionManager clientBlockDestructionManager, long pos) {
            this.info = new class_3191(0, class_2338.method_10092((long)pos));
        }

        boolean tick() {
            if (this.age-- > 0) {
                return false;
            }
            int amount = this.info.method_13988();
            if (amount >= 0) {
                this.set(--amount);
            }
            return amount < 0 || this.age-- <= 0;
        }

        void set(float amount) {
            this.age = 50;
            this.info.method_13987(amount >= 0.0f && amount < 10.0f ? (int)amount : -1);
        }
    }

    public static interface Source {
        public ClientBlockDestructionManager getDestructionManager();

        public int getTicks();
    }
}

