/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.FlightType;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.client.gui.DismissSpellScreen;
import com.minelittlepony.unicopia.client.gui.UHud;
import com.minelittlepony.unicopia.client.gui.spellbook.ClientChapters;
import com.minelittlepony.unicopia.client.particle.ClientBoundParticleSpawner;
import com.minelittlepony.unicopia.client.sound.FadeOutSoundInstance;
import com.minelittlepony.unicopia.client.sound.LoopedEntityTrackingSoundInstance;
import com.minelittlepony.unicopia.client.sound.LoopingSoundInstance;
import com.minelittlepony.unicopia.client.sound.MagicAuraSoundInstance;
import com.minelittlepony.unicopia.client.sound.MotionBasedSoundInstance;
import com.minelittlepony.unicopia.client.sound.NonLoopingFadeOutSoundInstance;
import com.minelittlepony.unicopia.container.spellbook.SpellbookChapter;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.mob.LevitatingItemEntity;
import com.minelittlepony.unicopia.entity.player.PlayerPhysics;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.entity.player.dummy.DummyClientPlayerEntity;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgPlayerTargetEntity;
import com.minelittlepony.unicopia.particle.ParticleSpawner;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1108;
import net.minecraft.class_1117;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_4466;
import net.minecraft.class_4508;
import net.minecraft.class_4509;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientInteractionManager
extends InteractionManager {
    private final class_310 client = class_310.method_1551();
    private final Int2ObjectMap<WeakReference<class_1117>> playingSounds = new Int2ObjectOpenHashMap();
    private final Map<UUID, Int2ObjectMap<WeakReference<class_1117>>> entitySounds = new HashMap<UUID, Int2ObjectMap<WeakReference<class_1117>>>();

    @Override
    public SpellbookChapter readChapter(class_2540 buffer) {
        return ClientChapters.loadChapter(buffer);
    }

    @Override
    public void playLoopingSound(final class_1297 source, int type, long seed) {
        this.client.execute(() -> {
            class_1657 player;
            if (type == 0 && source instanceof class_1309) {
                class_1309 living = (class_1309)source;
                this.play(type, () -> new LoopingSoundInstance<class_1309>(living, ClientInteractionManager.createTicker(100).and(e -> !e.method_31481()), USounds.ENTITY_PLAYER_EARS_RINGING, 0.01f, 2.0f, class_5819.method_43049((long)seed)).setFadeIn());
            } else if (type == 2 && source instanceof class_4466) {
                class_4466 bee = (class_4466)source;
                this.play(type, () -> bee.method_29511() ? new class_4508(bee) : new class_4509(bee));
            } else if (type == 3 && source instanceof class_1688) {
                class_1688 minecart = (class_1688)source;
                this.play(type, () -> new class_1108(minecart));
            } else if (type == 1 && source instanceof class_1657) {
                class_1657 player2 = (class_1657)source;
                this.play(type, () -> new MotionBasedSoundInstance<class_1657>(USounds.ENTITY_PLAYER_CHANGELING_BUZZ, player2, e -> {
                    PlayerPhysics physics = Pony.of(e).getPhysics();
                    return physics.isFlying() && physics.getFlightType() == FlightType.INSECTOID;
                }, 0.25f, 0.5f, 0.66f, class_5819.method_43049((long)seed)));
            } else if (type == 4 && source instanceof class_1657 && this.isClientPlayer(player = (class_1657)source)) {
                this.play(type, () -> new MotionBasedSoundInstance<class_1657>(USounds.Vanilla.field_14572, player, e -> {
                    Pony pony = Pony.of(e);
                    return pony.getPhysics().isFlying() && pony.getPhysics().getFlightType().isAvian();
                }, 0.0f, 1.0f, 1.0f, class_5819.method_43049((long)seed)));
            } else if (type == 4 && source instanceof class_1657) {
                class_1657 player3 = (class_1657)source;
                this.play(type, () -> new MotionBasedSoundInstance<class_1657>(USounds.ENTITY_PLAYER_PEGASUS_FLYING, player3, e -> {
                    Pony pony = Pony.of(e);
                    return pony.getPhysics().isFlying() && pony.getPhysics().getFlightType().isAvian();
                }, 0.0f, 1.0f, 1.0f, class_5819.method_43049((long)seed)));
            } else if (type == 5) {
                this.play(type, () -> new LoopedEntityTrackingSoundInstance(USounds.SPELL_CAST_SHOOT, 0.3f, 1.0f, source, seed));
            } else if (type == 6) {
                this.play(type, () -> new NonLoopingFadeOutSoundInstance(USounds.ENTITY_PLAYER_HEARTBEAT_LOOP, class_3419.field_15248, 0.3f, class_5819.method_43049((long)seed), 80L));
            } else if (type == 7) {
                this.play(type, () -> new FadeOutSoundInstance(this, USounds.ENTITY_PLAYER_KIRIN_RAGE_LOOP, class_3419.field_15256, 0.3f, class_5819.method_43049((long)seed)){

                    @Override
                    protected boolean shouldKeepPlaying() {
                        return EquinePredicates.RAGING.test(source);
                    }
                });
            } else if (type == 8) {
                this.play(source.method_5667(), type, () -> new MagicAuraSoundInstance(source.method_5634(), Living.living(source), source.method_37908().method_8409()));
            }
        });
    }

    private void play(UUID sourceId, int type, Supplier<class_1117> soundSupplier) {
        this.play((Int2ObjectMap<WeakReference<class_1117>>)this.entitySounds.computeIfAbsent(sourceId, id -> new Int2ObjectOpenHashMap()), type, soundSupplier);
    }

    private void play(int type, Supplier<class_1117> soundSupplier) {
        this.play(this.playingSounds, type, soundSupplier);
    }

    private void play(Int2ObjectMap<WeakReference<class_1117>> playingSounds, int type, Supplier<class_1117> soundSupplier) {
        class_1117 existing;
        WeakReference activeSound = (WeakReference)playingSounds.get(type);
        if (activeSound == null || (existing = (class_1117)activeSound.get()) == null || existing.method_4793()) {
            existing = soundSupplier.get();
            playingSounds.put(type, new WeakReference<class_1117>(existing));
            this.playNow(existing);
        }
    }

    private void playNow(class_1117 sound) {
        this.client.method_1483().method_22140(sound);
    }

    static Predicate<class_1309> createTicker(int ticks) {
        int[] ticker = new int[]{ticks};
        return entity -> {
            int n = ticker[0];
            ticker[0] = n - 1;
            return n > 0;
        };
    }

    @Override
    public void openScreen(int type) {
        this.client.execute(() -> {
            if (type == 0) {
                this.client.method_1507((class_437)new DismissSpellScreen());
            }
        });
    }

    @Override
    @NotNull
    public class_1657 createPlayer(class_1937 world, GameProfile profile) {
        if (world instanceof class_638) {
            class_638 cw = (class_638)world;
            return new DummyClientPlayerEntity(cw, profile);
        }
        return super.createPlayer(world, profile);
    }

    @Override
    public boolean isClientPlayer(@Nullable class_1657 player) {
        return this.client.field_1724 != null && player != null && (this.client.field_1724 == player || Pony.equal((class_1657)this.client.field_1724, player));
    }

    @Override
    public int getViewMode() {
        return this.client.field_1690.method_31044().ordinal();
    }

    @Override
    public float getTickRate() {
        return this.client.field_1687 == null ? 20.0f : this.client.field_1687.method_54719().method_54748();
    }

    @Override
    public void interactLevitatingItem(LevitatingItemEntity entity, class_1657 player) {
        if (!entity.method_37908().field_9236) {
            super.interactLevitatingItem(entity, player);
        } else if (player == this.client.field_1724 && entity == UHud.INSTANCE.levitatingItemActions.targetEntity && UHud.INSTANCE.levitatingItemActions.currentAction != null && UHud.INSTANCE.levitatingItemActions.currentAction != LevitatingItemEntity.Action.MOVE) {
            Channel.CLIENT_PLAYER_LOOK_AT_ENTITY.sendToServer((Object)new MsgPlayerTargetEntity(Optional.of(entity.method_5628()), Optional.of(UHud.INSTANCE.levitatingItemActions.currentAction), Optional.empty()));
        }
    }

    @Override
    public ParticleSpawner createBoundParticle(UUID id) {
        return new ClientBoundParticleSpawner(id);
    }

    @Override
    public void sendPlayerLookAngles(class_1657 player) {
        if (player instanceof class_746) {
            class_746 c = (class_746)player;
            c.field_3944.method_52787((class_2596)new class_2828.class_2831(player.method_36454(), player.method_36455(), player.method_24828()));
        }
    }

    @Override
    public void addBlockBreakingParticles(class_2338 pos, class_2350 direction) {
        this.client.field_1713.method_3054(pos, direction);
    }

    @Override
    public Optional<Pony> getClientPony() {
        return Optional.ofNullable(this.client.field_1724).map(Pony::of);
    }
}

