/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public interface GradientUtil {
    public static void fillVerticalGradient(class_4587 matrices, int startX, int startY, int stopY, int endX, int endY, int colorStart, int colorStop, int colorEnd, int z) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        GradientUtil.fillVerticalGradient(matrices.method_23760().method_23761(), class_289.method_1348(), startX, startY, stopY, endX, endY, z, colorStart, colorStop, colorEnd);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void fillVerticalGradient(Matrix4f matrix, class_289 tessellator, int startX, int startY, int stopY, int endX, int endY, int z, int colorStart, int colorStop, int colorEnd) {
        float fromA = (float)(colorStart >> 24 & 0xFF) / 255.0f;
        float fromR = (float)(colorStart >> 16 & 0xFF) / 255.0f;
        float fromG = (float)(colorStart >> 8 & 0xFF) / 255.0f;
        float fromB = (float)(colorStart & 0xFF) / 255.0f;
        float stopA = (float)(colorStop >> 24 & 0xFF) / 255.0f;
        float stopR = (float)(colorStop >> 16 & 0xFF) / 255.0f;
        float stopG = (float)(colorStop >> 8 & 0xFF) / 255.0f;
        float stopB = (float)(colorStop & 0xFF) / 255.0f;
        float toA = (float)(colorEnd >> 24 & 0xFF) / 255.0f;
        float toR = (float)(colorEnd >> 16 & 0xFF) / 255.0f;
        float toG = (float)(colorEnd >> 8 & 0xFF) / 255.0f;
        float toB = (float)(colorEnd & 0xFF) / 255.0f;
        class_287 builder = tessellator.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        builder.method_22918(matrix, (float)endX, (float)stopY, (float)z).method_22915(stopR, stopG, stopB, stopA);
        builder.method_22918(matrix, (float)endX, (float)startY, (float)z).method_22915(fromR, fromG, fromB, fromA);
        builder.method_22918(matrix, (float)startX, (float)startY, (float)z).method_22915(fromR, fromG, fromB, fromA);
        builder.method_22918(matrix, (float)startX, (float)stopY, (float)z).method_22915(stopR, stopG, stopB, stopA);
        builder.method_22918(matrix, (float)startX, (float)endY, (float)z).method_22915(toR, toG, toB, toA);
        builder.method_22918(matrix, (float)endX, (float)endY, (float)z).method_22915(stopR, toG, toB, toA);
        class_286.method_43433((class_9801)builder.method_60800());
    }

    public static void fillRadialGradient(class_4587 matrices, int startX, int startY, int endX, int endY, int colorStart, int colorEnd, int z, float radius) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        GradientUtil.fillRadials(matrices.method_23760().method_23761(), class_289.method_1348(), startX, startY, endX, endY, z, colorStart, colorEnd, radius);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void fillRadials(Matrix4f matrix, class_289 tessellator, int startX, int startY, int endX, int endY, int z, int colorStart, int colorEnd, float radius) {
        float fromA = (float)(colorStart >> 24 & 0xFF) / 255.0f;
        float fromR = (float)(colorStart >> 16 & 0xFF) / 255.0f;
        float fromG = (float)(colorStart >> 8 & 0xFF) / 255.0f;
        float fromB = (float)(colorStart & 0xFF) / 255.0f;
        float toA = (float)(colorEnd >> 24 & 0xFF) / 255.0f;
        float toR = (float)(colorEnd >> 16 & 0xFF) / 255.0f;
        float toG = (float)(colorEnd >> 8 & 0xFF) / 255.0f;
        float toB = (float)(colorEnd & 0xFF) / 255.0f;
        double increment = 0.20943951023931953;
        float width = endX - startX;
        float height = endY - startY;
        float outerRadius = class_3532.method_15355((float)(width * width + height * height)) / 2.0f;
        float innerRadius = outerRadius * (1.0f - radius);
        class_287 builder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (double angle = 0.0; angle < Math.PI * 2; angle += increment) {
            GradientUtil.clampedVertex(builder, matrix, innerRadius, angle + increment, z, startX, endX, startY, endY).method_22915(toR, toG, toB, toA);
            GradientUtil.clampedVertex(builder, matrix, innerRadius, angle, z, startX, endX, startY, endY).method_22915(toR, toG, toB, toA);
            GradientUtil.clampedVertex(builder, matrix, outerRadius, angle, z, startX, endX, startY, endY).method_22915(fromR, fromG, fromB, fromA);
            GradientUtil.clampedVertex(builder, matrix, outerRadius, angle + increment, z, startX, endX, startY, endY).method_22915(fromR, fromG, fromB, fromA);
        }
        class_286.method_43433((class_9801)builder.method_60800());
    }

    public static float getX(double radius, double angle) {
        return (float)(radius * (double)class_3532.method_15374((float)((float)angle)));
    }

    public static float getY(double radius, double angle) {
        return (float)(radius * (double)class_3532.method_15362((float)((float)angle)));
    }

    private static class_4588 clampedVertex(class_287 bufferBuilder, Matrix4f model, double radius, double angle, float z, int minX, int maxX, int minY, int maxY) {
        float midX = (float)(maxX - minX) / 2.0f;
        float midY = (float)(maxY - minY) / 2.0f;
        float x = midX + GradientUtil.getX(radius, angle);
        float y = midY + GradientUtil.getY(radius, angle);
        float xPad = (float)(maxX - minX) / 10.0f;
        float yPad = (float)(maxY - minY) / 20.0f;
        if (x < (float)minX + xPad) {
            x = minX;
        }
        if (x > (float)maxX - xPad) {
            x = maxX;
        }
        if (y < (float)minY + yPad) {
            y = minY;
        }
        if (y > (float)maxY - yPad) {
            y = maxY;
        }
        return bufferBuilder.method_22918(model, x, y, z);
    }
}

