/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.player.Pony;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5224;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7417;

public class ItemTraitsTooltipRenderer
implements class_2561,
class_5481,
class_5684 {
    private static final class_2960 UNKNOWN = Unicopia.id("textures/gui/trait/unknown.png");
    private final SpellTraits traits;

    public ItemTraitsTooltipRenderer(SpellTraits traits) {
        this.traits = traits;
    }

    public int method_32661() {
        return this.getRows() * 17 + 2;
    }

    public int method_32664(class_327 textRenderer) {
        return this.getColumns() * 17 + 2;
    }

    private int getColumns() {
        return Math.min(this.traits.entries().size(), Math.max(6, (int)Math.ceil(Math.sqrt(this.traits.entries().size() + 1))));
    }

    private int getRows() {
        int columns = this.getColumns();
        if (columns == this.traits.entries().size()) {
            return 1;
        }
        return Math.max(1, (int)Math.ceil((float)(this.traits.entries().size() + 1) / (float)this.getColumns()));
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        int columns = this.getColumns();
        int i = 0;
        for (Map.Entry<Trait, Float> entry : this.traits) {
            ItemTraitsTooltipRenderer.renderTraitIcon(entry.getKey(), entry.getValue().floatValue(), context, x + i % columns * 17, y + i / columns * 17);
            ++i;
        }
    }

    public boolean accept(class_5224 visitor) {
        return false;
    }

    public class_5481 method_30937() {
        return this;
    }

    public class_5250 method_27661() {
        return class_2561.method_43473();
    }

    public static void renderStackTraits(class_1799 stack, class_332 context, float x, float y, float weight, float delta, int seed) {
        ItemTraitsTooltipRenderer.renderStackTraits(SpellTraits.of(stack), context, x, y, weight, delta, seed, false);
    }

    public static void renderStackTraits(SpellTraits traits, class_332 context, float x, float y, float weight, float delta, int seed, boolean revealAll) {
        float time = class_3532.method_15362((float)(((float)class_310.method_1551().field_1724.field_6012 + delta + (float)seed) / 2.0f)) * 0.7f;
        float angle = 0.7f + time / 30.0f % ((float)Math.PI * 2);
        float angleIncrement = (float)Math.PI * 2 / (float)traits.entries().size();
        float r = 9.0f + 2.0f * class_3532.method_15374((float)(delta / 20.0f));
        for (Map.Entry<Trait, Float> entry : traits) {
            if (!revealAll && !ItemTraitsTooltipRenderer.isKnown(entry.getKey())) continue;
            ItemTraitsTooltipRenderer.renderTraitIcon(entry.getKey(), entry.getValue().floatValue() * weight, context, x + r * class_3532.method_15374((float)angle), y + r * class_3532.method_15362((float)angle), revealAll || ItemTraitsTooltipRenderer.isKnown(entry.getKey()));
            angle += angleIncrement;
        }
    }

    public static void renderStackSingleTrait(Trait trait, float amount, class_332 context, float x, float y, float weight, float delta, int seed, boolean revealAll) {
        float time = class_3532.method_15362((float)(((float)class_310.method_1551().field_1724.field_6012 + delta + (float)seed) / 2.0f)) * 0.7f;
        float angle = 0.7f + time / 30.0f % ((float)Math.PI * 2);
        float r = 9.0f + 2.0f * class_3532.method_15374((float)(delta / 20.0f));
        ItemTraitsTooltipRenderer.renderTraitIcon(trait, amount * weight, context, x + r * class_3532.method_15374((float)angle), y + r * class_3532.method_15362((float)angle), revealAll || ItemTraitsTooltipRenderer.isKnown(trait));
    }

    public static boolean isKnown(Trait trait) {
        return class_310.method_1551().field_1724 == null || Pony.of((class_1657)class_310.method_1551().field_1724).getDiscoveries().isKnown(trait);
    }

    public static void renderTraitIcon(Trait trait, float value, class_332 context, float xx, float yy) {
        ItemTraitsTooltipRenderer.renderTraitIcon(trait, value, context, xx, yy, ItemTraitsTooltipRenderer.isKnown(trait));
    }

    public static void renderTraitIcon(Trait trait, float value, class_332 context, float xx, float yy, boolean reveal) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int size = 12;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(xx, yy, 300.0f);
        context.method_25291(reveal ? trait.getSprite() : UNKNOWN, 2, 1, 0, 0.0f, 0.0f, size, size, size, size);
        matrices.method_46416(9.0f, (float)(3 + size / 2), 0.0f);
        matrices.method_22905(0.5f, 0.5f, 1.0f);
        String count = value > 99.0f ? "99+" : ((float)Math.round(value) == value ? "" + (int)value : "" + (float)Math.round(value * 10.0f) / 10.0f);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23001();
        textRenderer.method_27521(count, 0.0f, 0.0f, 0xFFFFFF, true, matrices.method_23760().method_23761(), (class_4597)immediate, class_327.class_6415.field_33994, 0, 0xF000F0);
        immediate.method_22993();
        matrices.method_22909();
    }

    public class_2583 method_10866() {
        return class_2561.method_43473().method_10866();
    }

    public class_7417 method_10851() {
        return class_2561.method_43473().method_10851();
    }

    public List<class_2561> method_10855() {
        return new ArrayList<class_2561>();
    }
}

