/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.AbilityDispatcher;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.client.gui.DrawableUtil;
import com.minelittlepony.unicopia.client.gui.Slot;
import com.minelittlepony.unicopia.client.gui.UHud;
import com.minelittlepony.unicopia.entity.player.MagicReserves;
import com.minelittlepony.unicopia.entity.player.Pony;
import net.minecraft.class_1657;
import net.minecraft.class_332;
import net.minecraft.class_4587;

class ManaRingSlot
extends Slot {
    public ManaRingSlot(UHud uHud, AbilitySlot normalSlot, AbilitySlot backupSlot, int x, int y) {
        super(uHud, normalSlot, backupSlot, x, y, 8, 49, 33, 43, 30);
        this.background(0, 5);
        this.foreground(0, 59);
    }

    @Override
    protected void renderContents(class_332 context, AbilityDispatcher abilities, boolean bSwap, float tickDelta) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22904(24.125, 24.75, 0.0);
        Pony pony = Pony.of((class_1657)this.uHud.client.field_1724);
        MagicReserves mana = pony.getMagicalReserves();
        boolean canUseSuper = Abilities.RAGE.canUse(pony.getCompositeRace()) || Abilities.RAINBOOM.canUse(pony.getCompositeRace());
        double maxManaBarSize = canUseSuper ? Math.PI : Math.PI * 2;
        double arcBegin = this.renderRing(matrices, 17.0, 13.0, 0.0, maxManaBarSize, mana.getMana(), -7798887, tickDelta);
        this.renderRing(matrices, 17.0, 13.0, 0.0, maxManaBarSize, mana.getExhaustion(), -16768359, tickDelta);
        if (!this.uHud.client.field_1724.method_7337()) {
            double cost;
            int level = pony.getLevel().get();
            int seconds = level % 16;
            int minutes = level / 16 % 16;
            int hours = level / 32;
            DrawableUtil.drawNotchedArc(matrices, 10.0, 13.0, 0.0, (double)hours * 0.2, 0.1, 0.1, 0xAA88FF);
            DrawableUtil.drawNotchedArc(matrices, 10.0, 13.0, (double)hours * 0.2, (double)minutes * 0.2, 0.1, 0.1, 0x8888AA);
            DrawableUtil.drawNotchedArc(matrices, 10.0, 13.0, (double)(hours + minutes) * 0.2, (double)seconds * 0.2, 0.1, 0.1, -2004352871);
            level = pony.getCorruption().get();
            seconds = level % 16;
            minutes = level / 16 % 16;
            hours = level / 32;
            DrawableUtil.drawNotchedArc(matrices, 7.0, 10.0, Math.PI, (double)hours * 0.2, 0.1, 0.1, 35071);
            DrawableUtil.drawNotchedArc(matrices, 7.0, 10.0, (double)hours * 0.2 + Math.PI, (double)minutes * 0.2, 0.1, 0.1, 34986);
            DrawableUtil.drawNotchedArc(matrices, 7.0, 10.0, (double)(hours + minutes) * 0.2 + Math.PI, (double)seconds * 0.2, 0.1, 0.1, 34969);
            if (canUseSuper) {
                this.renderRing(matrices, 17.0, 13.0, Math.min(arcBegin, Math.PI), Math.max(Math.PI, Math.PI * 2 - arcBegin), mana.getCharge(), -1996514919, tickDelta);
            }
            if ((cost = abilities.getStats().stream().mapToDouble(s -> s.getCost(((Integer)Unicopia.getConfig().hudPage.get()).intValue())).reduce(Double::sum).getAsDouble()) > 0.0) {
                float percent = mana.getMana().getPercentFill();
                float max = mana.getMana().getMax();
                cost *= 10.0;
                int color = (cost /= (double)(1.0f + pony.getLevel().getScaled(3.0f))) / (double)max > (double)percent ? -16777063 : -65383;
                cost = Math.min((double)percent, Math.min((double)max, cost) / (double)max);
                double angle = cost * Math.PI * 2.0;
                DrawableUtil.drawArc(matrices, 13.0, 17.0, arcBegin - angle, angle, color);
            }
        }
        matrices.method_22909();
        super.renderContents(context, abilities, bSwap, tickDelta);
    }

    private double renderRing(class_4587 matrices, double outerRadius, double innerRadius, double offsetAngle, double maxAngle, MagicReserves.Bar bar, int color, float tickDelta) {
        double fill = (double)bar.getPercentFill(tickDelta) * maxAngle;
        double shadow = (double)bar.getShadowFill(tickDelta) * maxAngle;
        DrawableUtil.drawArc(matrices, innerRadius, outerRadius, offsetAngle, fill, color);
        if (shadow > fill) {
            color = color & 0xFFFFFF00 | (color & 0xFF) / 2;
            DrawableUtil.drawArc(matrices, innerRadius, outerRadius, offsetAngle + fill, shadow - fill, color);
        }
        return offsetAngle + fill;
    }
}

