/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.element.Label;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.client.gui.HidesHud;
import com.minelittlepony.unicopia.client.gui.TextBlock;
import com.minelittlepony.unicopia.client.gui.TribeButton;
import com.minelittlepony.unicopia.client.gui.TribeConfirmationScreen;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgRequestSpeciesChange;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_8021;
import net.minecraft.class_8030;

public class TribeSelectionScreen
extends GameGui
implements HidesHud {
    static final class_2960 TEXTURE = Unicopia.id("textures/gui/tribe_selection.png");
    final Set<Race> allowedRaces;
    final class_2561 journeyText;
    final class_2561 choiceText;
    private boolean finished;
    private final List<TribeButton> options = new ArrayList<TribeButton>();
    private static int SELECTION = -1;
    private int prevScrollPosition;
    private int scrollPosition;
    private int targetScroll;

    public TribeSelectionScreen(Set<Race> allowedRaces, String baseString) {
        super((class_2561)class_2561.method_43471((String)baseString));
        this.allowedRaces = allowedRaces;
        this.journeyText = class_2561.method_43471((String)(baseString + ".journey"));
        this.choiceText = class_2561.method_43471((String)(baseString + ".choice"));
    }

    protected void method_25426() {
        int pageWidth = 300;
        int left = (this.field_22789 - 300) / 2;
        int top = 0;
        ((Label)this.method_37060((class_4068)new Label(this.field_22789 / 2, top += 20).setCentered())).getStyle().setText((class_2561)this.method_25440().method_27661().method_27692(class_124.field_1054));
        top += this.field_22790 / 8;
        TextBlock block = (TextBlock)this.method_37060((class_4068)new TextBlock(left, top += 10, 300));
        block.getStyle().setText(this.journeyText);
        top += block.getBounds().height;
        block = (TextBlock)this.method_37060((class_4068)new TextBlock(left, top += 7, 300));
        block.getStyle().setText(this.choiceText);
        top += block.getBounds().height;
        top += 30;
        List<Race> options = Race.REGISTRY.method_10220().filter(race -> race.availability().isSelectable()).toList();
        this.options.clear();
        for (Race race2 : options) {
            if (race2.isHuman()) {
                Race r = race2;
                int n = this.field_22789 / 2;
                Objects.requireNonNull(this.getFont());
                ((Label)this.addButton((class_364)new Link(n, this.field_22790 - 9 - 10).setCentered())).onClick(s -> this.selectRace(r)).getStyle().setText("[Or Play as None of these]");
                continue;
            }
            this.addOption(race2, top);
        }
        this.scroll(SELECTION == -1 ? options.size() / 2 : SELECTION, false);
    }

    private void addOption(Race race, int y) {
        TribeButton option = new TribeButton(0, y, this.field_22789, race);
        int index = this.options.size();
        this.options.add((TribeButton)this.method_37063((class_364)option));
        option.onClick(b -> {
            this.scroll(index, false);
            this.selectRace(race);
        }).setEnabled(this.allowedRaces.contains(race));
    }

    private void selectRace(Race race) {
        this.finished = true;
        this.field_22787.method_1507((class_437)new TribeConfirmationScreen(result -> {
            this.finished = false;
            if (result) {
                Channel.CLIENT_REQUEST_SPECIES_CHANGE.sendToServer((Object)new MsgRequestSpeciesChange(true, race));
                this.finish();
            } else {
                this.field_22787.method_1507((class_437)this);
            }
        }, race));
    }

    public void method_25393() {
        this.prevScrollPosition = this.scrollPosition;
        if (this.scrollPosition < this.targetScroll) {
            ++this.scrollPosition;
        }
        if (this.scrollPosition > this.targetScroll) {
            --this.scrollPosition;
        }
    }

    private void updateScolling() {
        int itemWidth = 80;
        int x = (this.field_22789 - 80) / 2;
        float diff = (float)class_3532.method_48781((float)this.field_22787.method_60646().method_60637(false), (int)this.prevScrollPosition, (int)this.scrollPosition) / 4.0f;
        for (int i = 0; i < this.options.size(); ++i) {
            TribeButton option = this.options.get(i);
            option.method_46421((int)((float)x + ((float)i - diff) * 80.0f));
            option.method_25365(i == SELECTION);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.updateScolling();
        super.method_25394(context, mouseX, mouseY, delta);
        if (!this.options.isEmpty()) {
            TribeButton element = this.options.get(0);
            float diff = (this.targetScroll - class_3532.method_48781((float)this.field_22787.method_60646().method_60637(false), (int)this.prevScrollPosition, (int)this.scrollPosition)) * 7;
            context.method_25291(TEXTURE, this.field_22789 / 2 + 40 + (this.scrollPosition < this.targetScroll ? (int)diff : 0), element.method_46427() - 20, 10, 165.0f, 153.0f, 30, 85, 312, 312);
            context.method_25291(TEXTURE, this.field_22789 / 2 - 80 + (this.scrollPosition > this.targetScroll ? (int)diff : 0), element.method_46427() - 20, 10, 195.0f, 153.0f, 30, 85, 312, 312);
            if (element.getBounds().left < 0) {
                context.method_25291(TEXTURE, 20, element.method_46427() - 10, 10, 188.0f, 235.0f, 24, 60, 312, 312);
            }
            if ((element = this.options.get(this.options.size() - 1)).getBounds().right() > this.field_22789) {
                context.method_25291(TEXTURE, this.field_22789 - 50, element.method_46427() - 10, 10, 164.0f, 235.0f, 24, 60, 312, 312);
            }
        }
    }

    public void finish() {
        this.finished = true;
        this.method_25419();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.scroll(Math.max(SELECTION - 1, 0), true);
            return true;
        }
        if (keyCode == 262) {
            this.scroll(Math.min(SELECTION + 1, this.options.size() - 1), true);
            return true;
        }
        if (keyCode == 257 && this.options.get((int)TribeSelectionScreen.SELECTION).field_22763) {
            this.options.get(SELECTION).method_25306();
        }
        return false;
    }

    private void scroll(int target, boolean animate) {
        SELECTION = target;
        if (this.targetScroll == (target *= 4)) {
            return;
        }
        this.targetScroll = target;
        if (!animate) {
            this.prevScrollPosition = this.scrollPosition = this.targetScroll;
        } else {
            TribeSelectionScreen.playSound((class_6880.class_6883)class_3417.field_15015);
        }
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25432() {
        if (!this.finished && this.field_22787 != null) {
            this.field_22787.execute(() -> {
                this.finished = true;
                this.field_22787.method_1507((class_437)this);
                this.finished = false;
            });
        }
    }

    static class Link
    extends Label
    implements class_8021 {
        public Link(int x, int y) {
            super(x, y);
        }

        protected boolean method_25351(int button) {
            return button == 0;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return this.getBounds().contains(mouseX, mouseY);
        }

        public class_8030 method_48202() {
            return new class_8030(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float partialTicks) {
            this.field_22762 = this.method_25405(mouseX, mouseY);
            this.getStyle().setColor(this.method_25367() ? -4539718 : -8355712);
            super.method_48579(context, mouseX, mouseY, partialTicks);
        }
    }
}

