/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui.spellbook;

import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.util.render.RenderLayerUtil;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.SpellbookRecipe;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.client.gui.ItemTraitsTooltipRenderer;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookScreen;
import com.minelittlepony.unicopia.client.render.RenderLayers;
import com.minelittlepony.unicopia.container.SpellbookState;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5244;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9334;

public class IngredientTree
implements SpellbookRecipe.CraftingTreeBuilder {
    private static final List<class_2561> EMPTY_LINES = List.of(class_5244.field_39003);
    private static final Tooltip EMPTY_TOOLTIP = Tooltip.of(EMPTY_LINES);
    private final List<Entry> entries = new ArrayList<Entry>();
    private Optional<Entry> result = Optional.empty();
    private final int x;
    private final int y;
    private final int width;
    private boolean addLabels = true;
    private boolean obfuscateResult;

    public IngredientTree(int x, int y, int width) {
        this.x = x + 4;
        this.y = y;
        this.width = width - 5;
    }

    public IngredientTree noLabels() {
        this.addLabels = false;
        return this;
    }

    public IngredientTree obfuscateResult(boolean obfuscateResult) {
        this.obfuscateResult = obfuscateResult;
        return this;
    }

    @Override
    public void input(class_1799 ... stacks) {
        if (stacks.length > 0) {
            this.entries.add(Entry.of(stacks));
        }
    }

    @Override
    public void input(Trait ... traits) {
        if (traits.length > 0) {
            this.entries.add(Entry.of(1.0f, traits));
        }
    }

    @Override
    public void input(Trait trait, float value) {
        if (value != 0.0f) {
            this.entries.add(new Traits(trait, value));
        }
    }

    @Override
    public void mystery(class_1799 ... stacks) {
        if (stacks.length > 0) {
            this.entries.add(Multiple.of((Entry[])Arrays.stream(stacks).map(HiddenStacks::new).toArray(Entry[]::new)));
        }
    }

    @Override
    public void result(class_1799 ... stacks) {
        if (stacks.length > 0) {
            this.result = Optional.of(Entry.of(stacks));
        }
    }

    public int build(IViewRoot container) {
        if (this.entries.isEmpty()) {
            return 0;
        }
        int ii = 0;
        int colWidth = 22;
        int rowHeight = 20;
        int cols = Math.max(1, this.width / colWidth - 1);
        int rows = Math.max(1, (int)Math.ceil((float)this.entries.size() / (float)cols));
        int totalHeight = rowHeight * rows;
        for (Entry entry : this.entries) {
            int column = ii % cols;
            int row = ii / cols;
            int left = this.x + column * colWidth + 3 + (this.addLabels && row > 0 ? colWidth : 0);
            int top = this.y + row * rowHeight + 3;
            ((IngredientButton)container.addButton((class_364)new IngredientButton(left, top, colWidth, rowHeight, entry, !this.addLabels || ii == 0 ? "" : "+", false))).onClick(sender -> entry.onClick());
            ++ii;
        }
        this.result.ifPresent(result -> container.addButton((class_364)new IngredientButton(this.x + this.width - 17, this.y + totalHeight / 3 - 2, colWidth, totalHeight, (Entry)result, this.addLabels ? "=" : "", this.obfuscateResult)));
        return totalHeight + 7;
    }

    static interface Entry {
        public static Entry of(class_1799 ... stacks) {
            return Multiple.of((Entry[])Arrays.stream(stacks).map(Stacks::new).toArray(Entry[]::new));
        }

        public static Entry of(float value, Trait ... traits) {
            return Multiple.of((Entry[])Arrays.stream(traits).map(t -> new Traits((Trait)t, value)).toArray(Entry[]::new));
        }

        public void render(class_332 var1, int var2, int var3, float var4);

        public Tooltip getTooltip();

        public void onClick();
    }

    static class Traits
    implements Entry {
        private final Trait trait;
        private final float value;

        Traits(Trait trait, float value) {
            this.trait = trait;
            this.value = value;
        }

        @Override
        public void render(class_332 context, int x, int y, float tickDelta) {
            ItemTraitsTooltipRenderer.renderTraitIcon(this.trait, this.value, context, x, y);
        }

        @Override
        public Tooltip getTooltip() {
            return Tooltip.of((class_2561)(ItemTraitsTooltipRenderer.isKnown(this.trait) ? this.trait.getTooltip() : this.trait.getObfuscatedTooltip()), (int)200);
        }

        @Override
        public void onClick() {
            class_437 class_4372 = class_310.method_1551().field_1755;
            if (class_4372 instanceof SpellbookScreen) {
                SpellbookScreen spellbook = (SpellbookScreen)class_4372;
                spellbook.getState().setCurrentPageId(SpellbookState.TRAIT_DEX_ID);
                spellbook.getTraitDex().pageTo(spellbook, this.trait);
            }
        }
    }

    static class Multiple
    implements Entry {
        private int ticker;
        protected int index;
        protected final Entry[] entries;
        static final Entry EMPTY = new Entry(){

            @Override
            public void render(class_332 context, int mouseX, int mouseY, float tickDelta) {
            }

            @Override
            public void onClick() {
            }

            @Override
            public Tooltip getTooltip() {
                return EMPTY_TOOLTIP;
            }
        };

        static Entry of(Entry ... entries) {
            if (entries.length == 0) {
                return EMPTY;
            }
            if (entries.length == 1) {
                return entries[0];
            }
            return new Multiple(entries);
        }

        Multiple(Entry[] entries) {
            this.entries = entries;
        }

        @Override
        public void render(class_332 context, int x, int y, float tickDelta) {
            y -= 2;
            if (this.ticker++ % 30 == 0) {
                this.index = (this.index + 1) % this.entries.length;
            }
            this.entries[this.index].render(context, x, y, tickDelta);
        }

        @Override
        public Tooltip getTooltip() {
            return () -> this.entries[this.index].getTooltip().getLines();
        }

        @Override
        public void onClick() {
            this.entries[this.index].onClick();
        }
    }

    static class IngredientButton
    extends Button {
        private final Entry entry;
        private String label;

        public IngredientButton(int x, int y, int width, int height, Entry entry, String label, boolean obfuscated) {
            super(x, y, width, height);
            this.entry = entry;
            this.label = label;
            Tooltip tooltip = entry.getTooltip();
            if (tooltip != null) {
                this.getStyle().setTooltip(obfuscated ? Tooltip.of((String)"???") : tooltip);
            }
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float tickDelta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            context.method_25290(SpellbookScreen.SLOT, this.method_46426() - 8, this.method_46427() - 10, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_51433(this.getFont(), this.label, this.method_46426() - class_310.method_1551().field_1772.method_1727(this.label) / 2 - 3, this.method_46427() + 4, 0, false);
            this.entry.render(context, this.method_46426(), this.method_46427(), tickDelta);
        }
    }

    static class HiddenStacks
    extends Stacks {
        HiddenStacks(class_1799 stack) {
            super(stack);
        }

        @Override
        protected void drawItem(class_332 context, int x, int y) {
            if (this.stack.method_7960()) {
                return;
            }
            class_1087 model = this.itemRenderer.method_4019(this.stack, (class_1937)class_310.method_1551().field_1687, (class_1309)class_310.method_1551().field_1724, 0);
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416((float)(x + 8), (float)(y + 8), 150.0f);
            try {
                boolean bl;
                matrices.method_22905(16.0f, -16.0f, 16.0f);
                boolean bl2 = bl = !model.method_24304();
                if (bl) {
                    class_308.method_24210();
                }
                class_4597.class_4598 immediate = context.method_51450();
                this.stack.method_57379(class_9334.field_49641, (Object)false);
                this.itemRenderer.method_23179(this.stack, class_811.field_4317, false, matrices, layer -> immediate.getBuffer(RenderLayerUtil.getTexture((class_1921)layer).map(texture -> RenderLayers.getMagicColored(texture, 0x9000000)).orElse(RenderLayers.getMagicColored(0x9000000))), 0, class_4608.field_21444, model);
                RenderSystem.disableDepthTest();
                context.method_51452();
                RenderSystem.enableDepthTest();
                if (bl) {
                    class_308.method_24211();
                }
            }
            catch (Throwable t) {
                throw new class_148((class_128)class_156.method_654((Object)class_128.method_560((Throwable)t, (String)"Rendering item"), report -> report.method_562("Item being rendered").method_577("Item Type", () -> String.valueOf(this.stack.method_7909())).method_577("Item Components", () -> String.valueOf(this.stack.method_57353())).method_577("Item Foil", () -> String.valueOf(this.stack.method_7958()))));
            }
            matrices.method_22909();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public Tooltip getTooltip() {
            return EMPTY_TOOLTIP;
        }
    }

    static class Stacks
    implements Entry {
        protected final class_1799 stack;
        protected final class_918 itemRenderer = class_310.method_1551().method_1480();

        Stacks(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public void render(class_332 context, int x, int y, float tickDelta) {
            this.drawItem(context, x, y - 2);
        }

        protected void drawItem(class_332 context, int x, int y) {
            context.method_51427(this.stack, x, y);
        }

        @Override
        public Tooltip getTooltip() {
            return () -> {
                if (this.stack.method_7960()) {
                    return EMPTY_LINES;
                }
                return this.stack.method_7950(class_1792.class_9635.method_59528((class_1937)class_310.method_1551().field_1687), (class_1657)class_310.method_1551().field_1724, (class_1836)class_1836.field_41070);
            };
        }

        @Override
        public void onClick() {
        }
    }
}

