/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui.spellbook;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.client.gui.sprite.ISprite;
import com.minelittlepony.common.client.gui.sprite.TextureSprite;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.client.gui.ItemTraitsTooltipRenderer;
import com.minelittlepony.unicopia.client.gui.SpellIconRenderer;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookChapterList;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookCraftingPageContent;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookProfilePageContent;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookTabBar;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookTraitDexPageContent;
import com.minelittlepony.unicopia.compat.trinkets.TrinketSlotBackSprites;
import com.minelittlepony.unicopia.container.SpellbookScreenHandler;
import com.minelittlepony.unicopia.container.SpellbookState;
import com.minelittlepony.unicopia.container.inventory.SpellSlot;
import com.minelittlepony.unicopia.container.inventory.SpellbookSlot;
import com.minelittlepony.unicopia.container.spellbook.TabSide;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgSpellbookStateChanged;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.IntConsumer;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_507;
import net.minecraft.class_518;
import net.minecraft.class_5253;
import net.minecraft.class_757;

public class SpellbookScreen
extends class_465<SpellbookScreenHandler>
implements class_518 {
    public static final class_2960 TEXTURE = Unicopia.id("textures/gui/container/book.png");
    public static final class_2960 SLOT = Unicopia.id("textures/gui/container/slot.png");
    public static final class_2960 GEM = Unicopia.id("textures/item/gemstone.png");
    private static final int CONTENT_PADDING = 30;
    public static final int TITLE_X = 30;
    public static final int TITLE_Y = 20;
    public static final int TITLE_COLOR = -12566464;
    private final class_507 recipeBook = new class_507();
    private final SpellbookTraitDexPageContent traitDex = new SpellbookTraitDexPageContent(this);
    private final SpellbookChapterList chapters = new SpellbookChapterList(this, new SpellbookChapterList.Chapter(SpellbookState.CRAFTING_ID, TabSide.LEFT, 0, 0, Optional.of(new SpellbookCraftingPageContent(this))), new SpellbookChapterList.Chapter(SpellbookState.PROFILE_ID, TabSide.LEFT, 1, 0, Optional.of(new SpellbookProfilePageContent(this))), new SpellbookChapterList.Chapter(SpellbookState.TRAIT_DEX_ID, TabSide.LEFT, 3, 0, Optional.of(this.traitDex)));
    private final SpellbookTabBar tabs = new SpellbookTabBar(this, this.chapters);
    private Bounds contentBounds = Bounds.empty();

    public SpellbookScreen(SpellbookScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 405;
        this.field_2779 = 219;
        this.contentBounds = new Bounds(30, 30, this.field_2792 - 60, this.field_2779 - 90 - 2);
        handler.getSpellbookState().setSynchronizer(state -> Channel.CLIENT_SPELLBOOK_UPDATE.sendToServer(MsgSpellbookStateChanged.create(handler, state)));
    }

    public SpellbookState getState() {
        return ((SpellbookScreenHandler)this.field_2797).getSpellbookState();
    }

    public SpellbookTraitDexPageContent getTraitDex() {
        return this.traitDex;
    }

    public void addPageButtons(int buttonY, int prevX, int nextX, IntConsumer pageAction) {
        this.method_37063((class_364)new PageButton(this, this.field_2776 + nextX, this.field_2800 + buttonY, 1, pageAction));
        this.method_37063((class_364)new PageButton(this, this.field_2776 + prevX, this.field_2800 + buttonY, -1, pageAction));
    }

    public int getX() {
        return this.field_2776;
    }

    public int getY() {
        return this.field_2800;
    }

    public int getBackgroundWidth() {
        return this.field_2792;
    }

    public int getBackgroundHeight() {
        return this.field_2779;
    }

    public Bounds getFrameBounds() {
        return this.contentBounds;
    }

    public <T extends class_4068> T method_37060(T drawable) {
        return (T)super.method_37060(drawable);
    }

    public void method_25426() {
        super.method_25426();
        this.tabs.init();
        this.chapters.getCurrentChapter().content().ifPresent(content -> content.init(this, this.chapters.getCurrentChapter().id()));
    }

    public void method_16891() {
        this.chapters.getCurrentChapter().content().map(i -> i instanceof RecipesChangedListener ? (RecipesChangedListener)((Object)i) : null).ifPresent(RecipesChangedListener::onRecipesChanged);
    }

    public class_507 method_2659() {
        return this.recipeBook;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        if (this.getState().isDirty()) {
            this.method_41843();
        }
        super.method_25394(context, mouseX, mouseY, partialTicks);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_25290(TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 256);
        this.tabs.getAllTabs().forEach(tab -> {
            Bounds bounds = tab.bounds();
            boolean hover = bounds.contains((double)mouseX, (double)mouseY);
            int color = tab.chapter().color() & 0xFFFFFF;
            int v = 100 + (hover ? 24 : 0);
            if (color == 0xFFFFFF || color == 0) {
                v += 48;
            } else {
                RenderSystem.setShaderColor((float)((float)class_5253.class_8045.method_48345((int)color) / 255.0f), (float)((float)class_5253.class_8045.method_48346((int)color) / 255.0f), (float)((float)class_5253.class_8045.method_48347((int)color) / 255.0f), (float)1.0f);
            }
            boolean isRight = tab.chapter().side() == TabSide.RIGHT;
            context.method_25290(TEXTURE, bounds.left, bounds.top, isRight ? (float)(510 - bounds.width) : 402.0f, (float)v, bounds.width, bounds.height, 512, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float widthScale = (float)bounds.width / 35.0f;
            int resolution = (int)(16.0f * widthScale);
            int iconInset = (int)(Math.min(widthScale * 2.0f, 1.0f) * 10.0f);
            context.method_25290(tab.icon().get(), isRight ? bounds.left + bounds.width - resolution - iconInset : bounds.left + iconInset, bounds.top + (bounds.height - resolution) / 2, 0.0f, 0.0f, resolution, resolution, resolution, resolution);
            if (bounds.contains((double)mouseX, (double)mouseY)) {
                this.method_47415((class_2561)class_2561.method_43471((String)class_156.method_646((String)"chapter", (class_2960)tab.chapter().id())));
            }
        });
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.field_2776, (float)this.field_2800, 0.0f);
        this.chapters.getCurrentChapter().content().ifPresent(content -> content.draw(context, mouseX, mouseY, (IViewRoot)this));
        matrices.method_22909();
    }

    protected void method_2380(class_332 context, int x, int y) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        class_1735 class_17352 = this.field_2787;
        if (!(class_17352 instanceof SpellSlot)) {
            super.method_2380(context, x, y);
            return;
        }
        SpellSlot sp = (SpellSlot)class_17352;
        CustomisedSpellType<?> spell = sp.getSpell();
        if (spell.isEmpty()) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.unicopia.spellbook.empty_spell_slot"), x, y);
            return;
        }
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add(spell.type().getName());
        spell.method_57409(class_1792.class_9635.method_59528((class_1937)this.field_22787.field_1687), tooltip::add, (class_1836)class_1836.field_41070);
        context.method_51434(this.field_22793, tooltip, x, y);
        context.method_51448().method_22909();
    }

    void drawSlots(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.field_2776, (float)this.field_2800, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        for (class_1735 slot : ((SpellbookScreenHandler)this.field_2797).field_7761) {
            SpellSlot sp;
            CustomisedSpellType<?> spell;
            class_2960 foreground;
            if (!slot.method_7682() || !(slot instanceof SpellbookSlot)) continue;
            SpellbookSlot p = (SpellbookSlot)slot;
            context.method_25290(SLOT, slot.field_7873 - 8, slot.field_7872 - 8, 0.0f, 0.0f, 32, 32, 32, 32);
            if (slot.method_7677().method_7960() && (foreground = p.getForegroundIdentifier()) != null) {
                if (p.isTrinket()) {
                    foreground = TrinketSlotBackSprites.getBackSprite(foreground);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)p.getBackSpriteOpacity());
                context.method_25290(foreground, slot.field_7873, slot.field_7872, 0.0f, 0.0f, 16, 16, 16, 16);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (slot instanceof SpellSlot && !(spell = (sp = (SpellSlot)slot).getSpell()).isEmpty()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                context.method_51448().method_22903();
                context.method_51448().method_46416(0.0f, 0.0f, 260.0f);
                SpellIconRenderer.renderSpell(context, spell, slot.field_7873, slot.field_7872, 0.5f);
                context.method_51448().method_22909();
                RenderSystem.enableBlend();
            }
            if (!p.showTraits()) continue;
            float weight = p.getWeight();
            ItemTraitsTooltipRenderer.renderStackTraits(slot.method_7677(), context, slot.field_7873, slot.field_7872, weight == 0.0f ? 1.0f : weight, delta, slot.field_7874);
            RenderSystem.enableBlend();
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.method_22909();
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.tabs.getAllTabs().anyMatch(tab -> {
            if (tab.bounds().contains(mouseX, mouseY) && this.chapters.getCurrentChapter() != tab.chapter()) {
                this.getState().setCurrentPageId(tab.chapter().id());
                GameGui.playSound((class_3414)USounds.Vanilla.field_17481);
                this.method_41843();
                return true;
            }
            return false;
        }) || super.method_25402(mouseX, mouseY, button);
    }

    protected void method_41843() {
        super.method_41843();
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.method_19355(mouseX, mouseY).filter(element -> {
            this.method_25398(false);
            return element.method_25406(mouseX, mouseY, button);
        }).isPresent() || super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.method_25399() != null && this.method_25397() && button == 0 && this.method_25399().method_25403(mouseX, mouseY, button, deltaX, deltaY) || super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private static class PageButton
    extends ImageButton {
        private final int increment;
        private final TextureSprite sprite = new TextureSprite().setSize(25, 13).setTextureSize(512, 256).setTextureOffset(0, 479).setTexture(TEXTURE);

        public PageButton(SpellbookScreen screen, int x, int y, int increment, IntConsumer pageAction) {
            super(x, y, 25, 20);
            this.increment = increment;
            this.getStyle().setIcon((ISprite)this.sprite);
            this.onClick(sender -> {
                pageAction.accept(increment);
                screen.method_41843();
            });
        }

        @Override
        public void method_48579(class_332 context, int mouseX, int mouseY, float tickDelta) {
            if (!this.field_22763) {
                return;
            }
            int state = this.field_22762 ? 1 : 0;
            this.sprite.setTextureOffset(23 * state, (int)(485.5f - (float)this.increment * 6.5f));
            super.method_48579(context, mouseX, mouseY, tickDelta);
        }
    }

    public static interface RecipesChangedListener {
        public void onRecipesChanged();
    }

    static class ImageButton
    extends Button {
        public ImageButton(int x, int y) {
            super(x, y);
        }

        public ImageButton(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float tickDelta) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            if (this.getStyle().hasIcon()) {
                this.getStyle().getIcon().render(context, this.method_46426(), this.method_46427(), mouseX, mouseY, tickDelta);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

