/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui.spellbook;

import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookChapterList;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookScreen;
import com.minelittlepony.unicopia.container.spellbook.TabSide;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public class SpellbookTabBar {
    private final SpellbookScreen screen;
    private final SpellbookChapterList chapters;
    private final Map<TabSide, List<Tab>> bars = new EnumMap<TabSide, List<Tab>>(TabSide.class);

    public SpellbookTabBar(SpellbookScreen screen, SpellbookChapterList chapters) {
        this.screen = screen;
        this.chapters = chapters;
    }

    public void init() {
        this.bars.clear();
        Stream.of(TabSide.values()).forEach(side -> this.bars.put((TabSide)((Object)side), this.buildTabList((TabSide)((Object)side))));
    }

    public Stream<Tab> getAllTabs() {
        return this.bars.values().stream().flatMap(l -> l.stream());
    }

    private List<Tab> buildTabList(TabSide side) {
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        int backgroundHeight = this.screen.getBackgroundHeight();
        int backgroundWidth = this.screen.getBackgroundWidth();
        int tabInset = 14 + Math.min((this.screen.field_22789 - backgroundWidth) / 2, 0);
        int top = (this.screen.field_22790 - backgroundHeight) / 2 + 20;
        int left = (this.screen.field_22789 - backgroundWidth) / 2;
        int tabWidth = Math.min(35, left + 15);
        int tabHeight = 23;
        List<SpellbookChapterList.Chapter> leftTabs = this.chapters.getTabs(side).sorted(Comparator.comparing(SpellbookChapterList.Chapter::tabY)).toList();
        int totalTabs = leftTabs.size();
        float squashFactor = Math.min(1.0f, (float)(backgroundHeight - 40) / (float)((tabHeight + 8) * leftTabs.size()));
        for (int i = 0; i < totalTabs; ++i) {
            int tabY = (int)((float)(leftTabs.get(i).tabY() * tabHeight + i * 5) * squashFactor);
            int width = tabWidth;
            if (leftTabs.get(i) == this.chapters.getCurrentChapter()) {
                width += 3;
            }
            int xPosition = side == TabSide.LEFT ? left - width + tabInset : left + backgroundWidth - tabInset;
            SpellbookChapterList.Chapter chapter = leftTabs.get(i);
            class_2960 icon = SpellbookChapterList.Chapter.createIcon(chapter.id(), "");
            tabs.add(new Tab(leftTabs.get(i), new Bounds(top + tabY, xPosition, width, tabHeight), () -> chapter.content().map(content -> content.getIcon(chapter, icon)).orElse(icon)));
        }
        return tabs;
    }

    record Tab(SpellbookChapterList.Chapter chapter, Bounds bounds, Supplier<class_2960> icon) {
    }
}

